<?php 
/**
 * @link       https://onlinewebtutorblog.com
 * @since      1.0
 * @package    InspirePulse_Quotes
 * @subpackage InspirePulse_Quotes/admin/partials
 * @copyright  Copyright (c) 2025, Sanjay Kumar
 * @license    GPL-2.0+ https://www.gnu.org/licenses/gpl-2.0.html
 * @author     Online Web Tutor
 */
use owthub\inspqu\INSPQU_Layout;

if ( ! defined( 'ABSPATH' ) ) exit;
?>
<div class="inspqu-dashboard">

    <?php INSPQU_Layout::inspqu_get_dashboard_header(); ?>

    <main class="inspqu-cards-wrap">
        <div class="inspqu-cards-grid">

            <a href="<?php echo esc_url( admin_url( 'admin.php?page=inspqu-all-quotes' ) ); ?>"
               class="inspqu-card"
               data-tilt
               data-tilt-max="8">
                <div class="card-illu">💬</div>
                <h3><?php esc_html_e( 'All Quotes', 'inspirepulse-quotes' ); ?></h3>
                <p><?php esc_html_e( 'View and manage all your quotes.', 'inspirepulse-quotes' ); ?></p>
            </a>

            <a href="<?php echo esc_url( admin_url( 'admin.php?page=inspqu-categories' ) ); ?>"
               class="inspqu-card"
               data-tilt
               data-tilt-max="8">
                <div class="card-illu">📁</div>
                <h3><?php esc_html_e( 'Categories', 'inspirepulse-quotes' ); ?></h3>
                <p><?php esc_html_e( 'Organize quotes into categories.', 'inspirepulse-quotes' ); ?></p>
            </a>

            <a href="<?php echo esc_url( admin_url( 'admin.php?page=inspqu-add-quote' ) ); ?>"
               class="inspqu-card"
               data-tilt
               data-tilt-max="8">
                <div class="card-illu">➕</div>
                <h3><?php esc_html_e( 'Add New Quote', 'inspirepulse-quotes' ); ?></h3>
                <p><?php esc_html_e( 'Create a fresh inspirational quote.', 'inspirepulse-quotes' ); ?></p>
            </a>

            <a href="<?php echo esc_url( admin_url( 'admin.php?page=inspqu-settings' ) ); ?>"
               class="inspqu-card"
               data-tilt
               data-tilt-max="8">
                <div class="card-illu">⚙️</div>
                <h3><?php esc_html_e( 'Settings', 'inspirepulse-quotes' ); ?></h3>
                <p><?php esc_html_e( 'Customize plugin preferences.', 'inspirepulse-quotes' ); ?></p>
            </a>

        </div>
    </main>

    <?php INSPQU_Layout::inspqu_get_footer(); ?>

</div>
