<?php 
/**
 * @link       https://onlinewebtutorblog.com
 * @since      1.0
 * @package    InspirePulse_Quotes
 * @subpackage InspirePulse_Quotes/admin/partials
 * @copyright  Copyright (c) 2025, Sanjay Kumar
 * @license    GPL-2.0+ https://www.gnu.org/licenses/gpl-2.0.html
 * @author     Online Web Tutor
 */
use owthub\inspqu\INSPQU_Layout;

if ( ! defined( 'ABSPATH' ) ) exit;
?>
<div class="inspqu-dashboard">
    <main class="inspqu-cards-wrap">

        <div class="inspqu-header-card">
            <div class="inspqu-header">
                <h2><?php esc_html_e( 'Categories List', 'inspirepulse-quotes' ); ?></h2>

                <div class="inspqu-header-btns">
                    <a href="javascript:void(0);" class="inspqu-add-btn" id="inspqu-open-category-modal">
                        <span class="inspqu-add-icon">📁</span>
                        <?php esc_html_e( 'Add New Category', 'inspirepulse-quotes' ); ?>
                    </a>

                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=inspqu-add-quote' ) ); ?>" class="inspqu-add-btn">
                        <span class="inspqu-add-icon">＋</span>
                        <?php esc_html_e( 'Add New Quote', 'inspirepulse-quotes' ); ?>
                    </a>
                </div>
            </div>
        </div>

        <div class="inspqu-data-card">
            <div class="inspqu-table-top">
                <input
                    type="text"
                    id="inspqu-search"
                    placeholder="<?php echo esc_attr__( 'Search...', 'inspirepulse-quotes' ); ?>"
                />
            </div>

            <div class="inspqu-table-wrap">
                <table id="inspqu-table" class="inspqu-table">
                    <thead>
                        <tr>
                            <th><?php esc_html_e( 'ID', 'inspirepulse-quotes' ); ?></th>
                            <th><?php esc_html_e( 'Category', 'inspirepulse-quotes' ); ?></th>
                            <th><?php esc_html_e( 'Total Quotes', 'inspirepulse-quotes' ); ?></th>
                            <th><?php esc_html_e( 'Status', 'inspirepulse-quotes' ); ?></th>
                            <th><?php esc_html_e( 'Action', 'inspirepulse-quotes' ); ?></th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php if ( ! empty( $inspqu_categories ) ) : ?>
                            <?php foreach ( $inspqu_categories as $inspqu_single_cat ) :

                                $inspqu_status_label = ( intval( $inspqu_single_cat['status'] ) === 1 )
                                    ? __( 'Active', 'inspirepulse-quotes' )
                                    : __( 'Draft', 'inspirepulse-quotes' );

                                $inspqu_status_class = ( intval( $inspqu_single_cat['status'] ) === 1 )
                                    ? 'success'
                                    : 'draft';
                                ?>
                                <tr>
                                    <td><?php echo esc_html( absint( $inspqu_single_cat['id'] ) ); ?></td>
                                    <td><?php echo esc_html( $inspqu_single_cat['category_name'] ); ?></td>

                                    <td>
                                        <?php if ( intval( $inspqu_single_cat['total_quotes'] ) > 0 ) : ?>
                                            <?php 
                                            $inspqu_category_url = wp_nonce_url(
                                                add_query_arg(
                                                    [
                                                        'page'   => 'inspqu-all-quotes',
                                                        'cat_id' => absint( $inspqu_single_cat['id'] ),
                                                    ],
                                                    admin_url( 'admin.php' )
                                                ),
                                                'inspqu_filter_quotes',
                                                'inspqu_nonce'
                                            );
                                            ?>
                                            <a href="<?php echo esc_url( $inspqu_category_url ); ?>" class="inspqu-count-circle">
                                                <?php echo esc_html( absint( $inspqu_single_cat['total_quotes'] ) ); ?>
                                            </a>
                                        <?php else : ?>
                                            <span class="inspqu-count-circle disabled">
                                                <?php echo esc_html( absint( $inspqu_single_cat['total_quotes'] ) ); ?>
                                            </span>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <span class="inspqu-status <?php echo esc_attr( $inspqu_status_class ); ?>">
                                            <?php echo esc_html( $inspqu_status_label ); ?>
                                        </span>
                                    </td>

                                    <td class="inspqu-actions">
                                        <a
                                            href="javascript:void(0);"
                                            class="inspqu-action-btn edit inspqu-edit-category"
                                            data-id="<?php echo esc_attr( absint( $inspqu_single_cat['id'] ) ); ?>"
                                            data-name="<?php echo esc_attr( $inspqu_single_cat['category_name'] ); ?>"
                                            data-status="<?php echo esc_attr( absint( $inspqu_single_cat['status'] ) ); ?>"
                                        >
                                            ✏️ <?php esc_html_e( 'Edit', 'inspirepulse-quotes' ); ?>
                                        </a>

                                        <?php if ( intval( $inspqu_single_cat['total_quotes'] ) === 0 ) : ?>
                                            <a
                                                href="javascript:void(0);"
                                                class="inspqu-action-btn delete inspqu-btn-delete-action"
                                                data-id="<?php echo esc_attr( absint( $inspqu_single_cat['id'] ) ); ?>"
                                                data-module="categories"
                                            >
                                                🗑️ <?php esc_html_e( 'Delete', 'inspirepulse-quotes' ); ?>
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else : ?>
                            <tr>
                                <td colspan="6" style="text-align:center; padding:20px; color:#888;">
                                    <?php esc_html_e( 'No Category Found.', 'inspirepulse-quotes' ); ?>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div id="inspqu-category-modal" class="inspqu-modal">
            <div class="inspqu-modal-content">

                <div class="inspqu-modal-header">
                    <h2 id="inspqu-modal-title"><?php esc_html_e( 'Add New Category', 'inspirepulse-quotes' ); ?></h2>
                    <span class="inspqu-modal-close">&times;</span>
                </div>

                <form id="inspqu-category-form" action="javascript:void(0);" class="inspqu-modal-form">

                    <div class="inspqu-form-group">
                        <label><?php esc_html_e( 'Category Name', 'inspirepulse-quotes' ); ?></label>
                        <input
                            type="text"
                            id="category_name"
                            name="category_name"
                            required
                            placeholder="<?php echo esc_attr__( 'Enter category name...', 'inspirepulse-quotes' ); ?>"
                        >
                    </div>

                    <div class="inspqu-form-group">
                        <label><?php esc_html_e( 'Status', 'inspirepulse-quotes' ); ?></label>
                        <select name="status" required>
                            <option value="1"><?php esc_html_e( 'Active', 'inspirepulse-quotes' ); ?></option>
                            <option value="0"><?php esc_html_e( 'Draft', 'inspirepulse-quotes' ); ?></option>
                        </select>
                    </div>

                    <button class="inspqu-modal-btn">
                        <?php esc_html_e( 'Save Category', 'inspirepulse-quotes' ); ?>
                    </button>

                </form>
            </div>
        </div>

    </main>

    <?php INSPQU_Layout::inspqu_get_footer(); ?>
</div>
