<?php 
/**
 * @link       https://onlinewebtutorblog.com
 * @since      1.0
 * @package    InspirePulse_Quotes
 * @subpackage InspirePulse_Quotes/admin/partials
 * @copyright  Copyright (c) 2025, Sanjay Kumar
 * @license    GPL-2.0+ https://www.gnu.org/licenses/gpl-2.0.html
 * @author     Online Web Tutor
 */
use owthub\inspqu\INSPQU_Layout;

if ( ! defined( 'ABSPATH' ) ) exit;
?>
<div class="inspqu-dashboard">
    <main class="inspqu-cards-wrap">
        <div class="inspqu-header-card">
            <div class="inspqu-header">
                <h2><?php esc_html_e('Backup List', 'inspirepulse-quotes'); ?></h2>
                <div class="inspqu-header-btns">
                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=inspqu-settings' ) ); ?>" class="inspqu-add-btn inspqu-back-btn">
                        <span class="inspqu-add-icon">⬅️</span> <?php esc_html_e('Back to Settings', 'inspirepulse-quotes'); ?>
                    </a>
                </div>
            </div>
        </div>

        <div class="inspqu-data-card">
            <div class="inspqu-table-top">
                <input type="text" id="inspqu-search" placeholder="<?php echo esc_attr__( 'Search...', 'inspirepulse-quotes' ); ?>" />
            </div>
            <div class="inspqu-table-wrap">
                <table id="inspqu-table" class="inspqu-table">
                    <thead>
                        <tr>
                            <th><?php esc_html_e('ID', 'inspirepulse-quotes'); ?></th>
                            <th><?php esc_html_e('Filename', 'inspirepulse-quotes'); ?></th>
                            <th><?php esc_html_e('Filesize', 'inspirepulse-quotes'); ?></th>
                            <th><?php esc_html_e('Action', 'inspirepulse-quotes'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($inspqu_backups)) : ?>
                            <?php foreach ($inspqu_backups as $inspqu_single_bkp) : ?>
                            <tr>
                                <td><?php echo esc_html($inspqu_single_bkp['id']); ?></td>
                                <td><?php echo esc_html($inspqu_single_bkp['filename']); ?></td>
                                <td><?php echo esc_html($inspqu_single_bkp['filesize']); ?></td>
                                <td class="inspqu-actions">
                                    <a href="<?php echo esc_url($inspqu_single_bkp['filepath']); ?>"
                                       download
                                       class="inspqu-action-btn download inspqu-download-backup"
                                       data-id="<?php echo esc_attr($inspqu_single_bkp['id']); ?>">
                                        ⬇️ <?php esc_html_e('Download', 'inspirepulse-quotes'); ?>
                                    </a>
                                    <a href="javascript:void(0)" 
                                       class="inspqu-action-btn delete inspqu-btn-delete-action"
                                       data-id="<?php echo esc_attr($inspqu_single_bkp['id']); ?>"
                                       data-module="backups">
                                        🗑️ <?php esc_html_e('Delete', 'inspirepulse-quotes'); ?>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else : ?>
                        <tr>
                            <td colspan="6" style="text-align:center; padding:20px; color:#888;">
                                <?php esc_html_e('No Backup Found.', 'inspirepulse-quotes'); ?>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>
    <?php INSPQU_Layout::inspqu_get_footer(); ?>
</div>