<?php 
/**
 * @link       https://onlinewebtutorblog.com
 * @since      1.0
 * @package    InspirePulse_Quotes
 * @subpackage InspirePulse_Quotes/admin/partials
 * @copyright  Copyright (c) 2025, Sanjay Kumar
 * @license    GPL-2.0+ https://www.gnu.org/licenses/gpl-2.0.html
 * @author     Online Web Tutor
 */
use owthub\inspqu\INSPQU_Layout;

if ( ! defined( 'ABSPATH' ) ) exit;
?>
<div class="inspqu-dashboard">
    <?php 
        // Detect edit mode
        $inspqu_is_edit = !empty($inspqu_quote) && !empty($inspqu_quote['id']);
        $inspqu_page_title = $inspqu_is_edit ? __( 'Edit Quote', 'inspirepulse-quotes' ) : __( 'Add New Quote', 'inspirepulse-quotes' );
        $inspqu_button_text = $inspqu_is_edit ? '🔄 ' . __( 'Update Quote', 'inspirepulse-quotes' ) : '💾 ' . __( 'Save Quote', 'inspirepulse-quotes' );

        $inspqu_quote_author = $inspqu_quote['quote_author'] ?? "";
        $inspqu_quote_text   = $inspqu_quote['quote_text'] ?? "";
        $inspqu_quote_cat    = $inspqu_quote['category_id'] ?? "";
    ?>

    <main class="inspqu-cards-wrap">

        <div class="inspqu-header-card">
            <div class="inspqu-header">
                <h2><?php echo esc_html($inspqu_page_title); ?></h2>
                <div class="inspqu-header-btns">
                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=inspqu-all-quotes' ) ); ?>" class="inspqu-add-btn alt">
                        <span class="inspqu-add-icon">👁️</span>
                        <?php esc_html_e( 'View My Quotes', 'inspirepulse-quotes' ); ?>
                    </a>

                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=inspqu-categories' ) ); ?>" class="inspqu-add-btn alt">
                        <span class="inspqu-add-icon">📁</span>
                        <?php esc_html_e( 'View Categories', 'inspirepulse-quotes' ); ?>
                    </a>
                </div>
            </div>
        </div>

        <div class="inspqu-data-card">

            <form class="inspqu-form" id="inspqu-form" action="javascript:void(0);">

                <?php if ($inspqu_is_edit): ?>
                    <input type="hidden" name="id" value="<?php echo esc_attr($inspqu_quote['id']); ?>">
                <?php endif; ?>

                <div class="inspqu-row">

                    <!-- Author -->
                    <div class="inspqu-form-group">
                        <label for="quote_author"><?php esc_html_e('Author', 'inspirepulse-quotes'); ?></label>
                        <input type="text" 
                               id="quote_author" 
                               name="quote_author" 
                               value="<?php echo esc_attr($inspqu_quote_author); ?>" 
                               required>
                    </div>

                    <!-- Category -->
                    <div class="inspqu-form-group">
                        <label for="quote_category"><?php esc_html_e('Category', 'inspirepulse-quotes'); ?></label>
                        <select id="quote_category" name="quote_category" required>
                            <option value=""><?php esc_html_e('Select Category', 'inspirepulse-quotes'); ?></option>

                            <?php if (!empty($inspqu_categories)) : ?>
                                <?php foreach ($inspqu_categories as $inspqu_cat) : ?>
                                    <option value="<?php echo esc_attr($inspqu_cat['id']); ?>"
                                        <?php selected($inspqu_quote_cat, $inspqu_cat['id']); ?> >
                                        <?php echo esc_html($inspqu_cat['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            <?php endif; ?>

                        </select>
                    </div>

                </div>

                <!-- Quote Text -->
                <div class="inspqu-form-group">
                    <label for="quote_text"><?php esc_html_e('Quote Text', 'inspirepulse-quotes'); ?> <span>*</span></label>
                    <?php
                        wp_editor(
                            $inspqu_quote_text,
                            'quote_text',
                            [
                                'textarea_name' => 'quote_text',
                                'textarea_rows' => 6,
                                'media_buttons' => false,
                                'teeny' => true
                            ]
                        );
                    ?>
                </div>

                <button type="submit" class="inspqu-submit-btn">
                    <?php echo esc_html($inspqu_button_text); ?>
                </button>

            </form>

        </div>
    </main>

    <?php INSPQU_Layout::inspqu_get_footer(); ?>
</div>
