<?php 
/**
 * @link       https://onlinewebtutorblog.com
 * @since      1.0
 * @package    InspirePulse_Quotes
 * @subpackage InspirePulse_Quotes/admin/partials
 * @copyright  Copyright (c) 2025, Sanjay Kumar
 * @license    GPL-2.0+ https://www.gnu.org/licenses/gpl-2.0.html
 * @author     Online Web Tutor
 */
use owthub\inspqu\INSPQU_Layout;

if ( ! defined( 'ABSPATH' ) ) exit;
?>
<div class="inspqu-dashboard">
    <?php INSPQU_Layout::inspqu_get_about_header(); ?>
    <main class="inspqu-cards-wrap">
        <div class="inspqu-cards-grid inspqu-about-grid">
            <div class="inspqu-feature-card type-import">
                <div class="inspqu-icon-big">⚡</div>
                <h3><?php esc_html_e('One-Click Quote Import', 'inspirepulse-quotes'); ?></h3>
                <p><?php esc_html_e('Instantly loads curated inspirational quotes into your database.', 'inspirepulse-quotes'); ?></p>
            </div>
            <div class="inspqu-feature-card type-timer">
                <div class="inspqu-icon-big">⏱️</div>
                <h3><?php esc_html_e('Quote Timer Controls', 'inspirepulse-quotes'); ?></h3>
                <p><?php esc_html_e('Adjust slider rotation timing directly from plugin settings.', 'inspirepulse-quotes'); ?></p>
            </div>
            <div class="inspqu-feature-card type-quote">
                <div class="inspqu-icon-big">✍️</div>
                <h3><?php esc_html_e('Quote Manager', 'inspirepulse-quotes'); ?></h3>
                <p><?php esc_html_e('Add, edit, enable, or disable quotes effortlessly.', 'inspirepulse-quotes'); ?></p>
            </div>
            <div class="inspqu-feature-card type-category">
                <div class="inspqu-icon-big">📂</div>
                <h3><?php esc_html_e('Categories Manager', 'inspirepulse-quotes'); ?></h3>
                <p><?php esc_html_e('Create and organize categories to group inspiration smartly.', 'inspirepulse-quotes'); ?></p>
            </div>
            <div class="inspqu-feature-card type-filter">
                <div class="inspqu-icon-big">🔍</div>
                <h3><?php esc_html_e('Powerful Filters', 'inspirepulse-quotes'); ?></h3>
                <p><?php esc_html_e('Filter quotes by category, author, or both.', 'inspirepulse-quotes'); ?></p>
            </div>
            <div class="inspqu-feature-card type-layout">
                <div class="inspqu-icon-big">🖼️</div>
                <h3><?php esc_html_e('Stylish Layouts', 'inspirepulse-quotes'); ?></h3>
                <p><?php esc_html_e('Choose from beautiful quote templates for display on website.', 'inspirepulse-quotes'); ?></p>
            </div>
            <div class="inspqu-feature-card type-shortcode">
                <div class="inspqu-icon-big">🔗</div>
                <h3><?php esc_html_e('Dynamic Shortcodes', 'inspirepulse-quotes'); ?></h3>
                <p><?php esc_html_e('Copy paste smart shortcode to embed quotes anywhere.', 'inspirepulse-quotes'); ?></p>
            </div>
            <div class="inspqu-feature-card type-backup">
                <div class="inspqu-icon-big">💾</div>
                <h3><?php esc_html_e('SQL Data Backup', 'inspirepulse-quotes'); ?></h3>
                <p><?php esc_html_e('Create and download full quote database backup securely.', 'inspirepulse-quotes'); ?></p>
            </div>
            <div class="inspqu-feature-card type-advanced">
                <div class="inspqu-icon-big">🎯</div>
                <h3><?php esc_html_e('Advanced Shortcode Parameters', 'inspirepulse-quotes'); ?></h3>
                <p><?php esc_html_e('Filter by category, author, limit results, order quotes, and exclude specific quotes using powerful shortcode parameters.', 'inspirepulse-quotes'); ?></p>
            </div>
            <div class="inspqu-feature-card type-widget">
                <div class="inspqu-icon-big">🎛️</div>
                <h3><?php esc_html_e('WordPress Widget', 'inspirepulse-quotes'); ?></h3>
                <p><?php esc_html_e('Display quotes in any widget area with full customization options including design, timer, category, and author filters.', 'inspirepulse-quotes'); ?></p>
            </div>
            <div class="inspqu-feature-card type-gutenberg">
                <div class="inspqu-icon-big">🧩</div>
                <h3><?php esc_html_e('Gutenberg Block', 'inspirepulse-quotes'); ?></h3>
                <p><?php esc_html_e('Native Gutenberg block with visual settings panel for easy quote insertion and customization in the block editor.', 'inspirepulse-quotes'); ?></p>
            </div>
        </div>
    </main>
    <?php INSPQU_Layout::inspqu_get_footer(); ?>
</div>
