(function ($) {
    window.inspqu_helper = {
        confirmAlert: function (message, onConfirm, onCancel, allowHtml = false) {
            const i18n = window.inspqu_object?.i18n || {};
            Swal.fire({
                title: i18n.confirmTitle || 'Are you sure?',
                html: allowHtml ? message : null,
                text: allowHtml ? null : message,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: i18n.confirmYes || 'Yes',
                cancelButtonText: i18n.confirmNo || 'No'
            }).then((result) => {
                if (result.isConfirmed) {
                    if (typeof onConfirm === "function") onConfirm();
                } else if (result.dismiss === Swal.DismissReason.cancel) {
                    if (typeof onCancel === "function") onCancel();
                }
            });
        },

        toastr: function (message, type) {
            if (type === "success") {
                toastr.success(message);
            } else if (type === "error") {
                toastr.error(message);
            } else if (type === "warning") {
                toastr.warning(message);
            }
        },

        ajaxRequest: function (dataObj, onSuccess, onError) {
            $.ajax({
                url: inspqu_object.ajaxurl,
                method: 'POST',
                data: dataObj,
                dataType: 'json',
                beforeSend: function () {
                    $("#inspqu-loader").fadeIn(200);
                },
                success: function (response) {
                    if (typeof onSuccess === "function") {
                        onSuccess(response);
                        setTimeout(() => {
                            location.reload()
                        }, 1000);
                    }
                },
                error: function (xhr, status, error) {
                    console.error("AJAX Error:", error);
                    if (typeof onError === "function") onError(xhr, status, error);
                },
                complete: function () {
                    $("#inspqu-loader").fadeOut(200);
                }
            });
        },
    };
})(jQuery);
