(function(blocks, element, editor, components, i18n) {
    const { registerBlockType } = blocks;
    const { createElement: el } = element;
    const { InspectorControls, PanelColorSettings } = editor;
    const { PanelBody, SelectControl, TextControl, RangeControl, ToggleControl } = components;
    const { __ } = i18n;

    registerBlockType('inspqu/quotes', {
        title: __('InspirePulse Quotes', 'inspirepulse-quotes'),
        icon: 'format-quote',
        category: 'widgets',
        description: __('Display inspirational quotes with customizable design and settings.', 'inspirepulse-quotes'),
        attributes: {
            design: {
                type: 'string',
                default: 'default'
            },
            timer: {
                type: 'number',
                default: 0
            },
            category: {
                type: 'string',
                default: ''
            },
            author: {
                type: 'string',
                default: ''
            },
            limit: {
                type: 'number',
                default: 0
            },
            orderby: {
                type: 'string',
                default: 'random'
            },
            order: {
                type: 'string',
                default: 'ASC'
            },
            showSharing: {
                type: 'boolean',
                default: false
            }
        },
        edit: function(props) {
            const { attributes, setAttributes } = props;
            const { design, timer, category, author, limit, orderby, order, showSharing } = attributes;

            const designOptions = (inspquBlockData && inspquBlockData.designs) ? inspquBlockData.designs : [
                { value: 'default', label: __('Elegant Dark (Default)', 'inspirepulse-quotes') }
            ];

            const categoryOptions = (inspquBlockData && inspquBlockData.categories) ? 
                [{ value: '', label: __('All Categories', 'inspirepulse-quotes') }].concat(
                    inspquBlockData.categories.map(cat => ({
                        value: cat.name,
                        label: cat.name
                    }))
                ) : [{ value: '', label: __('All Categories', 'inspirepulse-quotes') }];

            const defaultTimer = (inspquBlockData && inspquBlockData.defaultTimer) ? inspquBlockData.defaultTimer : 7;

            return el('div', { className: 'inspqu-gutenberg-block' },
                el(InspectorControls, {},
                    el(PanelBody, { title: __('Quote Settings', 'inspirepulse-quotes'), initialOpen: true },
                        el(SelectControl, {
                            label: __('Design', 'inspirepulse-quotes'),
                            value: design,
                            options: designOptions,
                            onChange: (value) => setAttributes({ design: value })
                        }),
                        el(RangeControl, {
                            label: __('Timer (seconds)', 'inspirepulse-quotes'),
                            value: timer || defaultTimer,
                            min: 1,
                            max: 60,
                            onChange: (value) => setAttributes({ timer: value || 0 })
                        }),
                        el(SelectControl, {
                            label: __('Category', 'inspirepulse-quotes'),
                            value: category,
                            options: categoryOptions,
                            onChange: (value) => setAttributes({ category: value || '' })
                        }),
                        el(TextControl, {
                            label: __('Author', 'inspirepulse-quotes'),
                            value: author,
                            placeholder: __('e.g., Einstein, Steve Jobs', 'inspirepulse-quotes'),
                            onChange: (value) => setAttributes({ author: value || '' })
                        }),
                        el(RangeControl, {
                            label: __('Limit', 'inspirepulse-quotes'),
                            value: limit || 0,
                            min: 0,
                            max: 100,
                            onChange: (value) => setAttributes({ limit: value || 0 })
                        }),
                        el(SelectControl, {
                            label: __('Order By', 'inspirepulse-quotes'),
                            value: orderby,
                            options: [
                                { value: 'random', label: __('Random', 'inspirepulse-quotes') },
                                { value: 'date', label: __('Date', 'inspirepulse-quotes') },
                                { value: 'author', label: __('Author', 'inspirepulse-quotes') },
                                { value: 'id', label: __('ID', 'inspirepulse-quotes') }
                            ],
                            onChange: (value) => setAttributes({ orderby: value })
                        }),
                        orderby !== 'random' && el(SelectControl, {
                            label: __('Order', 'inspirepulse-quotes'),
                            value: order,
                            options: [
                                { value: 'ASC', label: __('Ascending', 'inspirepulse-quotes') },
                                { value: 'DESC', label: __('Descending', 'inspirepulse-quotes') }
                            ],
                            onChange: (value) => setAttributes({ order: value })
                        }),
                        el(ToggleControl, {
                            label: __('Show Social Sharing', 'inspirepulse-quotes'),
                            checked: showSharing,
                            onChange: (value) => setAttributes({ showSharing: value })
                        })
                    )
                ),
                el('div', { className: 'inspqu-block-preview' },
                    el('div', { className: 'inspqu-block-icon' }, '💬'),
                    el('div', { className: 'inspqu-block-content' },
                        el('h3', {}, __('InspirePulse Quotes', 'inspirepulse-quotes')),
                        el('p', {}, __('Quote display will appear here on the frontend.', 'inspirepulse-quotes')),
                        design !== 'default' && el('p', { className: 'inspqu-block-info' }, 
                            __('Design:', 'inspirepulse-quotes') + ' ' + (designOptions.find(d => d.value === design)?.label || design)
                        ),
                        timer > 0 && el('p', { className: 'inspqu-block-info' }, 
                            __('Timer:', 'inspirepulse-quotes') + ' ' + timer + 's'
                        ),
                        category && el('p', { className: 'inspqu-block-info' }, 
                            __('Category:', 'inspirepulse-quotes') + ' ' + category
                        ),
                        author && el('p', { className: 'inspqu-block-info' }, 
                            __('Author:', 'inspirepulse-quotes') + ' ' + author
                        )
                    )
                )
            );
        },
        save: function() {
            return null; // Rendered server-side
        }
    });
})(
    window.wp.blocks,
    window.wp.element,
    window.wp.editor,
    window.wp.components,
    window.wp.i18n
);

