jQuery(document).ready(function($) {

    $("#inspqu-search").on("keyup", function() {

        console.log(123);
        
        var value = $(this).val().toLowerCase();

        $("#inspqu-table tbody tr").filter(function() {
            $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
        });
    });

    $('#inspqu-form').validate();
    $('#inspqu-category-form').validate();
    $('#inspqu-timer-form').validate();

    $('#inspqu-form').on('submit', function(event) {
        event.preventDefault();

        const content = quote_content();
        if (!content || content.length === 0) {
            const i18n = inspqu_object?.i18n || {};
            inspqu_helper.toastr(i18n.quoteContentEmpty || "Quote content cannot be empty!", "error");
            return false;
        }

        var $form = $(this);
        let formObj = {};
        $form.serializeArray().forEach(function(item) {
            formObj[item.name] = item.value;
        });

        const isEdit = formObj.id && parseInt(formObj.id) > 0;

        let form_data = {
            action: 'inspqu_ajax',
            param: isEdit ? 'inspqu_update_quote' : 'inspqu_add_quote',
            inspqu_nonce: inspqu_object.nonce,
            ...formObj,
            quote_text: content
        };

        inspqu_helper.ajaxRequest(form_data, function (response) {
            if (response.sts === 1) {
                inspqu_helper.toastr(response.msg, "success");
                if(isEdit){
                    setTimeout(() => location.reload(), 700);
                } else {
                    $('#quote_author').val('');
                    $('#quote_category').val('');
                    if (typeof tinymce !== 'undefined') tinymce.get('quote_text').setContent('');
                }
            } else {
                inspqu_helper.toastr(response.msg, "error");
            }
        });
    });

    $('#inspqu-category-form').on('submit', function(event){
        event.preventDefault();

        const content = $('#category_name').val();
        if (!content || content.length === 0) {
            const i18n = inspqu_object?.i18n || {};
            inspqu_helper.toastr(i18n.categoryNameEmpty || "Category name cannot be empty!", "error");
            return false;
        }

        var $form = $(this);
        let formObj = {};
        $form.serializeArray().forEach(function(item) {
            formObj[item.name] = item.value;
        });

        let editId = $form.attr('data-edit-id');
        let paramType = editId ? 'inspqu_update_category' : 'inspqu_add_category';

        if (editId) {
            formObj['id'] = editId;
        }

        let form_data = {
            action: 'inspqu_ajax',
            param: paramType,
            inspqu_nonce: inspqu_object.nonce,
            ...formObj
        };

        inspqu_helper.ajaxRequest(form_data, function (response) {
            if (response.sts === 1) {
                inspqu_helper.toastr(response.msg, "success");
            } else {
                inspqu_helper.toastr(response.msg, "error");
            }
        });
    });

    $('#inspqu-timer-form').on('submit', function(event){
        event.preventDefault();

        const seconds = $('#timer_seconds').val();
        if (!seconds || seconds.length === 0) {
            const i18n = inspqu_object?.i18n || {};
            inspqu_helper.toastr(i18n.delayTimerRequired || "Delay timer value required!", "error");
            return false;
        }

        var $form = $(this);
        let formObj = {};
        $form.serializeArray().forEach(function(item) {
            formObj[item.name] = item.value;
        });

        let form_data = {
            action: 'inspqu_ajax',
            param: 'inspqu_save_timer_seconds',
            inspqu_nonce: inspqu_object.nonce,
            ...formObj
        };

        inspqu_helper.ajaxRequest(form_data, function (response) {
            if (response.sts === 1) {
                inspqu_helper.toastr(response.msg, "success");
                setTimeout(() => {
                    $('#inspqu-timer-modal').fadeOut(300);
                }, 1000);
            } else {
                inspqu_helper.toastr(response.msg, "error");
            }
        });
    });

    $('#inspqu-import-form').on('submit', function(event){
        event.preventDefault();

        const fileInput = $('#backup_file')[0];
        if (!fileInput.files || fileInput.files.length === 0) {
            const i18n = inspqu_object?.i18n || {};
            inspqu_helper.toastr(i18n.noFileSelected || "Please select a backup file.", "error");
            return false;
        }

        const file = fileInput.files[0];
        const fileExt = file.name.split('.').pop().toLowerCase();
        
        if (fileExt !== 'sql') {
            const i18n = inspqu_object?.i18n || {};
            inspqu_helper.toastr(i18n.invalidFileType || "Invalid file type. Only .sql files are allowed.", "error");
            return false;
        }

        if (! $('#confirm_import').is(':checked')) {
            const i18n = inspqu_object?.i18n || {};
            inspqu_helper.toastr(i18n.confirmImportRequired || "Please confirm that you understand importing will replace your current data.", "error");
            return false;
        }

        const formData = new FormData();
        formData.append('action', 'inspqu_ajax');
        formData.append('param', 'inspqu_import_backup');
        formData.append('inspqu_nonce', inspqu_object.nonce);
        formData.append('backup_file', file);
        formData.append('create_backup_before_import', $('#create_backup_before_import').is(':checked') ? 'on' : 'off');
        formData.append('confirm_import', $('#confirm_import').is(':checked') ? 'on' : 'off');

        // Show loading
        $("#inspqu-loader").fadeIn(200);

        $.ajax({
            url: inspqu_object.ajaxurl,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function(response) {
                $("#inspqu-loader").fadeOut(200);
                if (response.sts === 1) {
                    inspqu_helper.toastr(response.msg, "success");
                    setTimeout(() => {
                        $('#inspqu-import-modal').fadeOut(300);
                        $('#inspqu-import-form')[0].reset();
                        location.reload();
                    }, 1500);
                } else {
                    inspqu_helper.toastr(response.msg, "error");
                }
            },
            error: function(xhr, status, error) {
                $("#inspqu-loader").fadeOut(200);
                const i18n = inspqu_object?.i18n || {};
                inspqu_helper.toastr(i18n.importFailed || "Failed to import backup. Please try again.", "error");
            }
        });
    });

    $('#inspqu-open-category-modal').on('click', function () {
        const i18n = inspqu_object?.i18n || {};
        $('#inspqu-modal-title').text(i18n.addNewCategory || 'Add New Category');
        $('#inspqu-category-form')[0].reset();
        $('#inspqu-category-form').attr('data-edit-id', ''); // no edit
        $('#inspqu-category-modal').fadeIn();
    });

    $('#inspqu-open-timer-modal').on('click', function () {
        $('#inspqu-timer-modal').fadeIn();
    });

    $('#inspqu-open-import-modal').on('click', function () {
        $('#inspqu-import-modal').fadeIn();
        // Reset form
        $('#inspqu-import-form')[0].reset();
        $('#confirm_import').prop('checked', false);
        $('#create_backup_before_import').prop('checked', true);
    });

    $(".inspqu-modal-close").on("click", function() {
        if($("#inspqu-category-modal").length > 0){
            $("#inspqu-category-modal").fadeOut(300);   
        }
        if($("#inspqu-timer-modal").length > 0){
            $("#inspqu-timer-modal").fadeOut(300);   
        }
        if($("#inspqu-import-modal").length > 0){
            $("#inspqu-import-modal").fadeOut(300);
            $('#inspqu-import-form')[0].reset();
        }
    });

    $(document).on("click", ".inspqu-btn-delete-action", function(){
        let dataId = $(this).data('id');
        let moduleName = $(this).data('module');
        const i18n = inspqu_object?.i18n || {};
        inspqu_helper.confirmAlert(i18n.confirmDelete || "Are you sure want to delete?", function () {
            inspqu_helper.ajaxRequest({
                action: 'inspqu_ajax',
                param: 'inspqu_delete_data_action',
                rowId: dataId,
                module: moduleName,
                inspqu_nonce: inspqu_object.nonce,
            }, function (response) {
                inspqu_helper.toastr(response.msg || (response.sts ? (i18n.deletedSuccessfully || "Deleted successfully") : (i18n.deleteFailed || "Delete failed")), response.sts ? "success" : "error");
            });
        });
    });

    $(document).on('click', '.inspqu-edit-category', function () {

        let id     = $(this).data('id');
        let name   = $(this).data('name');
        let status = $(this).data('status');
        const i18n = inspqu_object?.i18n || {};

        $('#inspqu-modal-title').text(i18n.editCategory || 'Edit Category');
        $('#inspqu-category-form input[name="category_name"]').val(name);
        $('#inspqu-category-form select[name="status"]').val(status);

        $('#inspqu-category-form').attr('data-edit-id', id);

        // Open modal
        $('#inspqu-category-modal').fadeIn();
    });

    $('#inspqu-link-install-data, #inspqu-btn-reinstall-data').on('click', function() {
        let data_exists = $(this).data('exists');
        const i18n = inspqu_object?.i18n || {};
        let message = data_exists == 1 ? (i18n.confirmReinstall || 'Default Quotes already installed. Are you looking to Re-Install it?') : (i18n.confirmInstall || 'Are you sure want to install quotes?');
        inspqu_helper.confirmAlert(message, function () {
            inspqu_helper.ajaxRequest({
                action: 'inspqu_ajax',
                param: 'inspqu_install_default_quotes',
                data_exists,
                inspqu_nonce: inspqu_object.nonce,
            }, function (response) {
                inspqu_helper.toastr(response.msg || (response.sts ? (i18n.quotesImportedSuccessfully || "Quotes Imported Successfully!") : (i18n.failedToImport || "Failed to Import")), response.sts ? "success" : "error");
            });
        });
    });

    $('#inspqu-btn-remove-data').on('click', function(){
        const i18n = inspqu_object?.i18n || {};
        let message = i18n.confirmRemove || 'Are you sure want to Remove Test Quotes?';
        inspqu_helper.confirmAlert(message, function () {
            inspqu_helper.ajaxRequest({
                action: 'inspqu_ajax',
                param: 'inspqu_remove_default_quotes',
                inspqu_nonce: inspqu_object.nonce,
            }, function (response) {
                inspqu_helper.toastr(response.msg || (response.sts ? (i18n.quotesRemovedSuccessfully || "Quotes Removed Successfully!") : (i18n.failedToRemove || "Failed to Remove")), response.sts ? "success" : "error");
            });
        });
    });

    $('#inspqu-btn-generate-backup').on('click', function(){
        const i18n = inspqu_object?.i18n || {};
        let message = i18n.confirmBackup || 'This will generate a backup file of all database data\'s of this plugin.';
        inspqu_helper.confirmAlert(message, function () {
            inspqu_helper.ajaxRequest({
                action: 'inspqu_ajax',
                param: 'inspqu_generate_db_backup',
                inspqu_nonce: inspqu_object.nonce,
            }, function (response) {
                inspqu_helper.toastr(response.msg || (response.sts ? (i18n.backupGeneratedSuccessfully || "Backup Generated Successfully!") : (i18n.failedToGenerateBackup || "Failed to Generate Backup")), response.sts ? "success" : "error");
            });
        });
    });

    $('#adminmenu li').each(function () {
        let link = $(this).find('a').attr('href') || '';
        if (link.includes('page=inspqu')) {
            let slugMatch = link.match(/page=([^&]+)/); 
            if (slugMatch && slugMatch[1]) {
                let slug = slugMatch[1];
                let lastPart = slug.replace('inspqu-', '');
                $(this).addClass('inspqu-submenu-' + lastPart);
            }
        }
    });

    $(document).on('click', '.inspqu-preview-template', function(){
        let img = $(this).attr("data-img");
        $("#inspqu-modal-img").attr("src", img);
        $("#inspqu-template-modal").css("display", "flex").fadeIn(200);
    });

    if (inspqu_object?.remove_submenus.length > 0 && Array.isArray(inspqu_object.remove_submenus)) {
        inspqu_object.remove_submenus.forEach(function(cls){
            $('#adminmenu li.' + cls).remove();
        });
    }

    $(document).on("click", ".inspqu-preview-modal .inspqu-modal-close, #inspqu-template-modal", function(e){
        if (e.target !== this) return;
        $("#inspqu-template-modal").fadeOut(200);
    });

    $(document).on('click', '.inspqu-copy-shortcode', function () {
        let shortcode = $(this).attr('data-shortcode');
        const i18n = inspqu_object?.i18n || {};
        navigator.clipboard.writeText(shortcode).then(() => {
            inspqu_helper.toastr(i18n.shortcodeCopied || "Shortcode Copied Successfully", "success");
        }).catch(() => {
            inspqu_helper.toastr(i18n.shortcodeCopyFailed || "Failed to Copy Shortcode", "error");
        });
    });

    function quote_content() {
        if (typeof tinyMCE !== "undefined" && tinyMCE.get("quote_text")) {
            var content = tinyMCE.get("quote_text").getContent({ format: "text" }).trim();
        } else {
            var content = $("#quote_text").val().trim();
        }
        return content;
    }
});
