<?php
/**
 * Plugin Name: InsightPress - Advanced Analytics for WooCommerce
 * Description: Simple, lightweight analytics for your WooCommerce store. Visualize sales trends and order metrics effortlessly.
 * Version: 1.0.0
 * Author: Dominopress
 * Author URI: https://dominopress.com
 * Text Domain: insightpress-advanced-analytics-for-woocommerce
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * Requires Plugins: woocommerce
 * WC requires at least: 5.0
 * WC tested up to: 9.3
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// Define Constants
define('INSIGHTPRESS_ADVANCED_ANALYTICS_FOR_WOOCOMMERCE_VERSION', '1.0.0');
define('INSIGHTPRESS_ADVANCED_ANALYTICS_FOR_WOOCOMMERCE_FILE', __FILE__);
define('INSIGHTPRESS_ADVANCED_ANALYTICS_FOR_WOOCOMMERCE_PATH', plugin_dir_path(__FILE__));
define('INSIGHTPRESS_ADVANCED_ANALYTICS_FOR_WOOCOMMERCE_URL', plugin_dir_url(__FILE__));

// Check if WooCommerce is active
function insightpress_check_woocommerce()
{
    if (!class_exists('WooCommerce')) {
        add_action('admin_notices', 'insightpress_woocommerce_missing_notice');
        return;
    }
}
add_action('plugins_loaded', 'insightpress_check_woocommerce');

function insightpress_woocommerce_missing_notice()
{
    ?>
    <div class="error">
        <p><?php esc_html_e('InsightPress requires WooCommerce to be installed and active.', 'insightpress-advanced-analytics-for-woocommerce'); ?>
        </p>
    </div>
    <?php
}


// Declare HPOS compatibility
add_action('before_woocommerce_init', 'insightpress_declare_hpos_compatibility');
function insightpress_declare_hpos_compatibility()
{
    if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    }
}

// Include Admin Class
require_once INSIGHTPRESS_ADVANCED_ANALYTICS_FOR_WOOCOMMERCE_PATH . 'admin/class-insightpress-admin.php';

// Initialize Admin
function insightpress_init()
{
    if (class_exists('InsightPress_Admin')) {
        new InsightPress_Admin();
    }
}
add_action('plugins_loaded', 'insightpress_init');

// Add settings link on plugin page
function insightpress_add_action_links($links)
{
    $plugin_links = array(
        '<a href="' . admin_url('admin.php?page=insightpress') . '">' . __('Analytics', 'insightpress-advanced-analytics-for-woocommerce') . '</a>',
    );
    return array_merge($links, $plugin_links);
}
add_filter('plugin_action_links_' . plugin_basename(INSIGHTPRESS_ADVANCED_ANALYTICS_FOR_WOOCOMMERCE_FILE), 'insightpress_add_action_links');
