<?php
/**
 * Admin Class
 *
 * @package InsightPress
 */

if (!defined('ABSPATH')) {
    exit;
}

class InsightPress_Admin
{

    /**
     * Constructor.
     */
    public function __construct()
    {
        add_action('admin_menu', array($this, 'add_menu_page'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_styles'));
    }

    /**
     * Add menu page.
     */
    public function add_menu_page()
    {
        add_menu_page(
            __('InsightPress Dashboard', 'insightpress-advanced-analytics-for-woocommerce'),
            __('InsightPress', 'insightpress-advanced-analytics-for-woocommerce'),
            'manage_woocommerce',
            'insightpress',
            array($this, 'display_dashboard_page'),
            'dashicons-chart-area', // Icon
            56 // Position
        );
    }

    /**
     * Enqueue styles.
     */
    public function enqueue_styles($hook)
    {
        if ('toplevel_page_insightpress' !== $hook) {
            return;
        }

        wp_enqueue_style('insightpress-admin', INSIGHTPRESS_ADVANCED_ANALYTICS_FOR_WOOCOMMERCE_URL . 'assets/css/admin.css', array(), INSIGHTPRESS_ADVANCED_ANALYTICS_FOR_WOOCOMMERCE_VERSION);
    }

    /**
     * Display dashboard page.
     */
    public function display_dashboard_page()
    {

        // Get today's stats.
        $today_start = gmdate('Y-m-d 00:00:00', current_time('timestamp'));
        $today_end = gmdate('Y-m-d 23:59:59', current_time('timestamp'));

        // Query args for today's orders.
        $args = array(
            'date_created' => $today_start . '...' . $today_end,
            'status' => array('wc-completed', 'wc-processing', 'wc-on-hold'),
            'limit' => -1,
            'return' => 'ids',
        );

        $orders_today = wc_get_orders($args);
        $count = count($orders_today);
        $revenue = 0;

        foreach ($orders_today as $order_id) {
            $order = wc_get_order($order_id);
            if ($order) {
                $revenue += $order->get_total();
            }
        }

        ?>
        <div class="wrap insightpress-wrap">
            <h1 class="wp-heading-inline">
                <?php esc_html_e('InsightPress Dashboard', 'insightpress-advanced-analytics-for-woocommerce'); ?>
            </h1>
            <hr class="wp-header-end">

            <div class="insightpress-stats-container">
                <div class="insightpress-card">
                    <h2><?php esc_html_e('Orders Today', 'insightpress-advanced-analytics-for-woocommerce'); ?></h2>
                    <p class="insightpress-stat">
                        <?php echo esc_html($count); ?>
                    </p>
                </div>
                <div class="insightpress-card">
                    <h2><?php esc_html_e('Revenue Today', 'insightpress-advanced-analytics-for-woocommerce'); ?></h2>
                    <p class="insightpress-stat">
                        <?php echo wp_kses_post(wc_price($revenue)); ?>
                    </p>
                </div>
            </div>

            <div class="insightpress-footer">
                <p><?php esc_html_e('Basic analytics for your store. More features coming soon!', 'insightpress-advanced-analytics-for-woocommerce'); ?>
                </p>
            </div>
        </div>
        <?php
    }
}
