<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Add "Upgrade to PRO" link in the plugin row meta (after "View details").
 */
add_filter(
	'plugin_row_meta',
	static function ( array $links, string $file ): array {

		if ( defined( 'ISFWC_PLUGIN_BASENAME' ) && $file === ISFWC_PLUGIN_BASENAME ) {
			$links[] = sprintf(
				'<a href="%s" target="_blank" style="font-weight:600;color:green;">%s</a>',
				esc_url( 'https://pedromartins.com/produto/initial-stock-for-woocommerce-pro/' ),
				esc_html__( 'Upgrade to PRO', 'initial-stock-for-woocommerce' )
			);
		}

		return $links;
	},
	10,
	2
);

/**
 * (Optional) Add "Upgrade to PRO" link next to "Deactivate".
 */
if ( defined( 'ISFWC_PLUGIN_BASENAME' ) ) {

	add_filter(
		'plugin_action_links_' . ISFWC_PLUGIN_BASENAME,
		static function ( array $links ): array {

			$links[] = sprintf(
				'<a href="%s" target="_blank" style="font-weight:600;color:green;">%s</a>',
				esc_url( 'https://pedromartins.com/produto/initial-stock-for-woocommerce-pro/' ),
				esc_html__( 'Upgrade to PRO', 'initial-stock-for-woocommerce' )
			);

			return $links;
		}
	);
}
