/**
 * Frontend JavaScript for BOGO plugin
 * Handles dynamic BOGO notice updates on product pages
 */
(function($) {
    'use strict';

    // Handle variation changes on single product pages
    $(document).on('found_variation', function(event, variation) {
        var productId = variation.product_id || $('.single-product').find('input[name="product_id"]').val();
        var variationId = variation.variation_id;
        var placeholder = $('#bogo_placeholder_' + productId);

        if (placeholder.length > 0) {
            placeholder.empty();
            var variationData = $('#bogo-variation-' + variationId);
            if (variationData.length > 0) {
                var buyQty = variationData.data('buy-qty');
                var freeQty = variationData.data('free-qty');
                placeholder.append('<div class="bogo-notice" style="color: red; font-weight: bold; margin-bottom: 10px;">Buy ' + buyQty + ' Get ' + freeQty + ' Free Offer!</div>');
            }
        }
    });

    // Handle reset on single product pages
    $(document).on('reset_data', function(event, variation) {
        var productId = $('.single-product').find('input[name="product_id"]').val();
        var placeholder = $('#bogo_placeholder_' + productId);
        if (placeholder.length > 0) {
            placeholder.empty();
        }
    });

    // Handle variation changes on product loop pages (shop, category, tag pages)
    $(document).on('found_variation', function(event, variation) {
        var variationId = variation.variation_id;
        var variationData = $('#bogo-variation-' + variationId);
        if (variationData.length > 0) {
            var productId = variationData.data('product-id');
            var placeholder = $('#bogo_placeholder_' + productId);
            if (placeholder.length > 0) {
                placeholder.empty();
                var buyQty = variationData.data('buy-qty');
                var freeQty = variationData.data('free-qty');
                placeholder.append('Buy ' + buyQty + ' Get ' + freeQty + ' Free!');
            }
        }
    });

})(jQuery);