<?php
if (!defined('ABSPATH')) exit;

class IFS_Testimonial extends \Elementor\Widget_Base {

    public function get_name() { 
        return 'ifs_testimonial'; 
    }
    public function get_title() { 
        return 'IFS Testimonial'; 
    }
    public function get_icon() { 
        return 'eicon-testimonial-carousel'; 
    }
    public function get_categories() { 
        return ['ifs-category']; 
    }
    
    public function get_script_depends() { 
        return [ 'swiper' ]; 
    }
    public function get_style_depends() { 
        return [ 'e-swiper' ]; 
    }

    protected function register_controls() {

        $this->start_controls_section(
            'ifs_section_main', 
            [
                'label' => 'Collection & Layout',
            ]
        );

        $groups = [];
        $all_testimonials = get_posts(
            [
                'post_type' => 'ifs_testimonial', 
                'posts_per_page' => -1, 
                'post_status' => 'publish'
            ]
        );
        if (!empty($all_testimonials)) {
            foreach ($all_testimonials as $post) {
                $g_name = get_post_meta($post->ID, '_ifst_group_name', true);
                if (!empty($g_name)) { $groups[$g_name] = $g_name; }
            }
        }

        $this->add_control(
            'ifs_selected_batch', 
                [
                'label'       => 'Select Testimonial Group',
                'type'        => \Elementor\Controls_Manager::SELECT,
                'options'     => array_merge(['' => 'Show All Groups'], array_unique($groups)),
                'default'     => '',
            ]
        );

        // 2. LAYOUT TYPE
        $this->add_control('ifs_layout_type', [
            'label'   => 'Select Layout',
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'grid',
            'options' => [
                'list'   => 'List View',
                'grid'   => 'Grid View',
                'slider' => 'Slider View',
            ],
            'separator' => 'before',
        ]);

        $this->add_responsive_control(
            'ifs_columns', 
                [
                'label' => 'Grid Columns',
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '3',
                'options' => [
                    '1' => '1 Column', 
                    '2' => '2 Columns', 
                    '3' => '3 Columns', 
                    '4' => '4 Columns',
                ],
                'selectors' => [
                    '{{WRAPPER}} .ifs-layout-grid' => 'grid-template-columns: repeat({{VALUE}}, 1fr);',
                    '{{WRAPPER}} .ifs-layout-list' => 'grid-template-columns: 1fr;',
                ],
                'condition' => [ 'ifs_layout_type' => ['grid', 'list'] ],
            ]
        );

        $this->add_control(
            'ifs_posts_per_page', 
            [
                'label'   => 'Total Items to Load',
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 6,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'ifs_section_slider', 
                [
                'label'     => 'Slider Settings',
                'condition' => ['ifs_layout_type' => 'slider'],
            ]
        );

        $this->add_responsive_control(
            'ifs_slides_per_view', 
                [
                'label'   => 'Items Per View',
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => '3',
                'tablet_default' => '2',
                'mobile_default' => '1',
                'options' => [ 
                    '1' => '1 Item', 
                    '2' => '2 Items', 
                    '3' => '3 Items', 
                    '4' => '4 Items'
                ],
            ]
        );

        $this->add_control(
            'ifs_loop', 
            [
                'label'   => 'Infinite Loop',
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'ifs_centered', 
                [
                'label'   => 'Centered Slides',
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
            ]
        );

        $this->add_control(
            'hr_autoplay', 
                ['type' => \Elementor\Controls_Manager::DIVIDER
            ]
        );

        $this->add_control(
            'ifs_autoplay', 
            [
                'label'   => 'Enable Autoplay',
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'ifs_autoplay_speed', 
                [
                'label'     => 'Autoplay Speed (ms)',
                'type'      => \Elementor\Controls_Manager::NUMBER,
                'default'   => 3000,
                'step'      => 100,
                'condition' => ['ifs_autoplay' => 'yes'],
            ]
        );

        $this->add_control(
            'ifs_pause_hover', 
                [
                'label'     => 'Pause on Hover',
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'default'   => 'yes',
                'condition' => ['ifs_autoplay' => 'yes'],
            ]
        );

        $this->add_responsive_control(
            'ifs_gap', 
            [
                'label'   => 'Gap Between Items (px)',
                'type'    => \Elementor\Controls_Manager::SLIDER,
                'default' => ['size' => 32],
                'range'   => ['px' => ['min' => 0, 'max' => 100]],
            ]
        );

        // ARROWS (Navigation)
        $this->add_control('ifs_show_arrows', [
            'label'   => 'Show Arrows',
            'type'    => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'yes',
        ]);

        // DOTS (Pagination)
        $this->add_control('ifs_show_dots', [
            'label'   => 'Show Dots',
            'type'    => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'yes',
        ]);

        $this->end_controls_section();

        $this->start_controls_section(
            'ifs_box_style', 
            [
                'label' => 'Box',
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'ifs_box_bg',
			[
				'label' => esc_html__( 'Nackground', 'infinity-testimonials' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ifs-card' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'ifs_box_border',
				'selector' => '{{WRAPPER}} .ifs-card',
			]
		);

        $this->add_control(
			'ifs_box_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'infinity-testimonials' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .ifs-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'ifs_box_padding',
			[
				'label' => esc_html__( 'Pading', 'infinity-testimonials' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .ifs-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'ifs_image_style', 
            [
                'label' => 'Image',
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'ifs_image_border',
				'selector' => '{{WRAPPER}} .ifs-avatar.wp-post-image',
			]
		);

        $this->add_control(
			'ifs_image_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'infinity-testimonials' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .ifs-avatar.wp-post-image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'ifs_title_style', 
            [
                'label' => 'Title',
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'ifs_title_color',
			[
				'label' => esc_html__( 'Color', 'infinity-testimonials' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ifs-name-stack h4' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'ifs_title_typography',
				'selector' => '{{WRAPPER}} .ifs-name-stack h4',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'ifs_designation_style', 
            [
                'label' => 'Designation',
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'ifs_designation_color',
			[
				'label' => esc_html__( 'Color', 'infinity-testimonials' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ifs-designation' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'ifs_designation_typography',
				'selector' => '{{WRAPPER}} .ifs-designation',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'ifs_meta_style', 
            [
                'label' => 'Meta',
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'ifs_rating_color',
			[
				'label' => esc_html__( 'Rating Color', 'infinity-testimonials' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ifs-stars svg' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'ifs_date_color',
			[
				'label' => esc_html__( 'Date Color', 'infinity-testimonials' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .date-stamp' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'ifs_date_typography',
				'selector' => '{{WRAPPER}} .date-stamp',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'ifs_content_style', 
            [
                'label' => 'Content',
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'ifs_content_color',
			[
				'label' => esc_html__( 'Color', 'infinity-testimonials' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ifs-quote' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'ifs_content_typography',
				'selector' => '{{WRAPPER}} .ifs-quote',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'ifs_company_style', 
            [
                'label' => 'Company',
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        
        $this->add_control(
			'ifs_company_color',
			[
				'label' => esc_html__( 'Color', 'infinity-testimonials' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ifs-btn-link' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'ifs_company_typography',
				'selector' => '{{WRAPPER}} .ifs-btn-link',
			]
		);

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $widget_id = 'ifs-' . $this->get_id();

        $gap = (isset($settings['ifs_gap']['size']) && $settings['ifs_gap']['size'] !== '') ? (int)$settings['ifs_gap']['size'] : 32;

        $view_d = !empty($settings['ifs_slides_per_view']) ? $settings['ifs_slides_per_view'] : '3';
        $view_t = !empty($settings['ifs_slides_per_view_tablet']) ? $settings['ifs_slides_per_view_tablet'] : $view_d;
        $view_m = !empty($settings['ifs_slides_per_view_mobile']) ? $settings['ifs_slides_per_view_mobile'] : '1';

       $swiper_init = [
            'slidesPerView'  => (int)$view_m,
            'spaceBetween'   => $gap,
            'loop'           => ($settings['ifs_loop'] === 'yes'),
            'autoplay'       => ($settings['ifs_autoplay'] === 'yes') ? [
                'delay' => (int)$settings['ifs_autoplay_speed'],
                'disableOnInteraction' => false,
                'pauseOnMouseEnter' => ($settings['ifs_pause_hover'] === 'yes'),
            ] : false,
            'breakpoints'    => [ 768 => ['slidesPerView' => (int)$view_t], 1024 => ['slidesPerView' => (int)$view_d] ],
            // Conditional Pagination
            'pagination'     => ($settings['ifs_show_dots'] === 'yes') ? ['el' => '.swiper-pagination', 'clickable' => true] : false,
            // Conditional Navigation
            'navigation'     => ($settings['ifs_show_arrows'] === 'yes') ? ['nextEl' => '.swiper-button-next', 'prevEl' => '.swiper-button-prev'] : false,
        ];

        // WP Query
        $args = [
            'post_type'      => 'ifs_testimonial',
            'posts_per_page' => (int)$settings['ifs_posts_per_page'],
            'post_status'    => 'publish',
        ];

        if (!empty($settings['ifs_selected_batch'])) {
            $args['ifs-meta_query'] = [['key' => '_ifst_group_name', 'value' => $settings['ifs_selected_batch']]];
        }

        $query = new \WP_Query($args);
        if (!$query->have_posts()) return;

        $layout = $settings['ifs_layout_type'];
        $is_slider = ($layout === 'slider');
        $wrap_class = 'ifs-testimonial-wrapper ' . ($is_slider ? 'swiper-container' : 'ifs-static-view');
        $inner_class = ($is_slider ? 'swiper-wrapper' : 'ifs-layout-' . $layout);
        ?>

        <div class="<?php echo esc_attr($wrap_class); ?>" 
             id="<?php echo esc_attr($widget_id); ?>" 
             data-ifs-config='<?php echo json_encode($swiper_init); ?>'
             style="--s-32: <?php echo esc_attr($gap); ?>px; --s-24: 24px; --s-16: 16px; --border: #e2e8f0; --text-main: #1e293b; --text-body: #475569; --text-muted: #64748b; --accent-soft: rgba(59, 130, 246, 0.1);">
            
            <div class="<?php echo esc_attr($inner_class); ?>">
                
                <?php while ($query->have_posts()) : $query->the_post(); 
                    $pid     = get_the_ID();
                    $desig   = get_post_meta($pid, '_ifst_designation', true);
                    $rating  = (int)get_post_meta($pid, '_ifst_stars', true) ?: 5;
                    $logo_url = wp_get_attachment_url(get_post_meta($pid, '_ifst_company_logo_id', true));
                    $site    = get_post_meta($pid, '_ifst_company_url', true);
                ?>
                    <div class="<?php echo ($is_slider ? 'swiper-slide' : 'ifs-item'); ?>">
                        <article class="ifs-card">
                            <div class="ifs-card-header">
                                <div class="infinity-testimonialsfile-area">
                                    <div class="ifs-avatar-frame">
                                        <?php if (has_post_thumbnail()) : the_post_thumbnail('thumbnail', ['class' => 'ifs-avatar']); 
                                              else : echo '<img src="https://i.prifs-avatar.cc/150?u='.esc_attr($pid).'" class="ifs-avatar">'; endif; ?>
                                        <div class="ifs-verified-check">
                                            <svg width="10" height="10" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="4"><polyline points="20 6 9 17 4 12"></polyline></svg>
                                        </div>
                                    </div>
                                    <div class="ifs-name-stack">
                                        <h4><?php the_title(); ?></h4>
                                        <span class="ifs-designation"><?php echo esc_html($desig); ?></span>
                                    </div>
                                </div>
                            </div>

                            <div class="ifs-meta-row">
                                <div class="ifs-stars">
                                    <?php for($i=1; $i<=5; $i++): ?>
                                        <svg width="16" height="16" fill="<?php echo ($i <= $rating) ? 'var(--accent)' : '#e2e8f0'; ?>" viewBox="0 0 24 24"><path d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z"/></svg>
                                    <?php endfor; ?>
                                </div>
                                <span class="date-stamp"><?php echo get_the_date('M Y'); ?></span>
                            </div>

                            <div class="ifs-quote"><?php the_content(); ?></div>

                            <div class="ifs-card-footer">
                                <?php if ($logo_url) : ?>
                                    <img src="<?php echo esc_url($logo_url); ?>" class="ifs-company-img" alt="logo">
                                <?php endif; ?>

                                <?php if($site): ?>
                                    <a href="<?php echo esc_url($site); ?>" target="_blank" class="ifs-btn-link">
                                        Case Study
                                        <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3"><line x1="7" y1="17" x2="17" y2="7"></line><polyline points="7 7 17 7 17 17"></polyline></svg>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </article>
                    </div>
                <?php endwhile; wp_reset_postdata(); ?>

            </div>

            <?php if ($is_slider) : ?>
                <div class="swiper-pagination"></div>
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
            <?php endif; ?>
        </div>

        <style>
            .ifs-testimonial-wrapper { width: 100%; position: relative; box-sizing: border-box; }
            .ifs-layout-grid { display: grid; gap: var(--s-32); }
            .ifs-layout-list { display: grid; gap: var(--s-16); }
            .swiper-container { overflow: hidden; padding-bottom: 50px; }
            
            .ifs-card {
                background: var(--bg-ifs-card); border: 1.5px solid var(--border); border-radius: 24px;
                padding: var(--s-32); flex: 1; display: flex; flex-direction: column; gap: var(--s-24);
                transition: all 0.4s cubic-bezier(0.16, 1, 0.3, 1); height: 100%; box-sizing: border-box;
            }
            .ifs-card:hover { transform: translateY(-8px); border-color: var(--accent); box-shadow: 0 20px 40px -12px rgba(0, 0, 0, 0.1); }
            .infinity-testimonialsfile-area { display: flex; gap: var(--s-16); align-items: center; }
            .ifs-avatar-frame { position: relative; width: 64px; height: 64px; }
            .ifs-avatar { width: 100%; height: 100%; border-radius: 18px; object-fit: cover; }
            .ifs-verified-check { position: absolute; bottom: -4px; right: -4px; background: var(--success); color: white; border: 3px solid var(--bg-ifs-card); border-radius: 50%; padding: 3px; display: flex; }
            .ifs-name-stack h4 { margin: 0; font-size: 1.1rem; color: var(--text-main); font-weight: 800; }
            .ifs-designation { font-size: 0.85rem; color: var(--text-muted); font-weight: 600; text-transform: uppercase; }
            .ifs-meta-row { display: flex; justify-content: space-between; align-items: center; }
            .ifs-stars { display: flex; gap: 2px; }
            .ifs-quote { font-size: 1.05rem; line-height: 1.7; color: var(--text-body); flex-grow: 1; }
            .ifs-card-footer { display: flex; justify-content: space-between; align-items: center; padding-top: var(--s-24); border-top: 1px dashed var(--border); }
            .ifs-company-img { max-height: 24px; filter: grayscale(1); opacity: 0.5; transition: 0.3s; width: auto; }
            .ifs-card:hover .ifs-company-img { filter: grayscale(0); opacity: 1; }
            .ifs-btn-link { padding: var(--s-8) var(--s-16); background: var(--accent-soft); color: var(--accent); text-decoration: none; border-radius: 12px; font-size: 0.85rem; font-weight: 700; display: flex; align-items: center; gap: var(--s-8); }
            
            .swiper-button-next, .swiper-button-prev { color: var(--accent); width: 40px; height: 40px; background: #fff; border-radius: 50%; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
            .swiper-pagination-bullet-active { background: var(--accent); }
            /* Navigation Arrows */
.swiper-button-next, .swiper-button-prev { 
    color: var(--accent); 
    width: 45px; 
    height: 45px; 
    background: var(--bg-card); 
    border-radius: 50%; 
    box-shadow: 0 4px 15px rgba(0,0,0,0.1); 
    transition: 0.3s;
}

.swiper-button-next:after, .swiper-button-prev:after { 
    font-size: 18px; 
    font-weight: bold; 
}

.swiper-button-next:hover, .swiper-button-prev:hover { 
    background: var(--accent); 
    color: #ffffff; 
}

/* Pagination Dots */
.swiper-pagination { 
    position: relative; 
    margin-top: 30px; 
}

.swiper-pagination-bullet { 
    width: 10px; 
    height: 10px; 
    background: var(--text-muted); 
    opacity: 0.3; 
    transition: 0.3s; 
}

.swiper-pagination-bullet-active { 
    background: #333; 
    opacity: 1; 
    width: 25px; /* Pill shape for active dot */
    border-radius: 5px;
}
        </style>

        <script>
        jQuery(window).on('elementor/frontend/init', function() {
            elementorFrontend.hooks.addAction('frontend/element_ready/ifs_testimonial.default', function($scope) {
                var $slider = $scope.find('.swiper-container');
                if ($slider.length) {
                    var config = $slider.data('ifs-config');
                    new Swiper($slider[0], config);
                }
            });
        });
        </script>
        <?php
    }
}