(function ($) {
    "use strict";

    const initIFSSlider = function ($scope, $) {
        const $wrapper = $scope.find('.ifs-testimonial-wrapper.swiper-container');
        
        if (!$wrapper.length) return;

        const config = $wrapper.data('ifs-conf');

        // Initialize Swiper
        if (typeof Swiper !== 'undefined') {
            new Swiper($wrapper[0], config);
        }
    };

    $(window).on('elementor/frontend/init', function () {
        // Hook into Elementor's widget lifecycle
        elementorFrontend.hooks.addAction('frontend/element_ready/ifs_testimonial.default', initIFSSlider);
    });

    // Fallback for non-elementor pages (if used via shortcode)
    $(document).ready(function() {
        if (!window.elementorFrontend) {
            $('.ifs-testimonial-wrapper.swiper-container').each(function() {
                const conf = $(this).data('ifs-conf');
                new Swiper($(this)[0], conf);
            });
        }
    });

})(jQuery);