<?php

if ( ! defined( 'ABSPATH' ) ) exit;

add_action('admin_enqueue_scripts', function() {
    wp_enqueue_media();
});

// --- CONTROLLER: ACTIONS ---

// A. DELETE BATCH LOGIC
if (isset($_GET['action']) && $_GET['action'] === 'delete_batch') {
    if (isset($_GET['group']) && check_admin_referer('ifst_batch_action')) {
        $group_to_del = sanitize_text_field($_GET['group']);
        $cat_to_del   = sanitize_text_field($_GET['cat']);

        $args = [
            'post_type'      => 'ifs_testimonial',
            'posts_per_page' => -1,
            'fields'         => 'ids',
            'meta_query'     => [['key' => '_ifst_group_name', 'value' => $group_to_del]]
        ];
        if ($cat_to_del !== 'Uncategorized') {
            $args['tax_query'] = [['taxonomy' => 'testimonial_cat', 'field' => 'name', 'terms' => $cat_to_del]];
        }

        $batch_ids = get_posts($args);
        if (!empty($batch_ids)) {
            foreach ($batch_ids as $pid) wp_delete_post($pid, true);
            echo "<script>window.location.href='admin.php?page=ifs-testimonial&tab=testimonials&sub=all&msg=deleted';</script>";
            exit;
        }
    }
}

// B. SAVE / UPDATE LOGIC
if (isset($_POST['save_ifst_pro'])) {
    if (isset($_POST['ifst_nonce']) && wp_verify_nonce($_POST['ifst_nonce'], 'ifst_bulk_save')) {
        
        if (!empty($_POST['ifst_is_editing_group'])) {
            $old_g = sanitize_text_field($_POST['ifst_is_editing_group']);
            $to_del = get_posts(['post_type'=>'ifs_testimonial','posts_per_page'=>-1,'fields'=>'ids','meta_query'=>[['key'=>'_ifst_group_name','value'=>$old_g]]]);
            foreach ($to_del as $id) wp_delete_post($id, true);
        }

        $internal_group = sanitize_text_field($_POST['ifst_internal_group']);
        $target_cat_id  = (int)$_POST['ifst_cat_select'];
        $testimonials   = $_POST['ifst'] ?? [];

        foreach ($testimonials as $data) {
            if (empty($data['name'])) continue; 
            $post_id = wp_insert_post([
                'post_title'   => sanitize_text_field($data['name']),
                'post_content' => wp_kses_post($data['desc']),
                'post_status'  => 'publish',
                'post_type'    => 'ifs_testimonial'
            ]);
            if ($post_id) {
                if ($target_cat_id > 0) wp_set_post_terms($post_id, [$target_cat_id], 'testimonial_cat');
                update_post_meta($post_id, '_ifst_group_name', $internal_group);
                update_post_meta($post_id, '_ifst_designation', sanitize_text_field($data['designation']));
                update_post_meta($post_id, '_ifst_company', sanitize_text_field($data['company']));
                update_post_meta($post_id, '_ifst_company_url', esc_url_raw($data['company_url']));
                update_post_meta($post_id, '_ifst_stars', sanitize_text_field($data['stars']));
                
                if (!empty($data['img_id'])) {
                    update_post_meta($post_id, '_ifst_img_id', $data['img_id']);
                    set_post_thumbnail($post_id, $data['img_id']);
                }
                if (!empty($data['logo_id'])) {
                    update_post_meta($post_id, '_ifst_company_logo_id', $data['logo_id']);
                }
            }
        }
        echo "<script>window.location.href='admin.php?page=ifs-testimonial&tab=testimonials&sub=all&msg=saved';</script>";
        exit;
    }
}

$sub_page = $_GET['sub'] ?? 'all';
?>

<style>
    :root { --ifst-primary: #2563eb; --ifst-border: #e2e8f0; --ifst-bg: #f8fafc; --ifst-dark: #0f172a; --ifst-slate: #64748b; }
    .ifst-master-wrap { margin: 25px 20px 0 0; max-width: 1150px; font-family: -apple-system, sans-serif; }
    .ifst-main-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px; }
    .ifst-title-group h1 { font-size: 28px; font-weight: 800; color: var(--ifst-dark); margin: 0; }
    .ifst-title-group p { color: var(--ifst-slate); margin-top: 5px; font-size: 14px; }
    .ifst-sticky-bar { 
        background: #fff; border: 1px solid var(--ifst-border); border-radius: 16px; 
        padding: 20px 30px; margin-bottom: 30px; position: sticky; top: 32px; z-index: 100;
        box-shadow: 0 10px 15px -3px rgba(0,0,0,0.05); display: flex; gap: 20px; align-items: flex-end;
    }
    .ifst-card { background: #fff; border: 1px solid var(--ifst-border); border-radius: 16px; overflow: hidden; box-shadow: 0 4px 6px -1px rgba(0,0,0,0.05); }
    .ifst-table { width: 100%; border-collapse: collapse; }
    .ifst-table th { background: #f8fafc; padding: 18px 25px; text-align: left; font-size: 11px; font-weight: 700; color: var(--ifst-slate); text-transform: uppercase; letter-spacing: 1px; border-bottom: 1px solid var(--ifst-border); }
    .ifst-table td { padding: 18px 25px; border-bottom: 1px solid #f1f5f9; vertical-align: middle; }
    .ifst-repeater-card { background: #fff; border: 1px solid var(--ifst-border); border-radius: 16px; margin-bottom: 25px; overflow: hidden; }
    .ifst-repeater-head { background: #f8fafc; padding: 15px 25px; border-bottom: 1px solid var(--ifst-border); display: flex; justify-content: space-between; align-items: center; }
    .ifst-repeater-body { padding: 30px; display: grid; grid-template-columns: 180px 1fr; gap: 40px; }
    .ifst-h-label { display: block; font-size: 10px; font-weight: 800; color: var(--ifst-slate); text-transform: uppercase; margin-bottom: 8px; letter-spacing: 0.5px; }
    .ifst-input { width: 100%; height: 42px !important; border: 1px solid var(--ifst-border) !important; border-radius: 8px !important; padding: 0 15px !important; font-size: 14px !important; }
    .ifst-textarea { width: 100%; min-height: 120px; border: 1px solid var(--ifst-border) !important; border-radius: 8px !important; padding: 15px !important; font-size: 14px !important; }
    .ifst-media-box { 
        width: 100%; aspect-ratio: 1; background: #f1f5f9; border: 2px dashed #cbd5e1; 
        border-radius: 12px; display: flex; align-items: center; justify-content: center; 
        cursor: pointer; position: relative; overflow: hidden; transition: 0.2s; margin-bottom: 15px;
    }
    .ifst-media-box:hover { border-color: var(--ifst-primary); background: #eff6ff; }
    .ifst-media-box img { position: absolute; width: 100%; height: 100%; object-fit: cover; pointer-events: none; }
    .ifst-media-box span { font-size: 9px; font-weight: 800; color: #94a3b8; text-align: center; pointer-events: none; }
    .ifst-action-icon { width: 38px; height: 38px; display: inline-flex; align-items: center; justify-content: center; border-radius: 10px; border: 1px solid var(--ifst-border); color: var(--ifst-slate); background: #fff; text-decoration: none; transition: 0.2s; }
    .ifst-action-icon.edit:hover { border-color: #f59e0b; color: #f59e0b; background: #fffbeb; }
    .ifst-action-icon.delete:hover { border-color: #ef4444; color: #ef4444; background: #fef2f2; }
    .ifst-btn-main { background: var(--ifst-primary) !important; color: #fff !important; padding: 0 25px !important; height: 42px !important; border-radius: 8px !important; font-weight: 700 !important; border: none !important; cursor: pointer; display: inline-flex; align-items: center; text-decoration: none; }
</style>

<div class="ifst-master-wrap">

    <?php if ($sub_page === 'all'): 
        $all_p = get_posts(['post_type' => 'ifs_testimonial', 'posts_per_page' => -1]);
        $grouped = [];
        foreach ($all_p as $p) {
            $g = get_post_meta($p->ID, '_ifst_group_name', true) ?: 'Unnamed Group';
            $t = get_the_terms($p->ID, 'testimonial_cat');
            $c = ($t && !is_wp_error($t)) ? $t[0]->name : 'Uncategorized';
            $key = md5($c . $g);
            if (!isset($grouped[$key])) $grouped[$key] = ['cat' => $c, 'group' => $g, 'count' => 0];
            $grouped[$key]['count']++;
        }
    ?>
        <div class="ifst-main-header">
            <div class="ifst-title-group">
                <h1>Testimonial Collections</h1>
                <p>Manage batches by category and group name.</p>
            </div>
            <a href="?page=ifs-testimonial&tab=testimonials&sub=add" class="ifst-btn-main">+ Create New Batch</a>
        </div>

        <div class="ifst-card">
            <table class="ifst-table">
                <thead>
                    <tr><th>Category</th><th>Group Name</th><th style="text-align: center;">Total Items</th><th style="text-align: right;">Actions</th></tr>
                </thead>
                <tbody>
                    <?php if(!empty($grouped)): foreach($grouped as $item): ?>
                    <tr>
                        <td><span style="background: #eff6ff; color: #2563eb; padding: 6px 12px; border-radius: 8px; font-size: 12px; font-weight: 700; border: 1px solid #dbeafe;">📁 <?php echo esc_html($item['cat']); ?></span></td>
                        <td><div style="font-weight: 700; color: var(--ifst-dark); font-size: 16px;"><?php echo esc_html($item['group']); ?></div></td>
                        <td style="text-align: center;"><div style="background: #f1f5f9; padding: 4px 12px; border-radius: 20px; font-weight: 800; font-size: 12px; border: 1px solid var(--ifst-border); display: inline-block; min-width: 20px;"><?php echo esc_attr($item['count']); ?></div></td>
                        <td style="text-align: right;">
                            <div style="display: flex; gap: 10px; justify-content: flex-end;">
                                <a href="?page=ifs-testimonial&tab=testimonials&sub=add&group=<?php echo urlencode($item['group']); ?>&cat=<?php echo urlencode($item['cat']); ?>" class="ifst-action-icon edit">✎</a>
                                <?php $del_url = wp_nonce_url("?page=ifs-testimonial&tab=testimonials&sub=all&action=delete_batch&group=".urlencode($item['group'])."&cat=".urlencode($item['cat']), 'ifst_batch_action'); ?>
                                <a href="<?php echo esc_url($del_url); ?>" class="ifst-action-icon delete" onclick="return confirm('Delete this batch?')">🗑</a>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; else: ?>
                    <tr><td colspan="4" style="padding: 80px; text-align: center; color: var(--ifst-slate);">No collections found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

    <?php else: 
        $edit_g = $_GET['group'] ?? '';
        $edit_c = $_GET['cat'] ?? '';
        $existing = [];
        if ($edit_g) {
            $eargs = ['post_type'=>'ifs_testimonial', 'posts_per_page'=>-1, 'meta_query'=>[['key'=>'_ifst_group_name','value'=>$edit_g]]];
            if ($edit_c !== 'Uncategorized') $eargs['tax_query'] = [['taxonomy'=>'testimonial_cat','field'=>'name','terms'=>$edit_c]];
            foreach (get_posts($eargs) as $p) {
                $existing[] = [
                    'name' => $p->post_title, 'desc' => $p->post_content,
                    'designation' => get_post_meta($p->ID, '_ifst_designation', true),
                    'company' => get_post_meta($p->ID, '_ifst_company', true),
                    'company_url' => get_post_meta($p->ID, '_ifst_company_url', true),
                    'stars' => get_post_meta($p->ID, '_ifst_stars', true),
                    'img_id' => get_post_meta($p->ID, '_ifst_img_id', true),
                    'img_url' => get_the_post_thumbnail_url($p->ID, 'thumbnail'),
                    'logo_id' => get_post_meta($p->ID, '_ifst_company_logo_id', true),
                    'logo_url' => wp_get_attachment_url(get_post_meta($p->ID, '_ifst_company_logo_id', true))
                ];
            }
        }
        $loop = !empty($existing) ? $existing : [[]];
    ?>
        <form method="post">
            <?php wp_nonce_field('ifst_bulk_save', 'ifst_nonce'); ?>
            <input type="hidden" name="ifst_is_editing_group" value="<?php echo esc_attr($edit_g); ?>">

            <div class="ifst-main-header">
                <div class="ifst-title-group">
                    <h1><?php echo $edit_g ? 'Edit Batch' : 'Create New Batch'; ?></h1>
                </div>
                <a href="?page=ifs-testimonial&tab=testimonials&sub=all" class="button" style="height:42px; border-radius:8px;">← Back to List</a>
            </div>

            <div class="ifst-sticky-bar">
                <div style="flex: 2;"><label class="ifst-h-label">Batch Group Name</label><input type="text" name="ifst_internal_group" class="ifst-input" value="<?php echo esc_attr($edit_g); ?>" required placeholder="e.g. Home Page Slider"></div>
                <div style="flex: 1;"><label class="ifst-h-label">Category</label>
                    <select name="ifst_cat_select" class="ifst-input">
                        <option value="0">— Select Category —</option>
                        <?php foreach(get_terms(['taxonomy'=>'testimonial_cat','hide_empty'=>false]) as $cat): ?>
                            <option value="<?php echo esc_attr($cat->term_id); ?>" <?php selected($edit_c, $cat->name); ?>><?php echo esc_html($cat->name); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <button type="submit" name="save_ifst_pro" class="ifst-btn-main">Publish Collection</button>
            </div>

            <div id="ifst-repeater-list">
                <?php foreach ($loop as $idx => $item): ?>
                <div class="ifst-repeater-card ifst-row">
                    <div class="ifst-repeater-head">
                        <span class="row-title" style="font-weight: 800; color: var(--ifst-dark);"><?php echo !empty($item['name']) ? esc_html($item['name']) : 'New Testimonial Entry'; ?></span>
                        <a href="#" class="ifst-remove" style="color: #ef4444; font-size: 11px; font-weight: 800; text-decoration: none;">REMOVE</a>
                    </div>
                    <div class="ifst-repeater-body">
                        <div>
                            <label class="ifst-h-label">Client Photo</label>
                            <div class="ifst-media-box js-ifst-upload" data-type="client">
                                <?php if(!empty($item['img_url'])): ?><img src="<?php echo esc_url($item['img_url']); ?>"><?php endif; ?>
                                <span style="<?php echo !empty($item['img_url']) ? 'display:none' : ''; ?>">+ CLIENT PHOTO</span>
                                <input type="hidden" name="ifst[<?php echo esc_attr($idx); ?>][img_id]" class="img-id-field" value="<?php echo esc_attr(@$item['img_id']); ?>">
                            </div>
                            
                            <label class="ifst-h-label">Company Logo</label>
                            <div class="ifst-media-box js-ifst-upload" data-type="logo" style="aspect-ratio: 2.5/1; height: 60px;">
                                <?php if(!empty($item['logo_url'])): ?><img src="<?php echo esc_url($item['logo_url']); ?>"><?php endif; ?>
                                <span style="<?php echo !empty($item['logo_url']) ? 'display:none' : ''; ?>">+ CO. LOGO</span>
                                <input type="hidden" name="ifst[<?php echo esc_attr($idx); ?>][logo_id]" class="img-id-field" value="<?php echo esc_attr(@$item['logo_id']); ?>">
                            </div>
                        </div>
                        <div>
                            <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 15px; margin-bottom: 20px;">
                                <div><label class="ifst-h-label">Full Name</label><input type="text" name="ifst[<?php echo esc_attr($idx); ?>][name]" class="ifst-input name-sync" value="<?php echo esc_attr(@$item['name']); ?>" required></div>
                                <div><label class="ifst-h-label">Job Title</label><input type="text" name="ifst[<?php echo esc_attr($idx); ?>][designation]" class="ifst-input" value="<?php echo esc_attr(@$item['designation']); ?>"></div>
                                <div><label class="ifst-h-label">Stars</label>
                                    <select name="ifst[<?php echo esc_attr($idx); ?>][stars]" class="ifst-input">
                                        <option value="5" <?php selected(@$item['stars'], '5'); ?>>★★★★★</option>
                                        <option value="4" <?php selected(@$item['stars'], '4'); ?>>★★★★☆</option>
                                        <option value="3" <?php selected(@$item['stars'], '3'); ?>>★★★☆☆</option>
                                        <option value="2" <?php selected(@$item['stars'], '2'); ?>>★★☆☆☆</option>
                                        <option value="1" <?php selected(@$item['stars'], '1'); ?>>★☆☆☆☆</option>
                                    </select>
                                </div>
                            </div>
                            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 20px;">
                                <div><label class="ifst-h-label">Company Name</label><input type="text" name="ifst[<?php echo esc_attr($idx); ?>][company]" class="ifst-input" value="<?php echo esc_attr(@$item['company']); ?>"></div>
                                <div><label class="ifst-h-label">Company URL</label><input type="text" name="ifst[<?php echo esc_attr($idx); ?>][company_url]" class="ifst-input" placeholder="https://..." value="<?php echo esc_url(@$item['company_url']); ?>"></div>
                            </div>
                            <label class="ifst-h-label">Testimonial Content</label>
                            <textarea name="ifst[<?php echo esc_attr($idx); ?>][desc]" class="ifst-textarea" required><?php echo esc_attr(@$item['desc']); ?></textarea>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            <button type="button" id="ifst-add-row" style="width: 100%; padding: 25px; background: #fff; border: 2px dashed #cbd5e1; border-radius: 16px; color: var(--ifst-primary); font-weight: 800; cursor: pointer; margin-bottom: 50px;">+ Add Another Testimonial</button>
        </form>
    <?php endif; ?>
</div>

<script>
jQuery(document).ready(function($) {
    let idx = <?php echo count($loop); ?>;
    
    // ADD ROW
    $('#ifst-add-row').click(function() {
        let row = $('.ifst-row').first().clone();
        row.find('input, textarea').val('');
        row.find('.img-id-field').val(''); // Reset hidden IDs
        row.find('img').remove(); // Remove previous images
        row.find('.ifst-media-box span').show(); // Show text
        row.find('.row-title').text('New Testimonial Entry');
        
        row.find('input, textarea, select').each(function() {
            let name = $(this).attr('name');
            if(name) {
                $(this).attr('name', name.replace(/\[\d+\]/, '['+idx+']'));
            }
        });
        
        row.find('select[name*="[stars]"]').val('5'); 
        $('#ifst-repeater-list').append(row);
        idx++;
    });

    // REMOVE ROW
    $(document).on('click', '.ifst-remove', function(e) { 
        e.preventDefault(); 
        if($('.ifst-row').length > 1) $(this).closest('.ifst-repeater-card').remove(); 
    });

    // SYNC TITLE
    $(document).on('input', '.name-sync', function() { 
        $(this).closest('.ifst-repeater-card').find('.row-title').text($(this).val() || 'New Testimonial Entry'); 
    });

    // MEDIA UPLOADER LOGIC
    $(document).on('click', '.js-ifst-upload', function(e) {
        e.preventDefault();
        let box = $(this);
        let hiddenInput = box.find('.img-id-field');
        
        let frame = wp.media({
            title: 'Select Image',
            multiple: false,
            library: { type: 'image' }
        });

        frame.on('select', function() {
            let attachment = frame.state().get('selection').first().toJSON();
            
            // Set Hidden ID
            hiddenInput.val(attachment.id);
            
            // Update Preview
            box.find('span').hide();
            box.find('img').remove();
            box.prepend('<img src="'+attachment.url+'">');
        });

        frame.open();
    });
});
</script>