<?php

if ( ! defined( 'ABSPATH' ) ) exit;

if (isset($_GET['action']) && $_GET['action'] === 'delete_batch') {
    if (isset($_GET['group']) && check_admin_referer('ifst_batch_action')) {
        
        $group_to_del = sanitize_text_field($_GET['group']);
        $cat_to_del   = sanitize_text_field($_GET['cat']);

        // Find items in this batch
        $args = [
            'post_type'      => 'ifs_testimonial',
            'posts_per_page' => -1,
            'fields'         => 'ids',
            'meta_query'     => [
                ['key' => '_ifst_group_name', 'value' => $group_to_del]
            ]
        ];

        // Add taxonomy filter if category is not "Uncategorized"
        if ($cat_to_del !== 'Uncategorized') {
            $args['tax_query'] = [[
                'taxonomy' => 'testimonial_cat',
                'field'    => 'name',
                'terms'    => $cat_to_del
            ]];
        }

        $batch_ids = get_posts($args);

        if (!empty($batch_ids)) {
            foreach ($batch_ids as $pid) {
                wp_delete_post($pid, true);
            }
            // Redirect to clean URL to show success and prevent re-run
            echo "<script>window.location.href='admin.php?page=ifs-testimonial&tab=testimonials&sub=all&msg=deleted&count=".count($batch_ids)."';</script>";
            exit;
        }
    }
}

// 2. SUCCESS NOTICE
if (isset($_GET['msg']) && $_GET['msg'] === 'deleted') {
    echo '<div class="notice notice-success is-dismissible"><p>Successfully removed ' . intval($_GET['count']) . ' testimonials.</p></div>';
}

// 3. AGGREGATE DATA
$all_posts = get_posts(['post_type' => 'ifs_testimonial', 'posts_per_page' => -1]);
$grouped = [];

foreach ($all_posts as $p) {
    $g_name = get_post_meta($p->ID, '_ifst_group_name', true) ?: 'General Batch';
    $terms  = get_the_terms($p->ID, 'testimonial_cat');
    $c_name = ($terms && !is_wp_error($terms)) ? $terms[0]->name : 'Uncategorized';
    
    $key = md5($c_name . $g_name);
    if (!isset($grouped[$key])) {
        $grouped[$key] = ['cat' => $c_name, 'group' => $g_name, 'count' => 0];
    }
    $grouped[$key]['count']++;
}
?>

<div class="ifst-dashboard" style="margin-top: 20px; max-width: 1100px; font-family: -apple-system, sans-serif;">
    
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
        <div>
            <h1 style="font-size: 28px; font-weight: 800; color: #0f172a; margin: 0;">Testimonial Collections</h1>
            <p style="color: #64748b; margin-top: 4px;">Grouped by Category and Batch Name.</p>
        </div>
        <a href="?page=ifs-testimonial&tab=testimonials&sub=add" class="button button-primary" style="padding: 10px 20px; height: auto; font-weight: 600; border-radius: 8px;">+ New Collection</a>
    </div>

    <div class="ifst-card-container" style="background: #fff; border: 1px solid #e2e8f0; border-radius: 16px; overflow: hidden; box-shadow: 0 4px 6px -1px rgba(0,0,0,0.05);">
        <table style="width: 100%; border-collapse: collapse; text-align: left;">
            <thead>
                <tr style="background: #f8fafc; border-bottom: 1px solid #e2e8f0;">
                    <th style="padding: 18px 25px; color: #475569; font-size: 11px; text-transform: uppercase; letter-spacing: 1px;">Category</th>
                    <th style="padding: 18px 25px; color: #475569; font-size: 11px; text-transform: uppercase; letter-spacing: 1px;">Collection Group Name</th>
                    <th style="padding: 18px 25px; color: #475569; font-size: 11px; text-transform: uppercase; letter-spacing: 1px; text-align: center;">Total Items</th>
                    <th style="padding: 18px 25px; color: #475569; font-size: 11px; text-transform: uppercase; letter-spacing: 1px; text-align: right;">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php if(!empty($grouped)): foreach($grouped as $item): ?>
                <tr class="ifst-row-hover" style="border-bottom: 1px solid #f1f5f9; transition: 0.2s;">
                    
                    <td style="padding: 18px 25px;">
                        <span style="background: #eff6ff; color: #2563eb; padding: 5px 12px; border-radius: 6px; font-size: 12px; font-weight: 700; border: 1px solid #dbeafe;">
                           📁 <?php echo esc_html($item['cat']); ?>
                        </span>
                    </td>

                    <td style="padding: 18px 25px;">
                        <div style="font-weight: 700; color: #1e293b; font-size: 15px;"><?php echo esc_html($item['group']); ?></div>
                    </td>

                    <td style="padding: 18px 25px; text-align: center;">
                        <div style="display: inline-flex; align-items: center; justify-content: center; background: #f1f5f9; color: #475569; width: 34px; height: 34px; border-radius: 50%; font-weight: 800; font-size: 12px; border: 1px solid #e2e8f0;">
                            <?php echo esc_html($item['count']); ?>
                        </div>
                    </td>

                    <td style="padding: 18px 25px; text-align: right;">
                        <div style="display: flex; gap: 8px; justify-content: flex-end;">
                            
                            <a href="?page=ifs-testimonial&tab=testimonials&sub=add&group=<?php echo urlencode($item['group']); ?>&cat=<?php echo urlencode($item['cat']); ?>" class="ifst-icon edit" title="Edit Batch">
                                <svg fill="none" viewBox="0 0 24 24" stroke="currentColor" style="width: 18px;"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" /></svg>
                            </a>

                            <?php $del_url = wp_nonce_url("?page=ifs-testimonial&tab=testimonials&sub=all&action=delete_batch&group=".urlencode($item['group'])."&cat=".urlencode($item['cat']), 'ifst_batch_action'); ?>
                            <a href="<?php echo esc_url($del_url); ?>" class="ifst-icon delete" title="Delete Batch" onclick="return confirm('Permanently delete all <?php echo esc_attr($item['count']); ?> testimonials in this group?')">
                                <svg fill="none" viewBox="0 0 24 24" stroke="currentColor" style="width: 18px;"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" /></svg>
                            </a>
                        </div>
                    </td>
                </tr>
                <?php endforeach; else: ?>
                <tr><td colspan="4" style="padding: 60px; text-align: center; color: #94a3b8; font-style: italic;">No collections found.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<style>
.ifst-row-hover:hover { background: #fcfdfe; }
.ifst-icon {
    width: 36px; height: 36px; display: flex; align-items: center; justify-content: center;
    border-radius: 10px; border: 1px solid #e2e8f0; color: #64748b; background: #fff;
    transition: all 0.2s ease; text-decoration: none;
}
.ifst-icon:hover { transform: translateY(-2px); box-shadow: 0 4px 6px rgba(0,0,0,0.05); }
.ifst-icon.edit:hover { border-color: #f59e0b; color: #f59e0b; background: #fffbeb; }
.ifst-icon.delete:hover { border-color: #ef4444; color: #ef4444; background: #fef2f2; }
</style>