<?php 

if ( ! defined( 'ABSPATH' ) ) exit;

?>

<div style="display:grid; grid-template-columns: 2fr 1fr; gap:30px;">
    <div class="ifs-card">
        <h3>Shortcodes</h3>
        <div style="background:#f8fafc; padding:15px; border-radius:8px; display:flex; justify-content:space-between; align-items:center;">
            <code id="sc-main" style="font-size:16px;">[ifs_testimonials]</code>
            <button class="ifs-btn" onclick="copyShortcode('#sc-main')">Copy</button>
        </div>
    </div>

    <div class="ifs-card">
        <h3>Integrations</h3>
        <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:20px;">
            <span style="font-weight:600;">Gutenberg</span>
            <label class="switch"><input type="checkbox" checked><span class="slider"></span></label>
        </div>
        <div style="display:flex; justify-content:space-between; align-items:center;">
            <span style="font-weight:600;">Elementor</span>
            <label class="switch"><input type="checkbox" checked><span class="slider"></span></label>
        </div>
    </div>
</div>

<script>
function copyShortcode(id) {
    const text = document.querySelector(id).innerText;
    navigator.clipboard.writeText(text);
    alert("Shortcode Copied!");
}
</script>