<?php

if ( ! defined( 'ABSPATH' ) ) exit;
// Fetch Data for Stats
$count_testimonials = wp_count_posts('ifs_testimonial')->publish;
$count_cats         = count(get_terms(['taxonomy' => 'testimonial_cat', 'hide_empty' => false]));
$latest_feedback    = get_posts(['post_type' => 'ifs_testimonial', 'numberposts' => 1]);
$last_update        = (!empty($latest_feedback)) ? get_the_date('M j, Y', $latest_feedback[0]->ID) : 'N/A';
?>

<div style="background: linear-gradient(135deg, var(--side-bg) 0%, #1e293b 100%); padding: 40px; border-radius: 20px; color: #fff; margin-bottom: 35px; position: relative; overflow: hidden; box-shadow: 0 10px 30px rgba(0,0,0,0.15);">
    <div style="position: relative; z-index: 2;">
        <h1 style="font-size: 28px; font-weight: 800; margin: 0; letter-spacing: -0.5px;">Welcome Back!</h1>
        <p style="color: #94a3b8; margin: 10px 0 25px 0; font-size: 16px;">Your testimonial engine is running smoothly.</p>
        <div style="display: flex; gap: 15px;">
            <a href="?page=ifs-testimonial&tab=testimonials&sub=add" class="ifs-btn" style="background: var(--accent); box-shadow: 0 4px 12px var(--accent-glow);">Create New Review</a>
            <a href="?page=ifs-testimonial&tab=settings" class="ifs-btn" style="background: rgba(255,255,255,0.1); border: 1px solid rgba(255,255,255,0.2); backdrop-filter: blur(10px);">View Shortcodes</a>
        </div>
    </div>
    <div style="position: absolute; right: -50px; top: -50px; width: 200px; height: 200px; background: var(--accent); filter: blur(80px); opacity: 0.3; border-radius: 50%;"></div>
</div>

<div style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px; margin-bottom: 35px;">
    
    <div class="ifs-card" style="padding: 25px; border-left: 4px solid var(--accent);">
        <span style="font-size: 11px; font-weight: 700; color: #94a3b8; text-transform: uppercase;">Total Reviews</span>
        <div style="font-size: 32px; font-weight: 800; color: #0f172a; margin-top: 5px;"><?php echo esc_html($count_testimonials); ?></div>
    </div>

    <div class="ifs-card" style="padding: 25px; border-left: 4px solid #10b981;">
        <span style="font-size: 11px; font-weight: 700; color: #94a3b8; text-transform: uppercase;">Categories</span>
        <div style="font-size: 32px; font-weight: 800; color: #0f172a; margin-top: 5px;"><?php echo esc_html($count_cats); ?></div>
    </div>

    <div class="ifs-card" style="padding: 25px; border-left: 4px solid #f59e0b;">
        <span style="font-size: 11px; font-weight: 700; color: #94a3b8; text-transform: uppercase;">Last Update</span>
        <div style="font-size: 20px; font-weight: 800; color: #0f172a; margin-top: 15px;"><?php echo esc_html($last_update); ?></div>
    </div>

    <div class="ifs-card" style="padding: 25px; border-left: 4px solid #6366f1; background: #fdfeff;">
        <span style="font-size: 11px; font-weight: 700; color: #94a3b8; text-transform: uppercase;">System Status</span>
        <div style="display: flex; align-items: center; margin-top: 15px;">
            <span style="width: 10px; height: 10px; background: #10b981; border-radius: 50%; display: inline-block; margin-right: 8px; box-shadow: 0 0 10px #10b981;"></span>
            <span style="font-weight: 700; color: #0f172a;">Live & Optimized</span>
        </div>
    </div>
</div>

<div style="display: grid; grid-template-columns: 2fr 1fr; gap: 30px;">
    
    <div class="ifs-card">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 25px;">
            <h3 style="margin: 0; font-weight: 800; color: #0f172a;">Recent Feedbacks</h3>
            <a href="?page=ifs-testimonial&tab=testimonials&sub=all" style="color: var(--accent); font-weight: 600; text-decoration: none; font-size: 13px;">View All →</a>
        </div>
        
        <?php 
        $recent = get_posts(['post_type' => 'ifs_testimonial', 'numberposts' => 4]);
        if($recent): foreach($recent as $post): ?>
            <div style="display: flex; align-items: center; padding: 15px 0; border-bottom: 1px solid #f1f5f9;">
                <div style="width: 40px; height: 40px; background: #f1f5f9; border-radius: 10px; display: flex; align-items: center; justify-content: center; margin-right: 15px; font-weight: 800; color: var(--accent);">
                    <?php echo esc_attr(substr($post->post_title, 0, 1)); ?>
                </div>
                <div style="flex-grow: 1;">
                    <div style="font-weight: 700; color: #1e293b;"><?php echo esc_html($post->post_title); ?></div>
                    <div style="font-size: 12px; color: #94a3b8;"><?php echo get_the_date('F j, Y', $post->ID); ?></div>
                </div>
                <div style="background: #ecfdf5; color: #10b981; padding: 4px 10px; border-radius: 20px; font-size: 11px; font-weight: 700;">Active</div>
            </div>
        <?php endforeach; else: ?>
            <p style="color: #94a3b8; text-align: center; padding: 40px 0;">No testimonials yet. Your activity will appear here.</p>
        <?php endif; ?>
    </div>

    <div>
        <div class="ifs-card" style="background: #f8fafc; border: 1px dashed #cbd5e1; margin-bottom: 25px;">
            <h4 style="margin-top: 0; color: #0f172a;">Pro Tip 💡</h4>
            <p style="font-size: 13px; color: #64748b; line-height: 1.6;">You can categorize your testimonials to display them separately on different service pages using the <code>cat="slug"</code> attribute.</p>
        </div>
        
        <div class="ifs-card" style="padding: 20px; text-align: center;">
            <div style="font-weight: 800; color: #0f172a; margin-bottom: 10px;">Need Help?</div>
            <p style="font-size: 12px; color: #94a3b8; margin-bottom: 15px;">Read our documentation to learn about advanced styling.</p>
            <button class="ifs-btn" style="width: 100%; font-size: 13px;">Read Documentation</button>
        </div>
    </div>
</div>