<?php 

if ( ! defined( 'ABSPATH' ) ) exit;

$sub = $_GET['sub'] ?? 'all'; 

// --- 1. GLOBAL ACTION HANDLER (Catch Delete/Edit signals here) ---
if (isset($_GET['action'])) {
    
    // A. HANDLE DELETE
    if ($_GET['action'] === 'delete_cat' && isset($_GET['cat_id'])) {
        if (check_admin_referer('ifst_cat_action')) {
            $term_id = intval($_GET['cat_id']);
            wp_delete_term($term_id, 'testimonial_cat');
            
            // Redirect to refresh the list and show success
            echo "<script>window.location.href='admin.php?page=ifs-testimonial&tab=categories&sub=all&msg=cat_deleted';</script>";
            exit;
        }
    }
}

// --- 2. NOTICES ---
if (isset($_GET['msg']) && $_GET['msg'] === 'cat_deleted') {
    echo '<div class="notice notice-success is-dismissible"><p>Category removed successfully.</p></div>';
}
?>

<div class="ifs-sub-nav">
    <a href="?page=ifs-testimonial&tab=categories&sub=all" class="ifs-sub-tab <?php echo $sub=='all'?'active':'';?>">All Categories</a>
    <a href="?page=ifs-testimonial&tab=categories&sub=add" class="ifs-sub-tab <?php echo $sub=='add'?'active':'';?>">Add New</a>
</div>

<?php 
// 4. ROUTING
if($sub == 'add') {
    include IFS_PATH . 'admin/categories/manage.php'; 
} else {
    include IFS_PATH . 'admin/categories/list.php'; 
}
?>