<?php

if ( ! defined( 'ABSPATH' ) ) exit;

$cat_id = isset($_GET['cat_id']) ? intval($_GET['cat_id']) : 0;
$current_name = '';

// 1. IF EDITING: Get existing name
if ($cat_id > 0) {
    $term = get_term($cat_id, 'testimonial_cat');
    if ($term && !is_wp_error($term)) {
        $current_name = $term->name;
    }
}

// 2. HANDLE FORM SUBMISSION
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ifst_cat_name'])) {
    $cat_name = sanitize_text_field($_POST['ifst_cat_name']);

    if (!empty($cat_name)) {
        if ($cat_id > 0) {
            // UPDATE EXISTING
            wp_update_term($cat_id, 'testimonial_cat', ['name' => $cat_name]);
            $msg = 'updated';
        } else {
            // CREATE NEW
            wp_insert_term($cat_name, 'testimonial_cat');
            $msg = 'added';
        }

        // REDIRECT to list
        echo "<script>window.location.href='admin.php?page=ifs-testimonial&tab=categories&sub=all&msg=".esc_attr($msg)."';</script>";
        exit;
    }
}
?>

<div class="ifs-card" style="max-width:400px; background:#fff; padding:25px; border-radius:12px; border:1px solid #e2e8f0; box-shadow:0 4px 6px rgba(0,0,0,0.05);">
    <h3 style="margin-top:0; font-size:18px; color:#0f172a;">
        <?php echo $cat_id > 0 ? 'Edit Category' : 'Create Category'; ?>
    </h3>
    
    <form method="post">
        <div style="margin-bottom:15px;">
            <label style="display:block; font-size:12px; font-weight:700; color:#64748b; margin-bottom:8px; text-transform:uppercase;">Category Name</label>
            <input type="text" 
                   name="ifst_cat_name" 
                   value="<?php echo esc_attr($current_name); ?>" 
                   style="width:100%; padding:12px; border:1px solid #cbd5e1; border-radius:8px; font-size:14px;" 
                   placeholder="e.g. Real Estate" 
                   required>
        </div>
        
        <button class="button button-primary" style="width:100%; height:44px; font-weight:600; border-radius:8px;">
            <?php echo $cat_id > 0 ? 'Update Category' : 'Add Category'; ?>
        </button>
        
        <?php if($cat_id > 0): ?>
            <a href="?page=ifs-testimonial&tab=categories&sub=all" style="display:block; text-align:center; margin-top:15px; color:#64748b; text-decoration:none; font-size:13px;">Cancel Edit</a>
        <?php endif; ?>
    </form>
</div>