<?php

if ( ! defined( 'ABSPATH' ) ) exit;

if (isset($_GET['action']) && $_GET['action'] === 'delete_cat') {
    
    // Check security nonce - name must match the link below exactly
    if (isset($_GET['cat_id']) && check_admin_referer('ifst_cat_action')) {
        
        $term_id = intval($_GET['cat_id']);
        
        // Use wp_delete_term (Standard WordPress function for categories)
        $deleted = wp_delete_term($term_id, 'testimonial_cat');

        if ($deleted && !is_wp_error($deleted)) {
            // Success: Use your exact Javascript redirect logic
            echo "<script>window.location.href='admin.php?page=ifs-testimonial&tab=testimonials&sub=all&msg=cat_deleted';</script>";
            exit;
        }
    }
}

// 2. SUCCESS NOTICE
if (isset($_GET['msg']) && $_GET['msg'] === 'cat_deleted') {
    echo '<div class="notice notice-success is-dismissible"><p>Category deleted successfully.</p></div>';
}
?>

<div class="ifst-dashboard" style="margin-top: 20px; max-width: 1100px; font-family: -apple-system, sans-serif;">
    
    <div class="ifst-card-container" style="background: #fff; border: 1px solid #e2e8f0; border-radius: 16px; overflow: hidden; box-shadow: 0 4px 6px -1px rgba(0,0,0,0.05);">
        <table style="width: 100%; border-collapse: collapse; text-align: left;">
            <thead>
                <tr style="background: #f8fafc; border-bottom: 1px solid #e2e8f0;">
                    <th style="padding: 18px 25px; color: #475569; font-size: 11px; text-transform: uppercase; letter-spacing: 1px;">Category Name</th>
                    <th style="padding: 18px 25px; color: #475569; font-size: 11px; text-transform: uppercase; letter-spacing: 1px;">Slug</th>
                    <th style="padding: 18px 25px; color: #475569; font-size: 11px; text-transform: uppercase; letter-spacing: 1px; text-align: center;">Batches</th>
                    <th style="padding: 18px 25px; color: #475569; font-size: 11px; text-transform: uppercase; letter-spacing: 1px; text-align: right;">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $categories = get_terms(['taxonomy' => 'testimonial_cat', 'hide_empty' => false]);
                if(!empty($categories) && !is_wp_error($categories)): foreach($categories as $cat): 
                ?>
                <tr class="ifst-row-hover" style="border-bottom: 1px solid #f1f5f9; transition: 0.2s;">
                    
                    <td style="padding: 18px 25px;">
                        <span style="background: #eff6ff; color: #2563eb; padding: 5px 12px; border-radius: 6px; font-size: 12px; font-weight: 700; border: 1px solid #dbeafe;">
                            📁 <?php echo esc_html($cat->name); ?>
                        </span>
                    </td>

                    <td style="padding: 18px 25px;">
                        <code style="background: #f1f5f9; padding: 3px 8px; border-radius: 4px; color: #64748b; font-size: 12px;"><?php echo esc_html($cat->slug); ?></code>
                    </td>

                    <td style="padding: 18px 25px; text-align: center;">
                        <div style="display: inline-flex; align-items: center; justify-content: center; background: #f1f5f9; color: #475569; width: 34px; height: 34px; border-radius: 50%; font-weight: 800; font-size: 12px; border: 1px solid #e2e8f0;">
                            <?php echo esc_attr($cat->count); ?>
                        </div>
                    </td>

                    <td style="padding: 18px 25px; text-align: right;">
    <div style="display: flex; gap: 8px; justify-content: flex-end;">
        
        <a href="?page=ifs-testimonial&tab=categories&sub=add&cat_id=<?php echo esc_attr($cat->term_id); ?>" class="ifst-icon edit" title="Edit">
            ✎
        </a>

        <?php 
        $del_url = wp_nonce_url("?page=ifs-testimonial&tab=categories&sub=all&action=delete_cat&cat_id=".esc_attr($cat->term_id), 'ifst_cat_action'); 
        ?>
        <a href="<?php echo esc_url($del_url); ?>" class="ifst-icon delete" title="Delete" onclick="return confirm('Permanently delete this category?')">
            🗑
        </a>
        
    </div>
</td>
                </tr>
                <?php endforeach; else: ?>
                    <tr><td colspan="4" style="padding: 60px; text-align: center; color: #94a3b8; font-style: italic;">No categories found.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<style>
/* Synchronized with your Batch List CSS */
.ifst-row-hover:hover { background: #fcfdfe; }
.ifst-icon {
    width: 36px; height: 36px; display: flex; align-items: center; justify-content: center;
    border-radius: 10px; border: 1px solid #e2e8f0; color: #64748b; background: #fff;
    transition: all 0.2s ease; text-decoration: none;
}
.ifst-icon:hover { transform: translateY(-2px); box-shadow: 0 4px 6px rgba(0,0,0,0.05); }
.ifst-icon.edit:hover { border-color: #f59e0b; color: #f59e0b; background: #fffbeb; }
.ifst-icon.delete:hover { border-color: #ef4444; color: #ef4444; background: #fef2f2; }
</style>