<?php
/**
 * Template per il toggle Dark Mode (FRONTEND - senza donazioni)
 * 
 * @package DarkModeSwitcherUniversal
 */

// Prevenire accesso diretto
if (!defined('ABSPATH')) {
    exit;
}

$position = $options['toggle_position'];
$style = $options['toggle_style'];
?>

<div class="iads-toggle-container <?php echo esc_attr($position); ?>">
    <div class="iads-toggle-wrapper <?php echo esc_attr($style); ?>">
        
        <!-- Toggle Switch -->
        <button class="iads-toggle-switch"
                type="button" 
                role="switch" 
                aria-checked="false"
                aria-label="<?php esc_attr_e('Attiva/Disattiva Dark Mode', 'improve-accessibility-dark-mode-switcher'); ?>"
                title="<?php esc_attr_e('Cambia tema', 'improve-accessibility-dark-mode-switcher'); ?>">
            
            <!-- Icone del sole e luna -->
            <span class="iads-icon iads-icon-sun" aria-hidden="true">☀️</span>
            <span class="iads-icon iads-icon-moon" aria-hidden="true">🌙</span>
        </button>
        
        <!-- Etichetta del toggle -->
        <span class="iads-toggle-label"
              data-light-label="<?php esc_attr_e('Light Mode', 'improve-accessibility-dark-mode-switcher'); ?>"
              data-dark-label="<?php esc_attr_e('Dark Mode', 'improve-accessibility-dark-mode-switcher'); ?>">
            <?php esc_html_e('Light Mode', 'improve-accessibility-dark-mode-switcher'); ?>
        </span>
        
    </div>
</div>

<!-- Schema.org markup per accessibilità -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebApplication",
  "name": "Improve Accessibility - Dark Mode Switcher for WP",
  "description": "<?php esc_attr_e('Toggle per cambiare tra modalità chiara e scura', 'improve-accessibility-dark-mode-switcher'); ?>",
  "applicationCategory": "UtilitiesApplication",
  "operatingSystem": "Any"
}
</script>