# 🌍 File Traduzioni - Improve Accessibility - Dark Mode Switcher for WP

Questa cartella contiene tutti i file di traduzione per il plugin Dark Mode Switcher Universal.

## 📁 Struttura File

```
languages/
├── dark-mode-switcher.pot               # Template principale (per traduttori)
├── dark-mode-switcher-it_IT.po          # Traduzioni italiane (sorgente)
├── dark-mode-switcher-it_IT.mo          # Traduzioni italiane (compilate)
├── dark-mode-switcher-en_US.po          # Traduzioni inglesi (sorgente)
├── dark-mode-switcher-en_US.mo          # Traduzioni inglesi (compilate)
├── compile-languages.php                # Script compilazione .po → .mo
└── README.md                            # Questo file
```

## 🚀 Come Usare le Traduzioni

### Per Utenti WordPress:
1. I file `.mo` sono automaticamente caricati dal plugin
2. La lingua si basa sulle impostazioni WordPress (`WPLANG`)
3. **Nessuna configurazione necessaria** - tutto automatico!

### Per Sviluppatori:
```php
// Il plugin carica automaticamente le traduzioni
load_plugin_textdomain('improve-accessibilit-dark-mode-switcher-gws', false, dirname(plugin_basename(__FILE__)) . '/languages/');

// Usa le funzioni WordPress standard
__('Dark Mode', 'improve-accessibilit-dark-mode-switcher-gws')        // Ritorna traduzione
_e('Light Mode', 'improve-accessibilit-dark-mode-switcher-gws')       // Stampa traduzione
esc_html__('Safe text', 'dark-mode-switcher') // Escape + traduzione
```

## 🔨 Compilare le Traduzioni

### Metodo 1: Script PHP (Incluso)
```bash
cd wp-content/plugins/improve-accessibilit-dark-mode-switcher-gws/languages/
php compile-languages.php
```

### Metodo 2: WP-CLI
```bash
# Genera template .pot
wp i18n make-pot . languages/dark-mode-switcher.pot

# Compila file .po in .mo
wp i18n make-mo languages/
```

### Metodo 3: Poedit (GUI)
1. Apri file `.po` in **Poedit**
2. Modifica traduzioni
3. Salva (auto-genera `.mo`)

### Metodo 4: msgfmt (Command Line)
```bash
msgfmt -o dark-mode-switcher-it_IT.mo dark-mode-switcher-it_IT.po
```

## 🌐 Lingue Supportate

### ✅ Disponibili (100% tradotte):
- **🇮🇹 Italiano** (`it_IT`) - Completo
- **🇬🇧 Inglese** (`en_US`) - Default + Completo

### 🔄 In Preparazione:
- **🇪🇸 Spagnolo** (`es_ES`) - Template ready
- **🇫🇷 Francese** (`fr_FR`) - Template ready
- **🇩🇪 Tedesco** (`de_DE`) - Template ready
- **🇳🇱 Olandese** (`nl_NL`) - Template ready
- **🇵🇹 Portoghese** (`pt_PT`) - Template ready

## 📝 Aggiungere Nuove Traduzioni

### Step 1: Crea File .po
```bash
# Copia template
cp dark-mode-switcher.pot dark-mode-switcher-es_ES.po
```

### Step 2: Modifica Header
```gettext
"Language-Team: Spanish\n"
"Language: es_ES\n"
"Plural-Forms: nplurals=2; plural=(n != 1);\n"
```

### Step 3: Traduci Stringhe
```gettext
#: templates/toggle.php:33
msgid "Light Mode"
msgstr "Modo Claro"

#: templates/toggle.php:34  
msgid "Dark Mode"
msgstr "Modo Oscuro"
```

### Step 4: Compila
```bash
php compile-languages.php
# O manualmente:
msgfmt -o dark-mode-switcher-es_ES.mo dark-mode-switcher-es_ES.po
```

### Step 5: Testa
- Cambia lingua WordPress
- Verifica traduzioni nel plugin

## 🔍 Stringhe Principali da Tradurre

### Frontend (Toggle):
- Light Mode / Dark Mode
- Toggle descriptions
- Coffee button text
- Accessibility labels

### Admin Panel:
- Menu titles and tabs
- Form labels and descriptions
- Success/error messages
- Help text and tooltips

### API Responses:
- JSON response messages
- Error messages
- Validation text

## 🛠️ Tools Utili per Traduttori

### Editor GUI:
- **Poedit** - Editor grafico professionale
- **Loco Translate** - Plugin WordPress
- **WPML** - Translation management

### Validatori:
```bash
# Verifica sintassi .po
msgfmt --check dark-mode-switcher-it_IT.po

# Statistiche traduzioni
msgfmt --statistics dark-mode-switcher-it_IT.po
```

### Online Tools:
- **Crowdin** - Collaborative translation
- **Transifex** - Translation platform
- **GlotPress** - WordPress.org translations

## 📊 Statistiche Traduzioni

### File Sizes:
- `.pot` template: ~8KB (240+ stringhe)
- `.po` italiano: ~12KB (tradotto)
- `.mo` italiano: ~6KB (compilato)

### Coverage:
- **Core Plugin**: 100% traducibile
- **Admin Interface**: 100% traducibile
- **Frontend Toggle**: 100% traducibile
- **API Responses**: 100% traducibile
- **Error Messages**: 100% traducibile

## 🚨 Note Importanti

### Text Domain:
**SEMPRE** usa `'dark-mode-switcher'` come text domain:
```php
// ✅ CORRETTO
__('My text', 'dark-mode-switcher')

// ❌ SBAGLIATO  
__('My text', 'iads')
__('My text') // Manca text domain
```

### Plurali:
Per lingue con plurali complessi:
```php
sprintf(
    _n('%d item', '%d items', $count, 'dark-mode-switcher'),
    $count
)
```

### Context:
Per disambiguare traduzioni:
```php
_x('Post', 'noun', 'dark-mode-switcher')  // Articolo
_x('Post', 'verb', 'dark-mode-switcher')  // Pubblicare
```

### Escape:
Sempre escape l'output:
```php
echo esc_html__('Safe text', 'dark-mode-switcher');
echo '<div title="' . esc_attr__('Tooltip', 'dark-mode-switcher') . '">';
```

## 🤝 Contribuire alle Traduzioni

### Per WordPress.org:
1. Vai su [translate.wordpress.org](https://translate.wordpress.org)
2. Cerca "Dark Mode Switcher Universal"
3. Scegli la tua lingua
4. Inizia a tradurre!

### Per GitHub:
1. Fork del repository
2. Crea/modifica file `.po`
3. Compila in `.mo`
4. Pull request

### Contatta il Team:
- **Email**: info@getwebsolution.it
- **GitHub Issues**: Report translation bugs
- **WordPress Forum**: Community support

## 🎯 Checklist Qualità Traduzioni

- [ ] **Completezza**: Tutte le stringhe tradotte
- [ ] **Consistenza**: Terminologia uniforme
- [ ] **Contesto**: Traduzioni appropriate al contesto
- [ ] **Lunghezza**: Testi non troppo lunghi per UI
- [ ] **Formale/Informale**: Tono appropriato
- [ ] **Plurali**: Gestiti correttamente
- [ ] **Encoding**: UTF-8 senza BOM
- [ ] **Testing**: Testato in WordPress

## 📚 Risorse Utili

### WordPress i18n:
- [Handbook Internationalization](https://developer.wordpress.org/plugins/internationalization/)
- [Function Reference](https://codex.wordpress.org/I18n_for_WordPress_Developers)

### Gettext:
- [GNU Gettext Manual](https://www.gnu.org/software/gettext/manual/)
- [PO File Format](https://www.gnu.org/software/gettext/manual/html_node/PO-Files.html)

### WordPress.org:
- [Polyglots Handbook](https://make.wordpress.org/polyglots/handbook/)
- [Translation Style Guide](https://make.wordpress.org/polyglots/handbook/translating/basics/)

---

## 🙏 Ringraziamenti

Grazie a tutti i traduttori che contribuiscono a rendere Improve Accesibility - Dark Mode Switcher for WP accessibile a utenti di tutto il mondo!

**Traduci anche tu** - ogni contributo è prezioso! 🌍✨