# Improve Accesibility - Dark Mode Switcher

**Contributors:** ermaldbilla
**Tags:** dark mode, accessibility, theme switcher
**Requires at least:** 5.8
**Tested up to:** 6.8
**Stable tag:** 1.0.0  
**License:** GPLv2 or later  
**License URI:** https://www.gnu.org/licenses/gpl-2.0.html

A secure WordPress plugin to add a universal dark/light mode toggle to your website with localStorage support and PayPal donation functionality.

## Logo and Branding

The plugin includes a **custom modern SVG logo** that represents:
- **Sun** (light mode) on the left side
- **Moon** (dark mode) on the right side
- **Toggle switch** in the center
- **Modern purple-blue gradient**
- **Shadow effects** for depth

**Logo location**: `assets/images/logo.svg`  
**Usage**: Automatically displayed in admin header and toggle (optional)

## Complete Installation

### Option 1: Manual Upload
1. **Download**: Download all plugin files
2. **Structure**: Create folder with the exact structure indicated above
3. **Upload**: Upload `improve-accessibility-dark-mode-switcher/` to `/wp-content/plugins/`
4. **Activate**: Go to WordPress admin → Plugins → Activate "Improve Accessibility - Dark Mode Switcher"

### Option 2: WordPress Admin
1. **Plugins** → **Add New**
2. **Search** for "Dark Mode Switcher Universal"
3. **Install** and **Activate**

## Features

- **Universal Dark/Light Mode Toggle** responsive and modern
- **Maximum WordPress Security** (nonces, sanitization, escape)
- **localStorage Support** to maintain user preferences
- **Modern UX/UI Design** fully customizable
- **Integrated PayPal Donation System**
- **Fully Responsive** and mobile-friendly
- **Optimized Performance** with minified CSS/JS
- **Multilingual Support** ready
- **Complete Admin Panel**
- **JavaScript API** for developers

## Plugin File Structure

```
improve-accessibility-dark-mode-switcher/
├── improve-accessibilit-dark-mode-switcher.php      # Main plugin file
├── README.md                              # Documentation
├── languages/                             # Translation files
│   ├── dark-mode-switcher-it_IT.po
│   └── dark-mode-switcher-it_IT.mo
├── assets/                                # CSS/JS Assets
│   ├── css/
│   │   ├── frontend.css                   # Frontend styles
│   │   └── admin.css                      # Admin styles
│   └── js/
│       ├── frontend.js                    # Frontend JavaScript
│       └── admin.js                       # Admin JavaScript
├── templates/                             # PHP Templates
│   ├── toggle.php                         # Toggle template
│   └── admin-page.php                     # Admin page
└── includes/                              # Additional PHP Classes
    ├── class-security.php                 # Security management
    ├── class-database.php                 # Database management
    └── class-api.php                      # REST API
```

## Configuration

### General Settings
- **Toggle Position**: Choose where to position the toggle (screen corners)
- **Toggle Style**: Modern or Classic
- **Custom CSS**: Add your CSS for advanced customizations

### Donation Settings
- **Enable Donations**: Show/hide the "Buy me a coffee" button
- **PayPal Email**: Your PayPal email to receive donations
- **Donation Amount**: Preset to €5.00 (customizable)

## WordPress Security

The plugin implements all WordPress security levels:

- **Nonces**: CSRF protection for all forms
- **Sanitization**: All inputs are sanitized
- **Escape**: Output always escaped to prevent XSS
- **Permissions**: User permission control
- **Database**: Prepared queries to prevent SQL injection
- **File Access**: Protection against direct file access

## JavaScript API for Developers

```javascript
// Get current theme
const currentTheme = window.iadsAPI.getTheme();

// Change theme
window.iadsAPI.setTheme('dark'); // or 'light'

// Toggle theme
window.iadsAPI.toggleTheme();

// Reset to system preferences
window.iadsAPI.resetTheme();

// Theme change listener
window.iadsAPI.onThemeChange((theme) => {
    console.log('New theme:', theme);
});
```

## CSS Customizations

The plugin uses CSS variables for easy customization:

```css
:root {
    --iads-light-bg: #ffffff;
    --iads-light-text: #333333;
    --iads-dark-bg: #1a1a1a;
    --iads-dark-text: #ffffff;
    --iads-accent-primary: #007cba;
    --iads-transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

/* Dark theme customizations */
[data-theme="dark"] {
    background-color: var(--iads-dark-bg);
    color: var(--iads-dark-text);
}
```

## Multilingual Support

The plugin is translation-ready with the following text domains:
- **Text Domain**: `improve-accessibility-dark-mode-switcher`
- **Domain Path**: `/languages`

Main translated strings:
- Toggle interface (Light Mode, Dark Mode)
- Complete admin panel
- Error and success messages
- Tooltips and descriptions

## Compatibility

- **WordPress**: 5.0+ (tested up to 6.8.2)
- **PHP**: 7.4+ (recommended 8.0+)
- **Browsers**: Chrome, Firefox, Safari, Edge
- **Devices**: Desktop, Tablet, Mobile
- **Themes**: Compatible with all WordPress themes

## Shortcodes and Hooks

### Shortcode
```php
// Display toggle anywhere
[iads_toggle position="inline" style="modern"]
```

### WordPress Hooks
```php
// Hook for developers
do_action('iads_theme_changed', $new_theme);
add_filter('iads_toggle_options', 'my_custom_options');
```

## Troubleshooting

### Common Issues

1. **Toggle doesn't appear**: Verify that the plugin is active
2. **Styles not applied**: Check for CSS conflicts with the theme
3. **LocalStorage not working**: Check HTTPS and browser privacy settings
4. **PayPal donations**: Verify PayPal email is configured correctly

### Debug Mode
Add `?iads_debug=1` to the URL for debug information in the console.

## Performance

- **CSS**: Minified and optimized (~8KB)
- **JavaScript**: Minified with lazy loading (~12KB)
- **Database**: Only 2 additional queries for loading
- **Caching**: Compatible with cache plugins
- **CDN**: Assets can be served from CDN

## Support and Contributions

- **Issues**: Report bugs or request features
- **Pull Requests**: Contributions always welcome
- **Documentation**: Help improve documentation
- **Translations**: Contribute with new languages

## License

GPL v2 or later - Standard WordPress open source license.

## Credits

Developed with ❤️ for the WordPress community.

**If the plugin is useful to you, consider buying the developer a coffee ☕!**

---

## Changelog

### v1.0.0 (2025-09-10)
- Initial release
- Modern responsive design
- Complete WordPress security implementation
- localStorage support
- PayPal donation system
- Multilingual base
- Mobile compatibility
- JavaScript API for developers