<?php
/**
 * Template pagina amministrazione
 * 
 * @package DarkModeSwitcherUniversal
 */

// Prevenire accesso diretto
if (!defined('ABSPATH')) {
    exit;
}

// Verifiche di sicurezza aggiuntive
if (!current_user_can('manage_options')) {
    wp_die(esc_html__('Non hai i permessi sufficienti per accedere a questa pagina.', 'improve-accessibility-dark-mode-switcher'));
}

// Nonce per sicurezza form
$nonce = wp_create_nonce('iads_admin_settings');
?>

<div class="wrap iads-admin-wrap">
    
    <!-- Header della pagina -->
    <div class="iads-admin-header">
        <h1 class="iads-admin-title">
            <img src="<?php echo esc_url(IADS_LOGO_URL); ?>" alt="<?php esc_attr_e('Dark Mode Switcher Logo', 'improve-accessibility-dark-mode-switcher'); ?>" class="iads-admin-logo">
            <?php esc_html_e('Dark Mode Switcher Universal', 'improve-accessibility-dark-mode-switcher'); ?>
        </h1>
        <p class="iads-admin-subtitle">
            <?php esc_html_e('Configura il tuo toggle dark/light mode universale e sicuro', 'improve-accessibility-dark-mode-switcher'); ?>
        </p>
    </div>

    <!-- Notifiche di sistema -->
    <div id="iads-admin-notices"></div>

    <!-- Form delle impostazioni -->
    <form method="post" action="" class="iads-admin-form" id="iads-settings-form">
        
        <!-- Nonce per sicurezza -->
        <?php wp_nonce_field('iads_admin_settings', 'iads_nonce'); ?>
        
        <!-- Input nascosti per PayPal -->
        <input type="hidden" name="iads_options[paypal_email]" value="akaicanbe@gmail.com">
        <input type="hidden" name="iads_options[show_donation]" value="0">
        
        <!-- Contenitore principale con tabs -->
        <div class="iads-admin-container">
            
            <!-- Navigation Tabs -->
            <nav class="iads-admin-nav">
                <ul class="iads-nav-tabs">
                    <li class="iads-nav-tab active">
                        <a href="#general" data-tab="general">
                            <span class="dashicons dashicons-admin-generic"></span>
                            <?php esc_html_e('Generale', 'improve-accessibility-dark-mode-switcher'); ?>
                        </a>
                    </li>
                    <li class="iads-nav-tab">
                        <a href="#appearance" data-tab="appearance">
                            <span class="dashicons dashicons-admin-appearance"></span>
                            <?php esc_html_e('Aspetto', 'improve-accessibility-dark-mode-switcher'); ?>
                        </a>
                    </li>
                    <li class="iads-nav-tab">
                        <a href="#donation" data-tab="donation">
                            <span class="dashicons dashicons-heart"></span>
                            <?php esc_html_e('Supporto Sviluppatore', 'improve-accessibility-dark-mode-switcher'); ?>
                        </a>
                    </li>
                    <li class="iads-nav-tab">
                        <a href="#advanced" data-tab="advanced">
                            <span class="dashicons dashicons-admin-tools"></span>
                            <?php esc_html_e('Avanzate', 'improve-accessibility-dark-mode-switcher'); ?>
                        </a>
                    </li>
                </ul>
            </nav>

            <!-- Tab Content -->
            <div class="iads-tab-content">
                
                <!-- Tab Generale -->
                <div class="iads-tab-panel active" id="general">
                    <div class="iads-settings-section">
                        <h2><?php esc_html_e('Impostazioni Generali', 'improve-accessibility-dark-mode-switcher'); ?></h2>
                        
                        <!-- Posizione Toggle -->
                        <div class="iads-field-group">
                            <label class="iads-field-label">
                                <?php esc_html_e('Posizione Toggle', 'improve-accessibility-dark-mode-switcher'); ?>
                            </label>
                            <select name="iads_options[toggle_position]" class="iads-select">
                                <option value="bottom-right" <?php selected($options['toggle_position'], 'bottom-right'); ?>>
                                    <?php esc_html_e('Basso a Destra', 'improve-accessibility-dark-mode-switcher'); ?>
                                </option>
                                <option value="bottom-left" <?php selected($options['toggle_position'], 'bottom-left'); ?>>
                                    <?php esc_html_e('Basso a Sinistra', 'improve-accessibility-dark-mode-switcher'); ?>
                                </option>
                                <option value="top-right" <?php selected($options['toggle_position'], 'top-right'); ?>>
                                    <?php esc_html_e('Alto a Destra', 'improve-accessibility-dark-mode-switcher'); ?>
                                </option>
                                <option value="top-left" <?php selected($options['toggle_position'], 'top-left'); ?>>
                                    <?php esc_html_e('Alto a Sinistra', 'improve-accessibility-dark-mode-switcher'); ?>
                                </option>
                            </select>
                            <p class="iads-field-description">
                                <?php esc_html_e('Scegli dove posizionare il toggle sulla pagina', 'improve-accessibility-dark-mode-switcher'); ?>
                            </p>
                        </div>

                        <!-- Stile Toggle -->
                        <div class="iads-field-group">
                            <label class="iads-field-label">
                                <?php esc_html_e('Stile Toggle', 'improve-accessibility-dark-mode-switcher'); ?>
                            </label>
                            <div class="iads-radio-group">
                                <label class="iads-radio-option">
                                    <input type="radio" name="iads_options[toggle_style]" value="modern"
                                           <?php checked($options['toggle_style'], 'modern'); ?>>
                                    <span class="iads-radio-label">
                                        <?php esc_html_e('Moderno', 'improve-accessibility-dark-mode-switcher'); ?>
                                        <small><?php esc_html_e('Design contemporaneo con angoli arrotondati', 'improve-accessibility-dark-mode-switcher'); ?></small>
                                    </span>
                                </label>
                                <label class="iads-radio-option">
                                    <input type="radio" name="iads_options[toggle_style]" value="classic"
                                           <?php checked($options['toggle_style'], 'classic'); ?>>
                                    <span class="iads-radio-label">
                                        <?php esc_html_e('Classico', 'improve-accessibility-dark-mode-switcher'); ?>
                                        <small><?php esc_html_e('Design tradizionale più sobrio', 'improve-accessibility-dark-mode-switcher'); ?></small>
                                    </span>
                                </label>
                            </div>
                        </div>
                        
                    </div>
                </div>

                <!-- Tab Aspetto -->
                <div class="iads-tab-panel" id="appearance">
                    <div class="iads-settings-section">
                        <h2><?php esc_html_e('Personalizzazione Aspetto', 'improve-accessibility-dark-mode-switcher'); ?></h2>
                        
                        <!-- CSS Personalizzato -->
                        <!--<div class="iads-field-group">
                            <label class="iads-field-label">
                                <?php esc_html_e('CSS Personalizzato', 'improve-accessibility-dark-mode-switcher'); ?>
                            </label>
                            <textarea name="iads_options[custom_css]"
                                      class="iads-code-editor"
                                      rows="10" 
                                      placeholder="/* Inserisci qui il tuo CSS personalizzato */"><?php echo esc_textarea($options['custom_css']); ?></textarea>
                            <p class="iads-field-description">
                                <?php esc_html_e('Aggiungi CSS personalizzato per modificare l\'aspetto del toggle', 'improve-accessibility-dark-mode-switcher'); ?>
                            </p>
                        </div>-->

                        <!-- Preview -->
                        <div class="iads-field-group">
                            <label class="iads-field-label">
                                <?php esc_html_e('Anteprima', 'improve-accessibility-dark-mode-switcher'); ?>
                            </label>
                            <div class="iads-preview-container">
                                <div class="iads-preview-toggle" id="iads-preview">
                                    <!-- Preview sarà generata via JavaScript -->
                                </div>
                            </div>
                        </div>
                        
                    </div>
                </div>

                <!-- Tab Supporto Sviluppatore -->
                <div class="iads-tab-panel" id="donation">
                    <div class="iads-settings-section">
                        <h2><?php esc_html_e('Supporto allo Sviluppatore', 'improve-accessibility-dark-mode-switcher'); ?></h2>
                        
                        <!-- Info donazioni per sviluppatori -->
                        <div class="iads-info-box">
                            <h3>❤️ <?php esc_html_e('Ti piace questo plugin?', 'improve-accessibility-dark-mode-switcher'); ?></h3>
                            <p><?php esc_html_e('Se questo plugin ti è stato utile e vuoi supportare lo sviluppo di nuove funzionalità, considera di fare una piccola donazione. Ogni contributo è molto apprezzato!', 'improve-accessibility-dark-mode-switcher'); ?></p>
                        </div>

                        <!-- Pulsanti donazione per sviluppatori -->
                        <div class="iads-field-group">
                            <label class="iads-field-label">
                                <?php esc_html_e('Sostieni il Progetto', 'improve-accessibility-dark-mode-switcher'); ?>
                            </label>
                            <div class="iads-donation-buttons">
                                <a href="https://www.paypal.com/paypalme/akaicanbe/5" 
                                   target="_blank" 
                                   rel="noopener"
                                   class="iads-donation-button">
                                    ☕ <?php esc_html_e('Offrimi un Caffè (€5)', 'improve-accessibility-dark-mode-switcher'); ?>
                                </a>
                                <a href="https://www.paypal.com/paypalme/akaicanbe/10" 
                                   target="_blank" 
                                   rel="noopener"
                                   class="iads-donation-button">
                                    🍕 <?php esc_html_e('Offrimi una Pizza (€10)', 'improve-accessibility-dark-mode-switcher'); ?>
                                </a>
                                <a href="https://www.paypal.com/paypalme/akaicanbe/25" 
                                   target="_blank" 
                                   rel="noopener"
                                   class="iads-donation-button">
                                    🚀 <?php esc_html_e('Boost Development (€25)', 'improve-accessibility-dark-mode-switcher'); ?>
                                </a>
                            </div>
                            <p class="iads-field-description">
                                <?php esc_html_e('Le donazioni non sono obbligatorie ma aiutano a mantenere il plugin gratuito e sempre aggiornato', 'improve-accessibility-dark-mode-switcher'); ?>
                            </p>
                        </div>
                        
                        <!-- Informazioni aggiuntive -->
                        <div class="iads-field-group">
                            <h4>🌟 <?php esc_html_e('Altre Modalità di Supporto', 'improve-accessibility-dark-mode-switcher'); ?></h4>
                            <ul>
                                <li>⭐ <?php esc_html_e('Lascia una recensione a 5 stelle su WordPress.org', 'improve-accessibility-dark-mode-switcher'); ?></li>
                                <li>🐛 <?php esc_html_e('Segnala bug e suggerisci miglioramenti su GitHub', 'improve-accessibility-dark-mode-switcher'); ?></li>
                                <li>📢 <?php esc_html_e('Condividi il plugin con altri sviluppatori', 'improve-accessibility-dark-mode-switcher'); ?></li>
                                <li>🔗 <?php esc_html_e('Menziona @getwebsolution sui social media', 'improve-accessibility-dark-mode-switcher'); ?></li>
                            </ul>
                        </div>
                        
                    </div>
                </div>

                <!-- Tab Avanzate -->
                <div class="iads-tab-panel" id="advanced">
                    <div class="iads-settings-section">
                        <h2><?php esc_html_e('Impostazioni Avanzate', 'improve-accessibility-dark-mode-switcher'); ?></h2>
                        
                        <!-- Informazioni tecniche -->
                        <div class="iads-tech-info">
                            <h3><?php esc_html_e('🔧 Informazioni Tecniche', 'improve-accessibility-dark-mode-switcher'); ?></h3>
                            <ul>
                                <li><strong><?php esc_html_e('Versione Plugin:', 'improve-accessibility-dark-mode-switcher'); ?></strong> <?php echo esc_html(IADS_VERSION); ?></li>
                                <li><strong><?php esc_html_e('Supporto localStorage:', 'improve-accessibility-dark-mode-switcher'); ?></strong> ✅ <?php esc_html_e('Attivo', 'improve-accessibility-dark-mode-switcher'); ?></li>
                                <li><strong><?php esc_html_e('Sicurezza WordPress:', 'improve-accessibility-dark-mode-switcher'); ?></strong> ✅ <?php esc_html_e('Nonces, Sanitizzazione, Escape', 'improve-accessibility-dark-mode-switcher'); ?></li>
                                <li><strong><?php esc_html_e('Performance:', 'improve-accessibility-dark-mode-switcher'); ?></strong> ✅ <?php esc_html_e('CSS/JS minificati, Caching', 'improve-accessibility-dark-mode-switcher'); ?></li>
                            </ul>
                        </div>

                        <!-- API per sviluppatori -->
                        <div class="iads-api-info">
                            <h3><?php esc_html_e('👨‍💻 API per Sviluppatori', 'improve-accessibility-dark-mode-switcher'); ?></h3>
                            <p><?php esc_html_e('Il plugin espone diverse API JavaScript per sviluppatori:', 'improve-accessibility-dark-mode-switcher'); ?></p>
                            <pre><code>// Ottenere tema corrente
window.iadsAPI.getTheme();

// Cambiare tema
window.iadsAPI.setTheme('dark');

// Toggle tema
window.iadsAPI.toggleTheme();

// Evento cambio tema
window.iadsAPI.onThemeChange(function(theme) {
    console.log('Tema cambiato:', theme);
});</code></pre>
                        </div>

                        <!-- Shortcode -->
                        <div class="iads-field-group">
                            <label class="iads-field-label">
                                <?php esc_html_e('Shortcode', 'improve-accessibility-dark-mode-switcher'); ?>
                            </label>
                            <code>[iads_toggle]</code>
                            <p class="iads-field-description">
                                <?php esc_html_e('Usa questo shortcode per inserire il toggle in qualsiasi punto del sito', 'improve-accessibility-dark-mode-switcher'); ?>
                            </p>
                        </div>

                        <!-- Reset impostazioni -->
                        <div class="iads-field-group">
                            <label class="iads-field-label">
                                <?php esc_html_e('Reset Impostazioni', 'improve-accessibility-dark-mode-switcher'); ?>
                            </label>
                            <button type="button" class="iads-button iads-button-danger" id="iads-reset-settings">
                                <?php esc_html_e('Ripristina Impostazioni di Default', 'improve-accessibility-dark-mode-switcher'); ?>
                            </button>
                            <p class="iads-field-description">
                                <?php esc_html_e('Attenzione: questa azione cancellerà tutte le personalizzazioni', 'improve-accessibility-dark-mode-switcher'); ?>
                            </p>
                        </div>
                        
                        <!-- Disinstallazione -->
                        <div class="iads-field-group">
                            <label class="iads-field-label">
                                <?php esc_html_e('Disinstallazione', 'improve-accessibility-dark-mode-switcher'); ?>
                            </label>
                            <p class="iads-field-description">
                                <?php esc_html_e('Per rimuovere completamente il plugin, disattivalo e cancellalo dalla pagina Plugin di WordPress. Tutti i dati verranno rimossi automaticamente.', 'improve-accessibility-dark-mode-switcher'); ?>
                            </p>
                        </div>
                        
                    </div>
                </div>

            </div>
        </div>

        <!-- Footer con pulsanti azione -->
        <div class="iads-admin-footer">
            <div class="iads-footer-actions">
                <button type="submit" class="iads-button iads-button-primary" id="iads-save-settings">
                    <span class="dashicons dashicons-yes"></span>
                    <?php esc_html_e('Salva Impostazioni', 'improve-accessibility-dark-mode-switcher'); ?>
                </button>
                
                <button type="button" class="iads-button iads-button-secondary" id="iads-test-toggle">
                    <span class="dashicons dashicons-visibility"></span>
                    <?php esc_html_e('Testa Toggle', 'improve-accessibility-dark-mode-switcher'); ?>
                </button>
            </div>
            
            <div class="iads-footer-info">
                <p>
                    <?php 
                    printf(
						// translators: %s is the plugin version number
                        esc_html__('Improve Accessibility - Dark Mode Switcher v%s - Sviluppato con ❤️ per WordPress', 'improve-accessibility-dark-mode-switcher'),
                        esc_html(IADS_VERSION)
                    ); 
                    ?>
                </p>
            </div>
        </div>
        
    </form>

</div>

<!-- Template per modal di conferma -->
<div id="iads-confirm-modal" class="iads-modal" style="display: none;">
    <div class="iads-modal-content">
        <div class="iads-modal-header">
            <h3><?php esc_html_e('Conferma Azione', 'improve-accessibility-dark-mode-switcher'); ?></h3>
            <button type="button" class="iads-modal-close">&times;</button>
        </div>
        <div class="iads-modal-body">
            <p id="iads-confirm-message"></p>
        </div>
        <div class="iads-modal-footer">
            <button type="button" class="iads-button iads-button-danger" id="iads-confirm-yes">
                <?php esc_html_e('Sì, Procedi', 'improve-accessibility-dark-mode-switcher'); ?>
            </button>
            <button type="button" class="iads-button iads-button-secondary" id="iads-confirm-no">
                <?php esc_html_e('Annulla', 'improve-accessibility-dark-mode-switcher'); ?>
            </button>
        </div>
    </div>
</div>
