<?php
/** Backup & Restore Subpage */
/** @var array $settings */
/** @var array $status */
/** @var array $logs */

?>
<div class="wrap imgsmaller-backup-restore-page">
	<h1><?php esc_html_e( 'ImgSmaller – Backup & Restore', 'imgsmaller' ); ?></h1>

	<h2><?php esc_html_e( 'Restore Originals', 'imgsmaller' ); ?></h2>
	<p class="description"><?php esc_html_e( 'Restore all images from stored backups using the button below, or perform incremental/selected restores further down.', 'imgsmaller' ); ?></p>
	<form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" class="imgsmaller-inline-form js-restore-form">
		<?php wp_nonce_field( 'imgsmaller_restore' ); ?>
		<input type="hidden" name="action" value="imgsmaller_restore" />
		<button type="submit" class="button button-secondary js-restore-submit" data-default-label="<?php esc_attr_e( 'Restore Originals', 'imgsmaller' ); ?>">
			<?php esc_html_e( 'Restore Originals', 'imgsmaller' ); ?>
		</button>
	</form>
	<div class="imgsmaller-restore-status notice js-restore-status" aria-live="polite" hidden>
		<p class="js-restore-status-text"></p>
	</div>
	<div class="imgsmaller-restore-progress" aria-live="polite" style="max-width:480px;">
		<?php
		$rtotal = max( 0, (int) ( $status['restore_total'] ?? 0 ) );
		$rattempted = max( 0, (int) ( $status['restore_attempted'] ?? 0 ) );
		$rp = $rtotal > 0 ? min( 100, (int) round( ( $rattempted / $rtotal ) * 100 ) ) : 0;
		?>
		<div class="imgsmaller-progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" aria-valuenow="<?php echo esc_attr( (string) $rp ); ?>" aria-valuetext="<?php echo esc_attr( (string) $rp ); ?>%">
			<div class="imgsmaller-progress-bar__fill js-restore-progress-fill" style="width: <?php echo esc_attr( (string) $rp ); ?>%;"></div>
		</div>
		<p class="js-restore-progress-text" style="margin:8px 0 0; font-weight:600;">
			<?php
			/* translators: 1: processed count, 2: total count */
			printf( esc_html__( 'Restore progress: %1$d / %2$d', 'imgsmaller' ), (int) ( $status['restore_attempted'] ?? 0 ), (int) ( $status['restore_total'] ?? 0 ) );
			?>
		</p>
		if ( ! defined( 'ABSPATH' ) ) {
			exit;
		}
		<p style="margin:8px 0 0;">
			<button type="button" class="button button-secondary js-restore-step" data-default-label="<?php esc_attr_e( 'Run one restore step now', 'imgsmaller' ); ?>"><?php esc_html_e( 'Run one restore step now', 'imgsmaller' ); ?></button>
			<button type="button" class="button button-secondary js-cancel-restore" data-nonce="<?php echo esc_attr( wp_create_nonce( 'imgsmaller_dashboard' ) ); ?>"><?php esc_html_e( 'Cancel Restore', 'imgsmaller' ); ?></button>
		</p>
	</div>

	<hr style="margin:40px 0;" />

	<h2><?php esc_html_e( 'Restore Individual Images', 'imgsmaller' ); ?></h2>
	<p class="description"><?php esc_html_e( 'Select specific images (that have backups) to restore. Use search, then select one or more, and click Restore Selected.', 'imgsmaller' ); ?></p>
	<div class="imgsmaller-exclude-browser imgsmaller-restore-browser">
		<div class="imgsmaller-exclude-toolbar">
			<input type="search" class="regular-text js-restore-search imgsmaller-exclude-search" placeholder="<?php echo esc_attr__( 'Search images…', 'imgsmaller' ); ?>" />
			<button type="button" class="button button-secondary js-restore-refresh"><?php esc_html_e( 'Search', 'imgsmaller' ); ?></button>
		</div>
		<div class="imgsmaller-exclude-grid js-restore-grid" tabindex="0" role="region" aria-label="<?php echo esc_attr__( 'Restore images selector', 'imgsmaller' ); ?>">
			<!-- thumbnails injected by JS -->
		</div>
		<div class="imgsmaller-exclude-loading js-restore-loading"><?php esc_html_e( 'Loading…', 'imgsmaller' ); ?></div>
		<div class="imgsmaller-exclude-more" style="display:flex; gap:8px; align-items:center; flex-wrap:wrap;">
			<button type="button" class="button button-secondary js-restore-load-more"><?php esc_html_e( 'Load 50 more', 'imgsmaller' ); ?></button>
			<span style="flex:1 1 auto"></span>
			<button type="button" class="button js-restore-select-all"><?php esc_html_e( 'Select all on page', 'imgsmaller' ); ?></button>
			<button type="button" class="button js-restore-clear"><?php esc_html_e( 'Clear selection', 'imgsmaller' ); ?></button>
		</div>
		<div style="margin-top:8px; display:flex; gap:8px; align-items:center;">
			<button type="button" class="button button-primary js-restore-selected"><?php esc_html_e( 'Restore Selected', 'imgsmaller' ); ?></button>
			<span class="description js-restore-selected-count">0 selected</span>
		</div>
	</div>

	<hr style="margin:40px 0;" />

	<h2><?php esc_html_e( 'Backups', 'imgsmaller' ); ?></h2>
	<p class="description"><?php esc_html_e( 'Download an archive of saved originals or import an existing backup.', 'imgsmaller' ); ?></p>
	<?php if ( empty( $settings['enable_backup'] ) ) : ?>
		<div class="notice notice-warning inline"><p><?php esc_html_e( 'Backups are currently disabled. Enable them on the main page to keep new originals before compression.', 'imgsmaller' ); ?></p></div>
	<?php endif; ?>
	<div class="imgsmaller-backup-tools">
		<form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" class="imgsmaller-inline-form">
			<?php wp_nonce_field( 'imgsmaller_download_backup' ); ?>
			<input type="hidden" name="action" value="imgsmaller_download_backup" />
			<button type="submit" class="button"><?php esc_html_e( 'Download Backup Zip', 'imgsmaller' ); ?></button>
		</form>
		<form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" enctype="multipart/form-data" class="imgsmaller-inline-form imgsmaller-backup-import">
			<?php wp_nonce_field( 'imgsmaller_import_backup' ); ?>
			<input type="hidden" name="action" value="imgsmaller_import_backup" />
			<label for="imgsmaller-backup-zip" class="screen-reader-text"><?php esc_html_e( 'Select backup zip to upload', 'imgsmaller' ); ?></label>
			<input type="file" id="imgsmaller-backup-zip" name="imgsmaller_backup_zip" accept="application/zip,.zip" required />
			<button type="submit" class="button button-secondary"><?php esc_html_e( 'Upload Backup Zip', 'imgsmaller' ); ?></button>
		</form>
		<form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" enctype="multipart/form-data" class="imgsmaller-inline-form imgsmaller-replace-import">
			<?php wp_nonce_field( 'imgsmaller_import_replacements' ); ?>
			<input type="hidden" name="action" value="imgsmaller_import_replacements" />
			<label for="imgsmaller-replace-zip" class="screen-reader-text"><?php esc_html_e( 'Select compressed zip to upload', 'imgsmaller' ); ?></label>
			<input type="file" id="imgsmaller-replace-zip" name="imgsmaller_replace_zip" accept="application/zip,.zip" required />
			<button type="submit" class="button button-secondary"><?php esc_html_e( 'Upload Compressed Zip (apply)', 'imgsmaller' ); ?></button>
		</form>
		<div class="imgsmaller-delete-backups js-delete-backups">
			<form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" class="imgsmaller-inline-form">
				<?php wp_nonce_field( 'imgsmaller_delete_backups' ); ?>
				<input type="hidden" name="action" value="imgsmaller_delete_backups" />
				<button type="button" class="button button-link-delete js-delete-backups-trigger"><?php esc_html_e( 'Delete Backup Files', 'imgsmaller' ); ?></button>
				<div class="imgsmaller-delete-confirm js-delete-backups-confirm" hidden>
					<label for="imgsmaller-delete-backups-confirm-input" class="screen-reader-text"><?php esc_html_e( 'Type DELETE to confirm backup removal', 'imgsmaller' ); ?></label>
					<input type="text" id="imgsmaller-delete-backups-confirm-input" class="regular-text js-delete-backups-input" placeholder="DELETE" autocomplete="off" />
					<button type="submit" class="button button-secondary js-delete-backups-submit" disabled><?php esc_html_e( 'Confirm Delete', 'imgsmaller' ); ?></button>
					<button type="button" class="button button-link js-delete-backups-cancel"><?php esc_html_e( 'Cancel', 'imgsmaller' ); ?></button>
				</div>
			</form>
		</div>
	</div>

	<hr style="margin:40px 0;" />

	<h2><?php esc_html_e( 'Danger Zone', 'imgsmaller' ); ?></h2>
	<p class="description"><?php esc_html_e( 'Resetting will clear plugin settings, status, activity logs, processing queues, and image processing markers. It will not delete your media files. You will need to reconfigure the plugin after reset.', 'imgsmaller' ); ?></p>
	<div class="imgsmaller-danger-zone js-reset-plugin">
		<form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" class="imgsmaller-inline-form">
			<?php wp_nonce_field( 'imgsmaller_reset_plugin' ); ?>
			<input type="hidden" name="action" value="imgsmaller_reset_plugin" />
			<button type="button" class="button button-link-delete js-reset-plugin-trigger"><?php esc_html_e( 'Reset Plugin', 'imgsmaller' ); ?></button>
			<div class="imgsmaller-delete-confirm js-reset-plugin-confirm" hidden>
				<label for="imgsmaller-reset-plugin-confirm-input" class="screen-reader-text"><?php esc_html_e( 'Type RESET to confirm reset', 'imgsmaller' ); ?></label>
				<input type="text" id="imgsmaller-reset-plugin-confirm-input" class="regular-text js-reset-plugin-input" placeholder="RESET" autocomplete="off" />
				<button type="submit" class="button button-secondary js-reset-plugin-submit" disabled><?php esc_html_e( 'Confirm Reset', 'imgsmaller' ); ?></button>
				<button type="button" class="button button-link js-reset-plugin-cancel"><?php esc_html_e( 'Cancel', 'imgsmaller' ); ?></button>
				<div style="margin-top:8px;">
					<label><input type="checkbox" name="imgsmaller_delete_backups" value="1" class="js-reset-delete-backups-toggle" /> <?php esc_html_e( 'Also delete backup files', 'imgsmaller' ); ?></label>
					<div class="js-reset-delete-backups-confirm" style="margin-top:6px;" hidden>
						<label for="imgsmaller-reset-delete-backups-input" class="screen-reader-text"><?php esc_html_e( 'Type DELETE to confirm backup removal', 'imgsmaller' ); ?></label>
						<input type="text" id="imgsmaller-reset-delete-backups-input" class="regular-text js-reset-delete-backups-input" placeholder="DELETE" autocomplete="off" />
					</div>
					<p class="description" style="margin-top:6px;">
						<?php esc_html_e( 'Warning: This permanently deletes the ImgSmaller backup folder and its files.', 'imgsmaller' ); ?>
					</p>
				</div>
			</div>
		</form>
	</div>
</div>
