﻿<?php
/**
 * Plugin Name:       ImgSmaller - Optimize Images | Compress Images | Convert WebP & AVIF
 * Description:       Compress and optimize WordPress media library images using the ImgSmaller API with automated backups and restore controls.
 * Version:           1.0.1
 * Requires at least: 5.8
 * Requires PHP:      7.4
 * Author:            ImgSmaller
 * Author URI:        https://imgsmaller.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       imgsmaller
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'IMGSMALLER_PLUGIN_FILE', __FILE__ );
define( 'IMGSMALLER_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'IMGSMALLER_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'IMGSMALLER_VERSION', '1.0.1' );
define( 'IMGSMALLER_CRON_HOOK', 'imgsmaller_process_batch' );
define( 'IMGSMALLER_RESTORE_CRON_HOOK', 'imgsmaller_process_restore_batch' );

// Simple PSR-4 like autoloader for plugin classes.

spl_autoload_register(
	static function ( string $class ) : void {
		if ( strpos( $class, 'Imgspalat\\' ) !== 0 ) {
			return;
		}

		$relative = substr( $class, strlen( 'Imgspalat\\' ) );
		$relative = str_replace( '\\', DIRECTORY_SEPARATOR, $relative );
		$path     = IMGSMALLER_PLUGIN_DIR . 'src/' . $relative . '.php';

		if ( file_exists( $path ) ) {
			require_once $path;
		}
	}
);

/**
 * Helper for accessing the plugin singleton.
 */
function imgspalat_plugin() : Imgspalat\Plugin {
	return Imgspalat\Plugin::instance();
}

register_activation_hook( __FILE__, [ 'Imgspalat\\Plugin', 'activate' ] );
register_deactivation_hook( __FILE__, [ 'Imgspalat\\Plugin', 'deactivate' ] );
register_uninstall_hook( __FILE__, [ 'Imgspalat\\Plugin', 'uninstall' ] );

add_action(
	'plugins_loaded',
	static function () : void {
		imgspalat_plugin()->boot();
	}
);

