<?php
/*
    Plugin Name: Image Auto Descriptions for ACF
    Plugin URI: https://bronte.co.nz/
    Description: Automatically generates and displays descriptions for ACF image fields based on their settings.
    Version: 1.0
    Author: Bronte Development
    Author URI: https://bronte.co.nz/author/vidur
    License: GPL2
    Requires at least: 5.0
    Requires PHP: 7.4
*/

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

function image_auto_descriptions_for_acf($field) {
    $details = [];

    if ($field['min_width'] && $field['max_width'] && $field['min_height'] && $field['max_height']) {
        $details[] = 'Dimensions between: '.$field['min_width'].'x'.$field['min_height'].'px and '.$field['max_width'].'x'.$field['max_height'].'px';
    } elseif ($field['min_width'] && $field['min_height']) {
        $details[] = 'Minimum dimensions: '.$field['min_width'].'x'.$field['min_height'].'px';
    } elseif ($field['max_width'] && $field['max_height']) {
        $details[] = 'Maximum dimensions: '.$field['max_width'].'x'.$field['max_height'].'px';
    }

    if ($field['mime_types']) {
        $details[] = 'Allowed formats: '.implode(' or ', explode(',', strtoupper($field['mime_types'])))."";
    }

    if ($field['min_size'] && $field['max_size']) {
        $details[] = 'File size between: '.($field['min_size'] < 1 ? ($field['min_size'] * 1000).'kb' : $field['min_size'].'mb').' and '.($field['max_size'] < 1 ? ($field['max_size'] * 1000).'kb' : $field['max_size'].'mb');
    } elseif ($field['min_size']) {
        $details[] = 'Minimum file size: '.($field['min_size'] < 1 ? ($field['min_size'] * 1000).'kb' : $field['min_size'].'mb');
    } elseif ($field['max_size']) {
        $details[] = 'Maximum file size: '.($field['max_size'] < 1 ? ($field['max_size'] * 1000).'kb' : $field['max_size'].'mb');
    }

    if ($details) :
        ?>
        <p class="acf_image_helper"><?php echo esc_html(implode(', ', $details)); ?></p>
        <?php
    endif;
}

add_action('acf/render_field/type=image', 'image_auto_descriptions_for_acf', 5, 1);