<?php

/**
 *
 * @link              https://heizhu.org/author
 * @since             0.0.1
 * @package           Hz_Bot_Tiny_For_Discord
 *
 * @wordpress-plugin
 * Plugin Name:       HZ Bot Tiny For Discord
 * Plugin URI:        https://heizhu.org/discordbot
 * Description:       Your WooCommerce Management Assistant
 * Version:           0.0.1
 * Author:            heiblack
 * Author URI:        https://heizhu.org/author/
 * License:           GPL-2.0
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       hz-bot-tiny-for-discord
 * Domain Path:       /languages
 * Requires Plugins: woocommerce
 * Requires PHP: 8.0
 * WC requires at least: 8
 *
 */


 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if (class_exists('Hz_Discord_Bot_Tiny')) {
   return;
}


use HzBotTinyForDiscord\Includes\Hz_Discord_Bot_Tiny;

define('HZ_DISCORD_BOT_TINY_VERSION', '0.0.1');
define('HZ_DISCORD_BOT_TINY_PATH', plugin_dir_path(__FILE__));
define('HZ_DISCORD_BOT_TINY_URI', plugin_dir_url(__FILE__));
define('HZ_DISCORD_BOT_TINY_BASENAME', plugin_basename(__FILE__));


require HZ_DISCORD_BOT_TINY_PATH . 'includes/class-hz-discord-bot-tiny.php';


register_activation_hook(__FILE__, function ()
{
    require_once HZ_DISCORD_BOT_TINY_PATH . 'includes/class-hz-discord-bot-tiny-activator.php';
    Hz_Discord_Bot_Tiny_Activator::activate();
});



register_deactivation_hook(__FILE__, function ()
{
    require_once HZ_DISCORD_BOT_TINY_PATH . 'includes/class-hz-discord-bot-tiny-deactivator.php';
    Hz_Discord_Bot_Tiny_Deactivator::deactivate();
});


if (!function_exists('is_plugin_active')) {
    require_once(ABSPATH . 'wp-admin/includes/plugin.php');
}

if (version_compare(PHP_VERSION, '8.0', '>') &&
    is_plugin_active('woocommerce/woocommerce.php')
) {
    add_action('plugins_loaded', function ()
    {
        $plugin = new Hz_Discord_Bot_Tiny();
        $plugin->run();
    });
}



