<?php

class Hz_Discord_Bot_Details
{
    /**
     * 獲取訂單詳細資訊
     *
     * @return array
     */
    public static function get_order_details()
    {
        return apply_filters('hz_discord_bot_order_details', [
            'order_id' => esc_attr__('Order ID', 'hz-bot-tiny-for-discord'),
            'order_total' => esc_attr__('Order Total', 'hz-bot-tiny-for-discord'),
            'order_status' => esc_attr__('Order Status', 'hz-bot-tiny-for-discord'),
            'order_date' => esc_attr__('Order Date', 'hz-bot-tiny-for-discord'),
            'order_billing_first_name' => esc_attr__('Billing First Name', 'hz-bot-tiny-for-discord'),
            'order_billing_last_name' => esc_attr__('Billing Last Name', 'hz-bot-tiny-for-discord'),
            'order_billing_email' => esc_attr__('Billing Email', 'hz-bot-tiny-for-discord'),
            'order_billing_phone' => esc_attr__('Billing Phone', 'hz-bot-tiny-for-discord'),
            'order_billing_address_1' => esc_attr__('Billing Address 1', 'hz-bot-tiny-for-discord'),
            'order_billing_address_2' => esc_attr__('Billing Address 2', 'hz-bot-tiny-for-discord'),
            'order_billing_city' => esc_attr__('Billing City', 'hz-bot-tiny-for-discord'),
            'order_billing_state' => esc_attr__('Billing State', 'hz-bot-tiny-for-discord'),
            'order_billing_postcode' => esc_attr__('Billing Postcode', 'hz-bot-tiny-for-discord'),
            'order_billing_country' => esc_attr__('Billing Country', 'hz-bot-tiny-for-discord'),
            'order_shipping_first_name' => esc_attr__('Shipping First Name', 'hz-bot-tiny-for-discord'),
            'order_shipping_last_name' => esc_attr__('Shipping Last Name', 'hz-bot-tiny-for-discord'),
            'order_shipping_address_1' => esc_attr__('Shipping Address 1', 'hz-bot-tiny-for-discord'),
            'order_shipping_address_2' => esc_attr__('Shipping Address 2', 'hz-bot-tiny-for-discord'),
            'order_shipping_city' => esc_attr__('Shipping City', 'hz-bot-tiny-for-discord'),
            'order_shipping_state' => esc_attr__('Shipping State', 'hz-bot-tiny-for-discord'),
            'order_shipping_postcode' => esc_attr__('Shipping Postcode', 'hz-bot-tiny-for-discord'),
            'order_shipping_country' => esc_attr__('Shipping Country', 'hz-bot-tiny-for-discord'),
            'order_payment_method' => esc_attr__('Payment Method', 'hz-bot-tiny-for-discord'),
            'order_note' => esc_attr__('Order Note', 'hz-bot-tiny-for-discord'),
        ]);
    }

    /**
     * 獲取用戶詳細資訊
     *
     * @return array
     */
    public static function get_user_details()
    {
        return apply_filters('hz_discord_bot_user_details', [
            'user_id' => esc_attr__('User ID', 'hz-bot-tiny-for-discord'),
            'user_login' => esc_attr__('User Login', 'hz-bot-tiny-for-discord'),
            'user_email' => esc_attr__('User Email', 'hz-bot-tiny-for-discord'),
        ]);
    }

    /**
     * 獲取所有詳細資訊
     *
     * @return array
     */
    public static function get_all_details()
    {
        return [
            'order' => self::get_order_details(),
            'user' => self::get_user_details()
        ];
    }

    /**
     *
     * @return array
     */
    public static function get_webhooks_type()
    {
        return [
            'new' => esc_attr__('New Order Notification', 'hz-bot-tiny-for-discord'),
            'change' => esc_attr__('Order Status Change Notification', 'hz-bot-tiny-for-discord'),
            'register' => esc_attr__('New User Registration Notification', 'hz-bot-tiny-for-discord'),
        ];
    }
}
