<?php
/**
 * Uninstall Hungry Resource Monitor
 *
 * @package WPResourceMonitor
 */

// Exit if not called by WordPress
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete options
delete_option('nandresmon_options');

// Clear scheduled events
wp_clear_scheduled_hook('nandresmon_daily_cleanup');
wp_clear_scheduled_hook('nandresmon_send_report');

// Drop custom table
global $wpdb;
$nandresmon_table_name = $wpdb->prefix . 'nandresmon_logs';

// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.DirectDatabaseQuery.SchemaChange -- Direct DROP TABLE required for clean uninstall
$wpdb->query($wpdb->prepare("DROP TABLE IF EXISTS %i", $nandresmon_table_name));
