<?php
/**
 * Toolbar Widget Class
 *
 * @package WPResourceMonitor
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class NANDRESMON_Toolbar_Widget
 * Handles admin toolbar display
 */
class NANDRESMON_Toolbar_Widget
{

    /**
     * Get current stats for toolbar
     *
     * @return array Stats data.
     */
    public static function get_current_stats()
    {
        global $wpdb;

        $memory_peak = memory_get_peak_usage(true);
        $memory_limit = nandresmon_parse_ini_size('memory_limit');
        $percentage = ($memory_peak / $memory_limit) * 100;

        return array(
            'memory_peak' => $memory_peak,
            'memory_formatted' => nandresmon_format_bytes($memory_peak),
            'memory_limit' => $memory_limit,
            'memory_percentage' => round($percentage, 1),
            'query_count' => $wpdb->num_queries,
            'status_class' => nandresmon_get_status_class($percentage),
        );
    }
}
