<?php
/**
 * Support Page Class
 *
 * @package WPResourceMonitor
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class NANDRESMON_Support_Page
 * Renders the Support/Help tab with company promo
 */
class NANDRESMON_Support_Page
{

    /**
     * Render support tab content
     */
    public static function render()
    {
        ?>
        <div class="nandresmon-help-container">
            <!-- Main Content -->
            <div class="nandresmon-main-content">
                <!-- Nandann Promo -->
                <div class="nandresmon-card nandresmon-promo-card">
                    <div class="nandresmon-card-body" style="text-align: center; padding: 40px 30px;">
                        <div style="margin-bottom: 20px;">
                            <div class="nandresmon-logo">
                                <img src="<?php echo esc_url(NANDRESMON_PLUGIN_URL . 'assets/images/logo.png'); ?>"
                                    alt="Nandann" style="max-width: 200px; height: auto;">
                            </div>
                            <p
                                style="color: #7f8c8d; font-size: 12px; letter-spacing: 3px; margin: 0 0 20px 0; text-transform: uppercase; font-weight: 600;">
                                <?php esc_html_e('Creative Agency', 'hungry-resource-monitor'); ?>
                            </p>
                            <h3 style="font-size: 24px; color: #2c3e50; margin: 0 0 10px 0; font-weight: 700;">
                                <?php esc_html_e('Professional WordPress Development & Troubleshooting', 'hungry-resource-monitor'); ?>
                            </h3>
                            <p style="color: #95a5a6; font-size: 15px; margin: 0 0 25px 0; font-style: italic;">
                                <?php esc_html_e('Expert solutions for complex WordPress challenges', 'hungry-resource-monitor'); ?>
                            </p>
                            <p style="color: #555; line-height: 1.8; margin-bottom: 25px; font-size: 14px;">
                                <?php esc_html_e('Facing WordPress challenges? Get professional help from an experienced developer who understands the complexities of WordPress development.', 'hungry-resource-monitor'); ?>
                            </p>
                            <div style="margin-bottom: 20px;">
                                <a href="mailto:prakhar@nandann.com" class="button button-primary"
                                    style="background: #667eea; border: none; padding: 12px 30px; font-size: 15px;">
                                    <span class="dashicons dashicons-email-alt" style="margin-top: 3px;"></span>
                                    <?php esc_html_e('Get Expert Help', 'hungry-resource-monitor'); ?>
                                </a>
                            </div>
                            <a href="https://nandann.com" target="_blank" class="button" style="padding: 12px 30px;">
                                <span class="dashicons dashicons-external" style="margin-top: 3px;"></span>
                                <?php esc_html_e('Visit nandann.com', 'hungry-resource-monitor'); ?>
                            </a>
                        </div>
                    </div>

                    <!-- Services Grid -->
                    <div class="nandresmon-services-grid">
                        <div class="nandresmon-card">
                            <div class="nandresmon-card-body" style="text-align: center; padding: 25px;">
                                <div style="font-size: 40px; margin-bottom: 15px;">🔧</div>
                                <h4 style="margin: 0 0 10px 0; font-weight: 700;">
                                    <?php esc_html_e('WordPress Troubleshooting', 'hungry-resource-monitor'); ?>
                                </h4>
                                <p style="margin: 0; font-size: 13px; color: #7f8c8d;">
                                    <?php esc_html_e('Expert diagnosis and resolution of complex WordPress issues.', 'hungry-resource-monitor'); ?>
                                </p>
                            </div>
                        </div>
                        <div class="nandresmon-card">
                            <div class="nandresmon-card-body" style="text-align: center; padding: 25px;">
                                <div style="font-size: 40px; margin-bottom: 15px;">💻</div>
                                <h4 style="margin: 0 0 10px 0; font-weight: 700;">
                                    <?php esc_html_e('Custom Development', 'hungry-resource-monitor'); ?>
                                </h4>
                                <p style="margin: 0; font-size: 13px; color: #7f8c8d;">
                                    <?php esc_html_e('Bespoke plugins, themes, and custom functionality.', 'hungry-resource-monitor'); ?>
                                </p>
                            </div>
                        </div>
                        <div class="nandresmon-card">
                            <div class="nandresmon-card-body" style="text-align: center; padding: 25px;">
                                <div style="font-size: 40px; margin-bottom: 15px;">🚀</div>
                                <h4 style="margin: 0 0 10px 0; font-weight: 700;">
                                    <?php esc_html_e('Site Migration', 'hungry-resource-monitor'); ?>
                                </h4>
                                <p style="margin: 0; font-size: 13px; color: #7f8c8d;">
                                    <?php esc_html_e('Seamless migrations and hosting optimization.', 'hungry-resource-monitor'); ?>
                                </p>
                            </div>
                        </div>
                        <div class="nandresmon-card">
                            <div class="nandresmon-card-body" style="text-align: center; padding: 25px;">
                                <div style="font-size: 40px; margin-bottom: 15px;">🔒</div>
                                <h4 style="margin: 0 0 10px 0; font-weight: 700;">
                                    <?php esc_html_e('Security & Maintenance', 'hungry-resource-monitor'); ?>
                                </h4>
                                <p style="margin: 0; font-size: 13px; color: #7f8c8d;">
                                    <?php esc_html_e('Security audits and ongoing maintenance.', 'hungry-resource-monitor'); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

            <!-- Sidebar - Contact Form -->
            <div class="nandresmon-sidebar">
                <div class="nandresmon-card nandresmon-sidebar-card">
                    <div class="nandresmon-card-header">
                        <h3><span class="dashicons dashicons-email"></span>
                            <?php esc_html_e('Feedback / Comments / Message', 'hungry-resource-monitor'); ?></h3>
                    </div>
                    <div class="nandresmon-card-body">
                        <form id="nandresmon-contact-form" class="nandresmon-contact-form">
                            <?php wp_nonce_field('nandresmon_contact_nonce', 'nandresmon_contact_nonce'); ?>
                            <div class="nandresmon-form-group">
                                <label for="contact_name"><?php esc_html_e('Your Name', 'hungry-resource-monitor'); ?> <span
                                        class="required">*</span></label>
                                <input type="text" id="contact_name" name="contact_name" required>
                            </div>
                            <div class="nandresmon-form-group">
                                <label for="contact_email"><?php esc_html_e('Your Email', 'hungry-resource-monitor'); ?>
                                    <span class="required">*</span></label>
                                <input type="email" id="contact_email" name="contact_email" required>
                            </div>
                            <div class="nandresmon-form-group">
                                <label for="contact_message"><?php esc_html_e('Message', 'hungry-resource-monitor'); ?>
                                    <span class="required">*</span></label>
                                <textarea id="contact_message" name="contact_message" rows="5" required></textarea>
                            </div>
                            <button type="submit" class="button button-primary" style="width: 100%;">
                                <span class="dashicons dashicons-email-alt" style="margin-top: 3px;"></span>
                                <?php esc_html_e('Send Message', 'hungry-resource-monitor'); ?>
                            </button>
                            <div class="nandresmon-contact-status" style="margin-top: 10px;"></div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
