<?php
/**
 * Plugin Profiler Class
 *
 * @package WPResourceMonitor
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class NANDRESMON_Plugin_Profiler
 * Profiles individual plugins for memory usage
 */
class NANDRESMON_Plugin_Profiler
{

    /**
     * Get all active plugins with their memory estimates
     *
     * @return array Plugin data.
     */
    public static function get_active_plugins_info()
    {
        $active_plugins = get_option('active_plugins', array());
        $plugins_data = array();

        foreach ($active_plugins as $plugin_path) {
            $plugin_file = WP_PLUGIN_DIR . '/' . $plugin_path;
            $plugin_data = get_plugin_data($plugin_file, false, false);

            $plugins_data[] = array(
                'path' => $plugin_path,
                'name' => $plugin_data['Name'],
                'version' => $plugin_data['Version'],
                'author' => $plugin_data['Author'],
            );
        }

        return $plugins_data;
    }

    /**
     * Get all installed themes
     *
     * @return array Theme data.
     */
    public static function get_all_themes_info()
    {
        $themes = wp_get_themes();
        $active_theme = get_stylesheet();
        $themes_data = array();

        foreach ($themes as $slug => $theme) {
            $themes_data[] = array(
                'slug' => $slug,
                'name' => $theme->get('Name'),
                'version' => $theme->get('Version'),
                'is_active' => ($slug === $active_theme),
            );
        }

        return $themes_data;
    }

    /**
     * Get inactive plugins (for cleanup tab)
     *
     * @return array Inactive plugins.
     */
    public static function get_inactive_plugins()
    {
        $all_plugins = get_plugins();
        $active_plugins = get_option('active_plugins', array());
        $inactive = array();

        foreach ($all_plugins as $path => $data) {
            if (!in_array($path, $active_plugins, true)) {
                $inactive[] = array(
                    'path' => $path,
                    'name' => $data['Name'],
                    'version' => $data['Version'],
                );
            }
        }

        return $inactive;
    }

    /**
     * Get unused themes (for cleanup tab)
     *
     * @return array Unused themes.
     */
    public static function get_unused_themes()
    {
        $themes = wp_get_themes();
        $active_theme = get_stylesheet();
        $parent_theme = get_template();
        $unused = array();

        foreach ($themes as $slug => $theme) {
            // Skip active and parent themes
            if ($slug === $active_theme || $slug === $parent_theme) {
                continue;
            }

            $unused[] = array(
                'slug' => $slug,
                'name' => $theme->get('Name'),
                'version' => $theme->get('Version'),
            );
        }

        return $unused;
    }
}
