<?php
/**
 * Admin Page Class
 *
 * @package WPResourceMonitor
 */

if (!defined('ABSPATH')) {
    exit;
}

// Load tab render functions
require_once NANDRESMON_PLUGIN_DIR . 'includes/admin-tabs/tab-overview.php';
require_once NANDRESMON_PLUGIN_DIR . 'includes/admin-tabs/tab-memory.php';
require_once NANDRESMON_PLUGIN_DIR . 'includes/admin-tabs/tab-database.php';
require_once NANDRESMON_PLUGIN_DIR . 'includes/admin-tabs/tab-server-limits.php';
require_once NANDRESMON_PLUGIN_DIR . 'includes/admin-tabs/tab-cleanup.php';
require_once NANDRESMON_PLUGIN_DIR . 'includes/admin-tabs/tab-crons.php';
require_once NANDRESMON_PLUGIN_DIR . 'includes/admin-tabs/tab-settings.php';
require_once NANDRESMON_PLUGIN_DIR . 'includes/admin-ajax-handlers.php';

/**
 * Render main admin page
 */
function nandresmon_admin_page()
{
    // Handle settings save
    nandresmon_handle_settings_save();

    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for tab navigation only
    $current_tab = isset($_GET['tab']) ? sanitize_text_field(wp_unslash($_GET['tab'])) : 'dashboard';
    ?>
    <div class="wrap nandresmon-admin-wrap">
        <h1 class="nandresmon-main-title">
            <span class="dashicons dashicons-chart-area"></span>
            <?php esc_html_e('Hungry Resource Monitor', 'hungry-resource-monitor'); ?>
        </h1>

        <!-- Navigation Tabs -->
        <nav class="nav-tab-wrapper nandresmon-nav-tabs">
            <a href="?page=hungry-resource-monitor&tab=dashboard"
                class="nav-tab <?php echo esc_attr($current_tab === 'dashboard' ? 'nav-tab-active' : ''); ?>">
                <span class="dashicons dashicons-dashboard"></span>
                <?php esc_html_e('Dashboard', 'hungry-resource-monitor'); ?>
            </a>
            <a href="?page=hungry-resource-monitor&tab=memory"
                class="nav-tab <?php echo esc_attr($current_tab === 'memory' ? 'nav-tab-active' : ''); ?>">
                <span class="dashicons dashicons-performance"></span>
                <?php esc_html_e('Memory', 'hungry-resource-monitor'); ?>
            </a>
            <a href="?page=hungry-resource-monitor&tab=database"
                class="nav-tab <?php echo esc_attr($current_tab === 'database' ? 'nav-tab-active' : ''); ?>">
                <span class="dashicons dashicons-database"></span>
                <?php esc_html_e('Database', 'hungry-resource-monitor'); ?>
            </a>
            <a href="?page=hungry-resource-monitor&tab=limits"
                class="nav-tab <?php echo esc_attr($current_tab === 'limits' ? 'nav-tab-active' : ''); ?>">
                <span class="dashicons dashicons-admin-tools"></span>
                <?php esc_html_e('Server', 'hungry-resource-monitor'); ?>
            </a>
            <a href="?page=hungry-resource-monitor&tab=cleanup"
                class="nav-tab <?php echo esc_attr($current_tab === 'cleanup' ? 'nav-tab-active' : ''); ?>">
                <span class="dashicons dashicons-trash"></span>
                <?php esc_html_e('Cleanup', 'hungry-resource-monitor'); ?>
            </a>
            <a href="?page=hungry-resource-monitor&tab=crons"
                class="nav-tab <?php echo esc_attr($current_tab === 'crons' ? 'nav-tab-active' : ''); ?>">
                <span class="dashicons dashicons-clock"></span> <?php esc_html_e('Crons', 'hungry-resource-monitor'); ?>
            </a>
            <a href="?page=hungry-resource-monitor&tab=settings"
                class="nav-tab <?php echo esc_attr($current_tab === 'settings' ? 'nav-tab-active' : ''); ?>">
                <span class="dashicons dashicons-admin-generic"></span>
                <?php esc_html_e('Settings', 'hungry-resource-monitor'); ?>
            </a>
            <a href="?page=hungry-resource-monitor&tab=support"
                class="nav-tab <?php echo esc_attr($current_tab === 'support' ? 'nav-tab-active' : ''); ?>">
                <span class="dashicons dashicons-editor-help"></span>
                <?php esc_html_e('Support', 'hungry-resource-monitor'); ?>
            </a>
        </nav>

        <div class="nandresmon-tab-content">
            <?php
            switch ($current_tab) {
                case 'memory':
                    nandresmon_render_memory_tab();
                    break;
                case 'database':
                    nandresmon_render_database_tab();
                    break;
                case 'limits':
                    nandresmon_render_limits_tab();
                    break;
                case 'cleanup':
                    nandresmon_render_cleanup_tab();
                    break;
                case 'crons':
                    nandresmon_render_crons_tab();
                    break;
                case 'settings':
                    nandresmon_render_settings_tab();
                    break;
                case 'support':
                    NANDRESMON_Support_Page::render();
                    break;
                case 'dashboard':
                default:
                    nandresmon_render_overview_tab();
                    break;
            }
            ?>
        </div>
    </div>
    <?php
}

/**
 * Handle settings form save
 */
function nandresmon_handle_settings_save()
{
    if (!isset($_POST['nandresmon_settings_nonce'])) {
        return;
    }

    if (!wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['nandresmon_settings_nonce'])), 'nandresmon_settings_action')) {
        wp_die(esc_html__('Security check failed', 'hungry-resource-monitor'));
    }

    if (!current_user_can('manage_options')) {
        wp_die(esc_html__('Unauthorized access', 'hungry-resource-monitor'));
    }

    $options = array(
        'enable_monitoring' => isset($_POST['enable_monitoring']) ? 1 : 0,
        'enable_toolbar' => isset($_POST['enable_toolbar']) ? 1 : 0,
        'enable_email_reports' => isset($_POST['enable_email_reports']) ? 1 : 0,
        'email_frequency' => isset($_POST['email_frequency']) ? sanitize_text_field(wp_unslash($_POST['email_frequency'])) : 'weekly',
        'email_recipient' => isset($_POST['email_recipient']) ? sanitize_email(wp_unslash($_POST['email_recipient'])) : get_option('admin_email'),
        'data_retention_days' => isset($_POST['data_retention_days']) ? absint($_POST['data_retention_days']) : 30,
    );

    update_option(NANDRESMON_OPTIONS_KEY, $options);

    // Reschedule email events if needed
    wp_clear_scheduled_hook('nandresmon_send_report');
    if ($options['enable_email_reports']) {
        wp_schedule_event(time(), $options['email_frequency'], 'nandresmon_send_report');
    }

    add_settings_error('nandresmon_settings', 'settings_updated', __('Settings saved successfully.', 'hungry-resource-monitor'), 'success');
}
