<?php
/**
 * Settings Tab
 *
 * @package WPResourceMonitor
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Render settings tab
 */
function nandresmon_render_settings_tab()
{
    $options = get_option(NANDRESMON_OPTIONS_KEY);
    settings_errors('nandresmon_settings');
    ?>
    <div class="nandresmon-settings">
        <form method="post" action="">
            <?php wp_nonce_field('nandresmon_settings_action', 'nandresmon_settings_nonce'); ?>

            <div class="nandresmon-grid-2col">
                <!-- General Settings -->
                <div class="nandresmon-card">
                    <div class="nandresmon-card-header">
                        <h3><span class="dashicons dashicons-admin-generic"></span>
                            <?php esc_html_e('General Settings', 'hungry-resource-monitor'); ?></h3>
                    </div>
                    <div class="nandresmon-card-body">
                        <div class="nandresmon-setting-row">
                            <label>
                                <input type="checkbox" name="enable_monitoring" value="1" <?php checked(!empty($options['enable_monitoring'])); ?>>
                                <?php esc_html_e('Enable Resource Monitoring', 'hungry-resource-monitor'); ?>
                            </label>
                            <p class="description">
                                <?php esc_html_e('Track memory and query usage on each page load.', 'hungry-resource-monitor'); ?>
                            </p>
                        </div>
                        <div class="nandresmon-setting-row">
                            <label>
                                <input type="checkbox" name="enable_toolbar" value="1" <?php checked(!empty($options['enable_toolbar'])); ?>>
                                <?php esc_html_e('Show Toolbar Stats', 'hungry-resource-monitor'); ?>
                            </label>
                            <p class="description">
                                <?php esc_html_e('Display memory and query stats in the admin toolbar.', 'hungry-resource-monitor'); ?>
                            </p>
                        </div>
                        <div class="nandresmon-setting-row">
                            <label
                                for="data_retention_days"><?php esc_html_e('Data Retention (days)', 'hungry-resource-monitor'); ?></label>
                            <input type="number" id="data_retention_days" name="data_retention_days"
                                value="<?php echo esc_attr($options['data_retention_days'] ?? 30); ?>" min="1" max="365"
                                style="width: 80px;">
                            <p class="description">
                                <?php esc_html_e('How long to keep monitoring data.', 'hungry-resource-monitor'); ?>
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Email Settings -->
                <div class="nandresmon-card">
                    <div class="nandresmon-card-header">
                        <h3><span class="dashicons dashicons-email"></span>
                            <?php esc_html_e('Email Reports', 'hungry-resource-monitor'); ?></h3>
                    </div>
                    <div class="nandresmon-card-body">
                        <div class="nandresmon-setting-row">
                            <label>
                                <input type="checkbox" name="enable_email_reports" value="1" <?php checked(!empty($options['enable_email_reports'])); ?>>
                                <?php esc_html_e('Enable Email Reports', 'hungry-resource-monitor'); ?>
                            </label>
                        </div>
                        <div class="nandresmon-setting-row">
                            <label
                                for="email_frequency"><?php esc_html_e('Frequency', 'hungry-resource-monitor'); ?></label>
                            <select id="email_frequency" name="email_frequency">
                                <option value="daily" <?php selected($options['email_frequency'] ?? 'weekly', 'daily'); ?>>
                                    <?php esc_html_e('Daily', 'hungry-resource-monitor'); ?>
                                </option>
                                <option value="weekly" <?php selected($options['email_frequency'] ?? 'weekly', 'weekly'); ?>><?php esc_html_e('Weekly', 'hungry-resource-monitor'); ?></option>
                                <option value="monthly" <?php selected($options['email_frequency'] ?? 'weekly', 'monthly'); ?>><?php esc_html_e('Monthly', 'hungry-resource-monitor'); ?></option>
                            </select>
                        </div>
                        <div class="nandresmon-setting-row">
                            <label
                                for="email_recipient"><?php esc_html_e('Recipient Email', 'hungry-resource-monitor'); ?></label>
                            <input type="email" id="email_recipient" name="email_recipient"
                                value="<?php echo esc_attr($options['email_recipient'] ?? get_option('admin_email')); ?>"
                                class="regular-text">
                        </div>
                        <div class="nandresmon-setting-row">
                            <button type="button" id="nandresmon-test-email" class="button">
                                <span class="dashicons dashicons-email-alt" style="margin-top: 4px;"></span>
                                <?php esc_html_e('Send Test Email', 'hungry-resource-monitor'); ?>
                            </button>
                            <span id="nandresmon-test-email-status"></span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="nandresmon-submit-wrapper">
                <button type="submit" class="button button-primary button-hero">
                    <span class="dashicons dashicons-yes" style="margin-top: 5px;"></span>
                    <?php esc_html_e('Save Settings', 'hungry-resource-monitor'); ?>
                </button>
            </div>
        </form>
    </div>
    <?php
}
