<?php
/**
 * Server Limits Tab
 *
 * @package WPResourceMonitor
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Render server limits tab
 */
function nandresmon_render_limits_tab()
{
    $limits = NANDRESMON_Server_Limits::get_all_limits();
    ?>
    <div class="nandresmon-limits">
        <div class="nandresmon-grid-2col">
            <!-- PHP Limits -->
            <div class="nandresmon-card">
                <div class="nandresmon-card-header">
                    <h3><span class="dashicons dashicons-editor-code"></span>
                        <?php esc_html_e('PHP Configuration', 'hungry-resource-monitor'); ?></h3>
                </div>
                <div class="nandresmon-card-body">
                    <?php foreach ($limits['php'] as $item): ?>
                        <div class="nandresmon-limit-item">
                            <span class="nandresmon-limit-label"><?php echo esc_html($item['label']); ?></span>
                            <?php if ($item['type'] === 'progress' && isset($item['current'], $item['max'])): ?>
                                <?php
                                $percentage = ($item['current'] / $item['max']) * 100;
                                $status_class = nandresmon_get_status_class($percentage);
                                ?>
                                <div class="nandresmon-progress-wrap">
                                    <div class="nandresmon-progress-bar <?php echo esc_attr($status_class); ?>">
                                        <div class="nandresmon-progress-fill"
                                            style="width: <?php echo esc_attr(min($percentage, 100)); ?>%"></div>
                                    </div>
                                    <span
                                        class="nandresmon-limit-value"><?php echo esc_html(nandresmon_format_bytes($item['current']) . ' / ' . $item['value']); ?></span>
                                </div>
                            <?php else: ?>
                                <span class="nandresmon-limit-value"><?php echo esc_html($item['value']); ?></span>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <!-- WordPress Limits -->
            <div class="nandresmon-card">
                <div class="nandresmon-card-header">
                    <h3><span class="dashicons dashicons-wordpress"></span>
                        <?php esc_html_e('WordPress Configuration', 'hungry-resource-monitor'); ?></h3>
                </div>
                <div class="nandresmon-card-body">
                    <?php foreach ($limits['wordpress'] as $item): ?>
                        <div class="nandresmon-limit-item">
                            <span class="nandresmon-limit-label"><?php echo esc_html($item['label']); ?></span>
                            <?php if ($item['type'] === 'badge'): ?>
                                <span
                                    class="nandresmon-badge nandresmon-badge-<?php echo esc_attr($item['status']); ?>"><?php echo esc_html($item['value']); ?></span>
                            <?php else: ?>
                                <span class="nandresmon-limit-value"><?php echo esc_html($item['value']); ?></span>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <!-- Database Info -->
            <div class="nandresmon-card">
                <div class="nandresmon-card-header">
                    <h3><span class="dashicons dashicons-database"></span>
                        <?php esc_html_e('Database', 'hungry-resource-monitor'); ?></h3>
                </div>
                <div class="nandresmon-card-body">
                    <?php foreach ($limits['database'] as $item): ?>
                        <div class="nandresmon-limit-item">
                            <span class="nandresmon-limit-label"><?php echo esc_html($item['label']); ?></span>
                            <span class="nandresmon-limit-value"><?php echo esc_html($item['value']); ?></span>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <!-- Server Info -->
            <div class="nandresmon-card">
                <div class="nandresmon-card-header">
                    <h3><span class="dashicons dashicons-cloud"></span>
                        <?php esc_html_e('Server', 'hungry-resource-monitor'); ?></h3>
                </div>
                <div class="nandresmon-card-body">
                    <?php foreach ($limits['server'] as $item): ?>
                        <div class="nandresmon-limit-item">
                            <span class="nandresmon-limit-label"><?php echo esc_html($item['label']); ?></span>
                            <span class="nandresmon-limit-value"><?php echo esc_html($item['value']); ?></span>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
    <?php
}
