<?php
/**
 * Main Dashboard Tab (Overview)
 *
 * @package WPResourceMonitor
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Render main dashboard tab (overview)
 */
function nandresmon_render_overview_tab()
{
    $stats = NANDRESMON_Database_Handler::get_overall_stats(7);
    $bloat = NANDRESMON_Cleanup_Handler::get_bloat_stats();
    $orphaned_tables = NANDRESMON_Cleanup_Handler::get_orphaned_tables();
    $inactive_plugins = NANDRESMON_Plugin_Profiler::get_inactive_plugins();
    $unused_themes = NANDRESMON_Plugin_Profiler::get_unused_themes();

    // Count orphaned crons
    $crons = _get_cron_array();
    $orphaned_cron_count = 0;
    $total_cron_count = 0;
    $wp_core_crons = array('wp_scheduled_delete', 'wp_scheduled_auto_draft_delete', 'wp_update_plugins', 'wp_update_themes', 'wp_version_check', 'delete_expired_transients', 'wp_privacy_delete_old_export_files', 'wp_site_health_scheduled_check', 'recovery_mode_clean_expired_keys', 'wp_https_detection', 'wp_update_user_counts');
    if (!empty($crons)) {
        foreach ($crons as $timestamp => $cron_hooks) {
            foreach ($cron_hooks as $hook => $cron_data) {
                ++$total_cron_count;
                if (!has_action($hook) && !in_array($hook, $wp_core_crons, true)) {
                    ++$orphaned_cron_count;
                }
            }
        }
    }

    $total_bloat = array_sum($bloat);
    ?>
    <div class="nandresmon-overview">
        <!-- Tab Cards Grid -->
        <div class="nandresmon-grid-2col">

            <!-- Memory Card -->
            <div class="nandresmon-card nandresmon-overview-card">
                <div class="nandresmon-card-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                    <h3 style="color: white;"><span class="dashicons dashicons-performance" style="color: white;"></span>
                        <?php esc_html_e('Memory Usage', 'hungry-resource-monitor'); ?></h3>
                </div>
                <div class="nandresmon-card-body">
                    <p style="color: #64748b; margin-bottom: 20px;">
                        <?php esc_html_e('Track memory consumption, identify heavy pages, and monitor performance trends.', 'hungry-resource-monitor'); ?>
                    </p>
                    <div class="nandresmon-overview-stats">
                        <div class="nandresmon-overview-stat">
                            <span
                                class="nandresmon-overview-stat-value"><?php echo esc_html(nandresmon_format_bytes($stats->avg_memory_peak ?? 0)); ?></span>
                            <span
                                class="nandresmon-overview-stat-label"><?php esc_html_e('Avg Memory', 'hungry-resource-monitor'); ?></span>
                        </div>
                        <div class="nandresmon-overview-stat">
                            <span
                                class="nandresmon-overview-stat-value"><?php echo esc_html(nandresmon_format_bytes($stats->max_memory_peak ?? 0)); ?></span>
                            <span
                                class="nandresmon-overview-stat-label"><?php esc_html_e('Peak Memory', 'hungry-resource-monitor'); ?></span>
                        </div>
                        <div class="nandresmon-overview-stat">
                            <span
                                class="nandresmon-overview-stat-value"><?php echo esc_html($stats->total_samples ?? 0); ?></span>
                            <span
                                class="nandresmon-overview-stat-label"><?php esc_html_e('Samples (7d)', 'hungry-resource-monitor'); ?></span>
                        </div>
                    </div>
                    <a href="?page=hungry-resource-monitor&tab=memory" class="button button-primary"
                        style="width: 100%; text-align: center;">
                        <?php esc_html_e('View Memory Stats →', 'hungry-resource-monitor'); ?>
                    </a>
                </div>
            </div>

            <!-- Database Card -->
            <div class="nandresmon-card nandresmon-overview-card">
                <div class="nandresmon-card-header" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);">
                    <h3 style="color: white;"><span class="dashicons dashicons-database" style="color: white;"></span>
                        <?php esc_html_e('Database Cleanup', 'hungry-resource-monitor'); ?></h3>
                </div>
                <div class="nandresmon-card-body">
                    <p style="color: #64748b; margin-bottom: 20px;">
                        <?php esc_html_e('Remove bloat like revisions, transients, and orphaned data to keep your database lean.', 'hungry-resource-monitor'); ?>
                    </p>
                    <div class="nandresmon-overview-stats">
                        <div class="nandresmon-overview-stat">
                            <span class="nandresmon-overview-stat-value"
                                style="color: <?php echo $total_bloat > 100 ? '#ef4444' : '#10b981'; ?>;"><?php echo esc_html(number_format($total_bloat)); ?></span>
                            <span
                                class="nandresmon-overview-stat-label"><?php esc_html_e('Cleanup Items', 'hungry-resource-monitor'); ?></span>
                        </div>
                        <div class="nandresmon-overview-stat">
                            <span class="nandresmon-overview-stat-value"><?php echo esc_html($bloat['revisions']); ?></span>
                            <span
                                class="nandresmon-overview-stat-label"><?php esc_html_e('Revisions', 'hungry-resource-monitor'); ?></span>
                        </div>
                        <div class="nandresmon-overview-stat">
                            <span class="nandresmon-overview-stat-value"
                                style="color: <?php echo count($orphaned_tables) > 0 ? '#f59e0b' : '#10b981'; ?>;"><?php echo esc_html(count($orphaned_tables)); ?></span>
                            <span
                                class="nandresmon-overview-stat-label"><?php esc_html_e('Orphan Tables', 'hungry-resource-monitor'); ?></span>
                        </div>
                    </div>
                    <a href="?page=hungry-resource-monitor&tab=database" class="button button-primary"
                        style="width: 100%; text-align: center;">
                        <?php esc_html_e('Clean Database →', 'hungry-resource-monitor'); ?>
                    </a>
                </div>
            </div>

            <!-- Server Limits Card -->
            <div class="nandresmon-card nandresmon-overview-card">
                <div class="nandresmon-card-header" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%);">
                    <h3 style="color: white;"><span class="dashicons dashicons-admin-tools" style="color: white;"></span>
                        <?php esc_html_e('Server Limits', 'hungry-resource-monitor'); ?></h3>
                </div>
                <div class="nandresmon-card-body">
                    <p style="color: #64748b; margin-bottom: 20px;">
                        <?php esc_html_e('Check PHP, WordPress, and MySQL configuration limits for your server.', 'hungry-resource-monitor'); ?>
                    </p>
                    <div class="nandresmon-overview-stats">
                        <div class="nandresmon-overview-stat">
                            <span
                                class="nandresmon-overview-stat-value"><?php echo esc_html(ini_get('memory_limit')); ?></span>
                            <span
                                class="nandresmon-overview-stat-label"><?php esc_html_e('Memory Limit', 'hungry-resource-monitor'); ?></span>
                        </div>
                        <div class="nandresmon-overview-stat">
                            <span
                                class="nandresmon-overview-stat-value"><?php echo esc_html(ini_get('max_execution_time')); ?>s</span>
                            <span
                                class="nandresmon-overview-stat-label"><?php esc_html_e('Execution Time', 'hungry-resource-monitor'); ?></span>
                        </div>
                        <div class="nandresmon-overview-stat">
                            <span class="nandresmon-overview-stat-value"><?php echo esc_html(phpversion()); ?></span>
                            <span
                                class="nandresmon-overview-stat-label"><?php esc_html_e('PHP Version', 'hungry-resource-monitor'); ?></span>
                        </div>
                    </div>
                    <a href="?page=hungry-resource-monitor&tab=limits" class="button button-primary"
                        style="width: 100%; text-align: center;">
                        <?php esc_html_e('View Server Info →', 'hungry-resource-monitor'); ?>
                    </a>
                </div>
            </div>

            <!-- Crons Card -->
            <div class="nandresmon-card nandresmon-overview-card">
                <div class="nandresmon-card-header" style="background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%);">
                    <h3 style="color: white;"><span class="dashicons dashicons-clock" style="color: white;"></span>
                        <?php esc_html_e('Cron Jobs', 'hungry-resource-monitor'); ?></h3>
                </div>
                <div class="nandresmon-card-body">
                    <p style="color: #64748b; margin-bottom: 20px;">
                        <?php esc_html_e('Monitor scheduled tasks, detect orphaned crons from deleted plugins, and clean them.', 'hungry-resource-monitor'); ?>
                    </p>
                    <div class="nandresmon-overview-stats">
                        <div class="nandresmon-overview-stat">
                            <span class="nandresmon-overview-stat-value"><?php echo esc_html($total_cron_count); ?></span>
                            <span
                                class="nandresmon-overview-stat-label"><?php esc_html_e('Total Crons', 'hungry-resource-monitor'); ?></span>
                        </div>
                        <div class="nandresmon-overview-stat">
                            <span class="nandresmon-overview-stat-value"
                                style="color: <?php echo $orphaned_cron_count > 0 ? '#ef4444' : '#10b981'; ?>;"><?php echo esc_html($orphaned_cron_count); ?></span>
                            <span
                                class="nandresmon-overview-stat-label"><?php esc_html_e('Orphaned', 'hungry-resource-monitor'); ?></span>
                        </div>
                        <div class="nandresmon-overview-stat">
                            <span
                                class="nandresmon-overview-stat-value"><?php echo esc_html($total_cron_count - $orphaned_cron_count); ?></span>
                            <span
                                class="nandresmon-overview-stat-label"><?php esc_html_e('Active', 'hungry-resource-monitor'); ?></span>
                        </div>
                    </div>
                    <a href="?page=hungry-resource-monitor&tab=crons" class="button button-primary"
                        style="width: 100%; text-align: center;">
                        <?php esc_html_e('Manage Crons →', 'hungry-resource-monitor'); ?>
                    </a>
                </div>
            </div>

            <!-- Cleanup Card -->
            <div class="nandresmon-card nandresmon-overview-card">
                <div class="nandresmon-card-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);">
                    <h3 style="color: white;"><span class="dashicons dashicons-trash" style="color: white;"></span>
                        <?php esc_html_e('Themes & Plugins', 'hungry-resource-monitor'); ?></h3>
                </div>
                <div class="nandresmon-card-body">
                    <p style="color: #64748b; margin-bottom: 20px;">
                        <?php esc_html_e('Find inactive plugins and unused themes that may pose security risks.', 'hungry-resource-monitor'); ?>
                    </p>
                    <div class="nandresmon-overview-stats">
                        <div class="nandresmon-overview-stat">
                            <span class="nandresmon-overview-stat-value"
                                style="color: <?php echo count($inactive_plugins) > 0 ? '#f59e0b' : '#10b981'; ?>;"><?php echo esc_html(count($inactive_plugins)); ?></span>
                            <span
                                class="nandresmon-overview-stat-label"><?php esc_html_e('Inactive Plugins', 'hungry-resource-monitor'); ?></span>
                        </div>
                        <div class="nandresmon-overview-stat">
                            <span class="nandresmon-overview-stat-value"
                                style="color: <?php echo count($unused_themes) > 0 ? '#f59e0b' : '#10b981'; ?>;"><?php echo esc_html(count($unused_themes)); ?></span>
                            <span
                                class="nandresmon-overview-stat-label"><?php esc_html_e('Unused Themes', 'hungry-resource-monitor'); ?></span>
                        </div>
                        <div class="nandresmon-overview-stat">
                            <span
                                class="nandresmon-overview-stat-value"><?php echo esc_html(count($inactive_plugins) + count($unused_themes)); ?></span>
                            <span
                                class="nandresmon-overview-stat-label"><?php esc_html_e('Total Items', 'hungry-resource-monitor'); ?></span>
                        </div>
                    </div>
                    <a href="?page=hungry-resource-monitor&tab=cleanup" class="button button-primary"
                        style="width: 100%; text-align: center;">
                        <?php esc_html_e('Review Items →', 'hungry-resource-monitor'); ?>
                    </a>
                </div>
            </div>

            <!-- Settings Card -->
            <div class="nandresmon-card nandresmon-overview-card">
                <div class="nandresmon-card-header" style="background: linear-gradient(135deg, #64748b 0%, #475569 100%);">
                    <h3 style="color: white;"><span class="dashicons dashicons-admin-generic" style="color: white;"></span>
                        <?php esc_html_e('Settings', 'hungry-resource-monitor'); ?></h3>
                </div>
                <div class="nandresmon-card-body">
                    <p style="color: #64748b; margin-bottom: 20px;">
                        <?php esc_html_e('Configure monitoring, email reports, toolbar display, and data retention.', 'hungry-resource-monitor'); ?>
                    </p>
                    <div class="nandresmon-overview-stats">
                        <?php $options = get_option(NANDRESMON_OPTIONS_KEY, array()); ?>
                        <div class="nandresmon-overview-stat">
                            <span class="nandresmon-overview-stat-value"
                                style="color: <?php echo !empty($options['enable_monitoring']) ? '#10b981' : '#ef4444'; ?>;">
                                <?php echo !empty($options['enable_monitoring']) ? '✓' : '✗'; ?>
                            </span>
                            <span
                                class="nandresmon-overview-stat-label"><?php esc_html_e('Monitoring', 'hungry-resource-monitor'); ?></span>
                        </div>
                        <div class="nandresmon-overview-stat">
                            <span class="nandresmon-overview-stat-value"
                                style="color: <?php echo !empty($options['enable_toolbar']) ? '#10b981' : '#ef4444'; ?>;">
                                <?php echo !empty($options['enable_toolbar']) ? '✓' : '✗'; ?>
                            </span>
                            <span
                                class="nandresmon-overview-stat-label"><?php esc_html_e('Toolbar', 'hungry-resource-monitor'); ?></span>
                        </div>
                        <div class="nandresmon-overview-stat">
                            <span class="nandresmon-overview-stat-value"
                                style="color: <?php echo !empty($options['enable_email_reports']) ? '#10b981' : '#ef4444'; ?>;">
                                <?php echo !empty($options['enable_email_reports']) ? '✓' : '✗'; ?>
                            </span>
                            <span
                                class="nandresmon-overview-stat-label"><?php esc_html_e('Email Reports', 'hungry-resource-monitor'); ?></span>
                        </div>
                    </div>
                    <a href="?page=hungry-resource-monitor&tab=settings" class="button button-primary"
                        style="width: 100%; text-align: center;">
                        <?php esc_html_e('Configure Settings →', 'hungry-resource-monitor'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <?php
}
