<?php
/**
 * Memory Tab
 *
 * @package WPResourceMonitor
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Render memory tab
 */
function nandresmon_render_memory_tab()
{
    $stats = NANDRESMON_Database_Handler::get_overall_stats(7);
    $top_pages = NANDRESMON_Database_Handler::get_top_pages_by_url(10, 7);
    $memory_limit = nandresmon_parse_ini_size('memory_limit');
    ?>
    <div class="nandresmon-dashboard">
        <!-- Stats Cards -->
        <div class="nandresmon-stats-grid">
            <div class="nandresmon-stat-card nandresmon-stat-info">
                <div class="nandresmon-stat-icon">📊</div>
                <div class="nandresmon-stat-content">
                    <div class="nandresmon-stat-value">
                        <?php echo esc_html(nandresmon_format_bytes($stats->avg_memory_peak ?? 0)); ?>
                    </div>
                    <div class="nandresmon-stat-label">
                        <?php esc_html_e('Avg Memory', 'hungry-resource-monitor'); ?>
                    </div>
                </div>
            </div>
            <div class="nandresmon-stat-card nandresmon-stat-warning">
                <div class="nandresmon-stat-icon">🔥</div>
                <div class="nandresmon-stat-content">
                    <div class="nandresmon-stat-value">
                        <?php echo esc_html(nandresmon_format_bytes($stats->max_memory_peak ?? 0)); ?>
                    </div>
                    <div class="nandresmon-stat-label">
                        <?php esc_html_e('Peak Memory', 'hungry-resource-monitor'); ?>
                    </div>
                </div>
            </div>
            <div class="nandresmon-stat-card nandresmon-stat-success">
                <div class="nandresmon-stat-icon">⚡</div>
                <div class="nandresmon-stat-content">
                    <div class="nandresmon-stat-value">
                        <?php echo esc_html(round($stats->avg_query_count ?? 0)); ?>
                    </div>
                    <div class="nandresmon-stat-label">
                        <?php esc_html_e('Avg Queries', 'hungry-resource-monitor'); ?>
                    </div>
                </div>
            </div>
            <div class="nandresmon-stat-card nandresmon-stat-danger">
                <div class="nandresmon-stat-icon">📈</div>
                <div class="nandresmon-stat-content">
                    <div class="nandresmon-stat-value">
                        <?php echo esc_html($stats->total_samples ?? 0); ?>
                    </div>
                    <div class="nandresmon-stat-label">
                        <?php esc_html_e('Samples (7d)', 'hungry-resource-monitor'); ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="nandresmon-grid-2col">
            <!-- Top Pages by Memory -->
            <div class="nandresmon-card">
                <div class="nandresmon-card-header">
                    <h3><span class="dashicons dashicons-warning"></span>
                        <?php esc_html_e('Top Pages by Memory Usage', 'hungry-resource-monitor'); ?>
                    </h3>
                </div>
                <div class="nandresmon-card-body">
                    <?php if (empty($top_pages)): ?>
                        <p class="nandresmon-empty">
                            <?php esc_html_e('No data collected yet. Browse your site to start collecting.', 'hungry-resource-monitor'); ?>
                        </p>
                    <?php else: ?>
                        <table class="nandresmon-table">
                            <thead>
                                <tr>
                                    <th>
                                        <?php esc_html_e('Page URL', 'hungry-resource-monitor'); ?>
                                    </th>
                                    <th>
                                        <?php esc_html_e('Avg Memory', 'hungry-resource-monitor'); ?>
                                    </th>
                                    <th>
                                        <?php esc_html_e('Hits', 'hungry-resource-monitor'); ?>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($top_pages as $page):
                                    $url_path = wp_parse_url($page->page_url, PHP_URL_PATH);
                                    $display_url = $url_path ?: '/';
                                    ?>
                                    <tr>
                                        <td class="nandresmon-url-cell">
                                            <a href="<?php echo esc_url($page->page_url); ?>" target="_blank">
                                                <?php echo esc_html($display_url); ?>
                                            </a>
                                        </td>
                                        <td><strong>
                                                <?php echo esc_html(nandresmon_format_bytes($page->avg_memory)); ?>
                                            </strong>
                                        </td>
                                        <td>
                                            <?php echo esc_html($page->sample_count); ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Optimization Tips -->
            <div class="nandresmon-card">
                <div class="nandresmon-card-header">
                    <h3><span class="dashicons dashicons-chart-line"></span>
                        <?php esc_html_e('Memory Usage (Last 7 Days)', 'hungry-resource-monitor'); ?>
                    </h3>
                </div>
                <div class="nandresmon-card-body">
                    <canvas id="nandresmon-memory-chart" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>
    <?php
    // Prepare chart data for inline script
    $chart_data = NANDRESMON_Database_Handler::get_memory_chart_data(7);
    $labels = array();
    $memory_data = array();
    foreach ($chart_data as $row) {
        $labels[] = wp_date('M j', strtotime($row->date));
        $memory_data[] = round($row->avg_memory / 1024 / 1024, 2);
    }

    // Build the inline script for Chart.js initialization using concatenation
    $labels_json = wp_json_encode($labels);
    $data_json = wp_json_encode($memory_data);
    $label_text = esc_js(__('Avg Memory (MB)', 'hungry-resource-monitor'));

    $chart_script = 'document.addEventListener("DOMContentLoaded", function() {';
    $chart_script .= '    if (typeof Chart !== "undefined") {';
    $chart_script .= '        new Chart(document.getElementById("nandresmon-memory-chart"), {';
    $chart_script .= '            type: "line",';
    $chart_script .= '            data: {';
    $chart_script .= '                labels: ' . $labels_json . ',';
    $chart_script .= '                datasets: [{';
    $chart_script .= '                    label: "' . $label_text . '",';
    $chart_script .= '                    data: ' . $data_json . ',';
    $chart_script .= '                    borderColor: "#667eea",';
    $chart_script .= '                    backgroundColor: "rgba(102, 126, 234, 0.1)",';
    $chart_script .= '                    fill: true,';
    $chart_script .= '                    tension: 0.3';
    $chart_script .= '                }]';
    $chart_script .= '            },';
    $chart_script .= '            options: {';
    $chart_script .= '                responsive: true,';
    $chart_script .= '                plugins: { legend: { display: false } },';
    $chart_script .= '                scales: { y: { beginAtZero: true } }';
    $chart_script .= '            }';
    $chart_script .= '        });';
    $chart_script .= '    }';
    $chart_script .= '});';

    // Add the inline script after chartjs is loaded
    wp_add_inline_script('chartjs', $chart_script);
}

