<?php
/**
 * Database Tab
 *
 * @package WPResourceMonitor
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Render database tab
 */
function nandresmon_render_database_tab()
{
    $bloat = NANDRESMON_Cleanup_Handler::get_bloat_stats();
    $all_tables = NANDRESMON_Cleanup_Handler::get_all_tables_with_owners();
    $total_bloat = array_sum($bloat);

    // Separate tables by type
    $core_tables = array_filter($all_tables, function ($t) {
        return $t['owner_type'] === 'core';
    });
    $plugin_tables = array_filter($all_tables, function ($t) {
        return $t['owner_type'] === 'plugin';
    });
    $unknown_tables = array_filter($all_tables, function ($t) {
        return $t['owner_type'] === 'unknown';
    });
    ?>
    <div class="nandresmon-database">
        <!-- Summary Stats -->
        <div class="nandresmon-stats-grid" style="grid-template-columns: repeat(4, 1fr);">
            <div class="nandresmon-stat-card nandresmon-stat-info">
                <div class="nandresmon-stat-icon">🗄️</div>
                <div class="nandresmon-stat-content">
                    <div class="nandresmon-stat-value"><?php echo esc_html(count($all_tables)); ?></div>
                    <div class="nandresmon-stat-label"><?php esc_html_e('Total Tables', 'hungry-resource-monitor'); ?></div>
                </div>
            </div>
            <div class="nandresmon-stat-card nandresmon-stat-success">
                <div class="nandresmon-stat-icon">🔵</div>
                <div class="nandresmon-stat-content">
                    <div class="nandresmon-stat-value"><?php echo esc_html(count($core_tables)); ?></div>
                    <div class="nandresmon-stat-label"><?php esc_html_e('WordPress Core', 'hungry-resource-monitor'); ?>
                    </div>
                </div>
            </div>
            <div class="nandresmon-stat-card nandresmon-stat-warning">
                <div class="nandresmon-stat-icon">🔌</div>
                <div class="nandresmon-stat-content">
                    <div class="nandresmon-stat-value"><?php echo esc_html(count($plugin_tables)); ?></div>
                    <div class="nandresmon-stat-label"><?php esc_html_e('Plugin Tables', 'hungry-resource-monitor'); ?>
                    </div>
                </div>
            </div>
            <div class="nandresmon-stat-card nandresmon-stat-danger">
                <div class="nandresmon-stat-icon">❓</div>
                <div class="nandresmon-stat-content">
                    <div class="nandresmon-stat-value"><?php echo esc_html(count($unknown_tables)); ?></div>
                    <div class="nandresmon-stat-label"><?php esc_html_e('Unknown Owner', 'hungry-resource-monitor'); ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Database Bloat -->
        <div class="nandresmon-card">
            <div class="nandresmon-card-header">
                <h3><span class="dashicons dashicons-trash"></span>
                    <?php esc_html_e('Database Bloat', 'hungry-resource-monitor'); ?></h3>
            </div>
            <div class="nandresmon-card-body">
                <div class="nandresmon-cleanup-grid">
                    <?php
                    $cleanup_items = array(
                        'revisions' => array('label' => __('Post Revisions', 'hungry-resource-monitor'), 'icon' => '📝'),
                        'auto_drafts' => array('label' => __('Auto-Drafts', 'hungry-resource-monitor'), 'icon' => '📄'),
                        'trashed_posts' => array('label' => __('Trashed Posts', 'hungry-resource-monitor'), 'icon' => '🗑️'),
                        'spam_comments' => array('label' => __('Spam Comments', 'hungry-resource-monitor'), 'icon' => '🚫'),
                        'trashed_comments' => array('label' => __('Trashed Comments', 'hungry-resource-monitor'), 'icon' => '💬'),
                        'expired_transients' => array('label' => __('Expired Transients', 'hungry-resource-monitor'), 'icon' => '⏰'),
                        'orphaned_postmeta' => array('label' => __('Orphaned Postmeta', 'hungry-resource-monitor'), 'icon' => '🔗'),
                    );
                    foreach ($cleanup_items as $key => $item):
                        ?>
                        <div class="nandresmon-cleanup-item">
                            <div class="nandresmon-cleanup-info">
                                <span class="nandresmon-cleanup-icon"><?php echo esc_html($item['icon']); ?></span>
                                <span class="nandresmon-cleanup-label"><?php echo esc_html($item['label']); ?></span>
                                <span class="nandresmon-cleanup-count"><?php echo esc_html($bloat[$key]); ?></span>
                            </div>
                            <?php if ($bloat[$key] > 0): ?>
                                <button class="button nandresmon-cleanup-btn" data-action="<?php echo esc_attr($key); ?>">
                                    <?php esc_html_e('Clean', 'hungry-resource-monitor'); ?>
                                </button>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

        <!-- All Database Tables -->
        <div class="nandresmon-card">
            <div class="nandresmon-card-header">
                <h3><span class="dashicons dashicons-database"></span>
                    <?php esc_html_e('All Database Tables', 'hungry-resource-monitor'); ?></h3>
            </div>
            <div class="nandresmon-card-body">
                <table class="nandresmon-table">
                    <thead>
                        <tr>
                            <th><?php esc_html_e('Table Name', 'hungry-resource-monitor'); ?></th>
                            <th><?php esc_html_e('Owner', 'hungry-resource-monitor'); ?></th>
                            <th><?php esc_html_e('Rows', 'hungry-resource-monitor'); ?></th>
                            <th><?php esc_html_e('Size', 'hungry-resource-monitor'); ?></th>
                            <th><?php esc_html_e('Action', 'hungry-resource-monitor'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($all_tables as $table): ?>
                            <tr class="<?php echo $table['owner_type'] === 'unknown' ? 'nandresmon-row-danger' : ''; ?>">
                                <td><code><?php echo esc_html($table['name']); ?></code></td>
                                <td>
                                    <?php if ($table['owner_type'] === 'core'): ?>
                                        <span
                                            class="nandresmon-badge nandresmon-badge-info"><?php echo esc_html($table['owner']); ?></span>
                                    <?php elseif ($table['owner_type'] === 'plugin'): ?>
                                        <span
                                            class="nandresmon-badge <?php echo $table['is_active'] ? 'nandresmon-badge-success' : 'nandresmon-badge-warning'; ?>">
                                            <?php echo esc_html($table['owner']); ?>
                                            <?php if (!$table['is_active']): ?>
                                                <small>(inactive)</small>
                                            <?php endif; ?>
                                        </span>
                                    <?php else: ?>
                                        <span
                                            class="nandresmon-badge nandresmon-badge-danger"><?php esc_html_e('Unknown', 'hungry-resource-monitor'); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo esc_html(number_format($table['rows'])); ?></td>
                                <td><?php echo esc_html($table['size']); ?> KB</td>
                                <td>
                                    <?php if ($table['owner_type'] === 'unknown'): ?>
                                        <button class="button nandresmon-delete-table"
                                            data-table="<?php echo esc_attr($table['name']); ?>">
                                            <?php esc_html_e('Delete', 'hungry-resource-monitor'); ?>
                                        </button>
                                    <?php elseif ($table['owner_type'] === 'core'): ?>
                                        <span style="color: #64748b;">—</span>
                                    <?php else: ?>
                                        <span style="color: #64748b;">—</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php
}
