<?php
/**
 * Crons Tab
 *
 * @package WPResourceMonitor
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Render crons tab
 */
function nandresmon_render_crons_tab()
{
    $crons = _get_cron_array();
    $all_crons = array();
    $orphaned_crons = array();

    // Get list of known WordPress core cron hooks
    $wp_core_crons = array(
        'wp_scheduled_delete',
        'wp_scheduled_auto_draft_delete',
        'wp_update_plugins',
        'wp_update_themes',
        'wp_version_check',
        'delete_expired_transients',
        'wp_privacy_delete_old_export_files',
        'wp_site_health_scheduled_check',
        'recovery_mode_clean_expired_keys',
        'wp_https_detection',
        'wp_update_user_counts',
    );

    // Parse all crons
    if (!empty($crons)) {
        foreach ($crons as $timestamp => $cron_hooks) {
            foreach ($cron_hooks as $hook => $cron_data) {
                foreach ($cron_data as $hash => $data) {
                    $schedule = isset($data['schedule']) ? $data['schedule'] : 'single';

                    $is_core = in_array($hook, $wp_core_crons, true);
                    $has_callback = has_action($hook);

                    // Simple detection: no callback and not core = orphaned
                    $is_orphaned = !$has_callback && !$is_core;

                    $cron_info = array(
                        'hook' => $hook,
                        'timestamp' => $timestamp,
                        'schedule' => $schedule,
                        'next_run' => wp_date('Y-m-d H:i:s', $timestamp),
                        'is_orphaned' => $is_orphaned,
                        'is_core' => $is_core,
                        'args' => isset($data['args']) ? $data['args'] : array(),
                    );

                    $all_crons[] = $cron_info;

                    if ($is_orphaned) {
                        $orphaned_crons[] = $cron_info;
                    }
                }
            }
        }
    }

    // Sort by next run time
    usort($all_crons, function ($a, $b) {
        return $a['timestamp'] - $b['timestamp'];
    });
    ?>
    <div class="nandresmon-crons">
        <!-- Summary Cards -->
        <div class="nandresmon-stats-grid" style="grid-template-columns: repeat(3, 1fr);">
            <div class="nandresmon-stat-card nandresmon-stat-info">
                <div class="nandresmon-stat-icon">⏰</div>
                <div class="nandresmon-stat-content">
                    <div class="nandresmon-stat-value"><?php echo count($all_crons); ?></div>
                    <div class="nandresmon-stat-label"><?php esc_html_e('Total Crons', 'hungry-resource-monitor'); ?></div>
                </div>
            </div>
            <div class="nandresmon-stat-card nandresmon-stat-danger">
                <div class="nandresmon-stat-icon">⚠️</div>
                <div class="nandresmon-stat-content">
                    <div class="nandresmon-stat-value"><?php echo count($orphaned_crons); ?></div>
                    <div class="nandresmon-stat-label"><?php esc_html_e('Orphaned Crons', 'hungry-resource-monitor'); ?>
                    </div>
                </div>
            </div>
            <div class="nandresmon-stat-card nandresmon-stat-success">
                <div class="nandresmon-stat-icon">✅</div>
                <div class="nandresmon-stat-content">
                    <div class="nandresmon-stat-value"><?php echo count($all_crons) - count($orphaned_crons); ?></div>
                    <div class="nandresmon-stat-label"><?php esc_html_e('Active Crons', 'hungry-resource-monitor'); ?></div>
                </div>
            </div>
        </div>

        <?php if (!empty($orphaned_crons)): ?>
            <!-- Orphaned Crons -->
            <div class="nandresmon-card" style="border: 2px solid #ef4444;">
                <div class="nandresmon-card-header" style="background: #fee2e2;">
                    <h3><span class="dashicons dashicons-warning"></span>
                        <?php esc_html_e('Orphaned Crons (No Callback)', 'hungry-resource-monitor'); ?></h3>
                </div>
                <div class="nandresmon-card-body">
                    <p style="color: #991b1b; margin-bottom: 15px;">
                        <?php esc_html_e('These crons have no registered callback function. They may be from deleted plugins.', 'hungry-resource-monitor'); ?>
                    </p>
                    <table class="nandresmon-table">
                        <thead>
                            <tr>
                                <th><?php esc_html_e('Hook Name', 'hungry-resource-monitor'); ?></th>
                                <th><?php esc_html_e('Schedule', 'hungry-resource-monitor'); ?></th>
                                <th><?php esc_html_e('Next Run', 'hungry-resource-monitor'); ?></th>
                                <th><?php esc_html_e('Action', 'hungry-resource-monitor'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($orphaned_crons as $cron): ?>
                                <tr>
                                    <td><code><?php echo esc_html($cron['hook']); ?></code></td>
                                    <td><?php echo esc_html($cron['schedule']); ?></td>
                                    <td><?php echo esc_html($cron['next_run']); ?></td>
                                    <td>
                                        <button class="button nandresmon-delete-cron"
                                            data-hook="<?php echo esc_attr($cron['hook']); ?>"
                                            data-timestamp="<?php echo esc_attr($cron['timestamp']); ?>">
                                            <?php esc_html_e('Remove', 'hungry-resource-monitor'); ?>
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                    <div style="margin-top: 15px;">
                        <button class="button button-primary" id="nandresmon-clear-orphaned-crons">
                            <span class="dashicons dashicons-trash" style="margin-top: 4px;"></span>
                            <?php esc_html_e('Remove All Orphaned Crons', 'hungry-resource-monitor'); ?>
                        </button>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- All Crons -->
        <div class="nandresmon-card">
            <div class="nandresmon-card-header">
                <h3><span class="dashicons dashicons-clock"></span>
                    <?php esc_html_e('All Scheduled Crons', 'hungry-resource-monitor'); ?></h3>
            </div>
            <div class="nandresmon-card-body">
                <table class="nandresmon-table">
                    <thead>
                        <tr>
                            <th><?php esc_html_e('Hook Name', 'hungry-resource-monitor'); ?></th>
                            <th><?php esc_html_e('Schedule', 'hungry-resource-monitor'); ?></th>
                            <th><?php esc_html_e('Next Run', 'hungry-resource-monitor'); ?></th>
                            <th><?php esc_html_e('Status', 'hungry-resource-monitor'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($all_crons as $cron): ?>
                            <tr class="<?php echo $cron['is_orphaned'] ? 'nandresmon-row-danger' : ''; ?>">
                                <td><code><?php echo esc_html($cron['hook']); ?></code></td>
                                <td><?php echo esc_html($cron['schedule']); ?></td>
                                <td><?php echo esc_html($cron['next_run']); ?></td>
                                <td>
                                    <?php if ($cron['is_core']): ?>
                                        <span
                                            class="nandresmon-badge nandresmon-badge-info"><?php esc_html_e('Core', 'hungry-resource-monitor'); ?></span>
                                    <?php elseif ($cron['is_orphaned']): ?>
                                        <span
                                            class="nandresmon-badge nandresmon-badge-danger"><?php esc_html_e('Orphaned', 'hungry-resource-monitor'); ?></span>
                                    <?php else: ?>
                                        <span
                                            class="nandresmon-badge nandresmon-badge-success"><?php esc_html_e('Active', 'hungry-resource-monitor'); ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php
}
