<?php
/**
 * Cleanup Tab (Themes & Plugins)
 *
 * @package WPResourceMonitor
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Render cleanup tab (unused themes and plugins)
 */
function nandresmon_render_cleanup_tab()
{
    $unused_themes = NANDRESMON_Plugin_Profiler::get_unused_themes();
    $inactive_plugins = NANDRESMON_Plugin_Profiler::get_inactive_plugins();
    ?>
    <div class="nandresmon-cleanup">
        <!-- Summary Stats -->
        <div class="nandresmon-stats-grid" style="grid-template-columns: repeat(2, 1fr);">
            <div class="nandresmon-stat-card nandresmon-stat-warning">
                <div class="nandresmon-stat-icon">🎨</div>
                <div class="nandresmon-stat-content">
                    <div class="nandresmon-stat-value"><?php echo count($unused_themes); ?></div>
                    <div class="nandresmon-stat-label"><?php esc_html_e('Unused Themes', 'hungry-resource-monitor'); ?>
                    </div>
                </div>
            </div>
            <div class="nandresmon-stat-card nandresmon-stat-info">
                <div class="nandresmon-stat-icon">🔌</div>
                <div class="nandresmon-stat-content">
                    <div class="nandresmon-stat-value"><?php echo count($inactive_plugins); ?></div>
                    <div class="nandresmon-stat-label"><?php esc_html_e('Inactive Plugins', 'hungry-resource-monitor'); ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="nandresmon-grid-2col">
            <!-- Unused Themes -->
            <div class="nandresmon-card">
                <div class="nandresmon-card-header">
                    <h3><span class="dashicons dashicons-art"></span>
                        <?php esc_html_e('Unused Themes', 'hungry-resource-monitor'); ?></h3>
                </div>
                <div class="nandresmon-card-body">
                    <?php if (empty($unused_themes)): ?>
                        <div style="text-align: center; padding: 30px;">
                            <span style="font-size: 36px;">✅</span>
                            <p class="nandresmon-empty">
                                <?php esc_html_e('No unused themes found. Great job keeping things clean!', 'hungry-resource-monitor'); ?>
                            </p>
                        </div>
                    <?php else: ?>
                        <p style="color: #64748b; margin-bottom: 15px;">
                            <?php esc_html_e('These themes are installed but not active. Consider deleting unused themes to reduce security risks.', 'hungry-resource-monitor'); ?>
                        </p>
                        <?php foreach ($unused_themes as $theme): ?>
                            <div class="nandresmon-item-row">
                                <div>
                                    <strong><?php echo esc_html($theme['name']); ?></strong>
                                    <small style="color: #64748b;"> v<?php echo esc_html($theme['version']); ?></small>
                                </div>
                                <a class="button" href="<?php echo esc_url(admin_url('themes.php')); ?>">
                                    <?php esc_html_e('Manage Themes →', 'hungry-resource-monitor'); ?>
                                </a>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Inactive Plugins -->
            <div class="nandresmon-card">
                <div class="nandresmon-card-header">
                    <h3><span class="dashicons dashicons-admin-plugins"></span>
                        <?php esc_html_e('Inactive Plugins', 'hungry-resource-monitor'); ?></h3>
                </div>
                <div class="nandresmon-card-body">
                    <?php if (empty($inactive_plugins)): ?>
                        <div style="text-align: center; padding: 30px;">
                            <span style="font-size: 36px;">✅</span>
                            <p class="nandresmon-empty">
                                <?php esc_html_e('No inactive plugins found. Great job keeping things clean!', 'hungry-resource-monitor'); ?>
                            </p>
                        </div>
                    <?php else: ?>
                        <p style="color: #64748b; margin-bottom: 15px;">
                            <?php esc_html_e('These plugins are installed but not active. Consider deleting unused plugins to reduce security risks.', 'hungry-resource-monitor'); ?>
                        </p>
                        <?php foreach ($inactive_plugins as $plugin): ?>
                            <div class="nandresmon-item-row">
                                <div>
                                    <strong><?php echo esc_html($plugin['name']); ?></strong>
                                    <small style="color: #64748b;"> v<?php echo esc_html($plugin['version']); ?></small>
                                </div>
                                <a class="button" href="<?php echo esc_url(admin_url('plugins.php?plugin_status=inactive')); ?>">
                                    <?php esc_html_e('Manage Plugins →', 'hungry-resource-monitor'); ?>
                                </a>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Info Note -->
        <div class="nandresmon-card" style="background: #eff6ff; border: 1px solid #bfdbfe;">
            <div class="nandresmon-card-body" style="padding: 20px;">
                <p style="margin: 0; color: #1e40af;">
                    <span class="dashicons dashicons-info" style="margin-right: 5px;"></span>
                    <?php esc_html_e('Looking for database cleanup? Check the', 'hungry-resource-monitor'); ?>
                    <a href="?page=hungry-resource-monitor&tab=database"
                        style="font-weight: 600;"><?php esc_html_e('Database tab', 'hungry-resource-monitor'); ?></a>
                    <?php esc_html_e('for revisions, transients, and orphaned tables.', 'hungry-resource-monitor'); ?>
                </p>
            </div>
        </div>
    </div>
    <?php
}
