/**
 * Hungry Resource Monitor - Admin Dashboard JS
 */
(function ($) {
    'use strict';

    $(document).ready(function () {
        // Cleanup button handler
        $('.nandresmon-cleanup-btn').on('click', function (e) {
            e.preventDefault();

            if (!confirm(nandresmonAdmin.strings.confirm_cleanup)) {
                return;
            }

            var $btn = $(this);
            var action = $btn.data('action');

            $btn.prop('disabled', true).text(nandresmonAdmin.strings.processing);

            $.ajax({
                url: nandresmonAdmin.ajax_url,
                type: 'POST',
                data: {
                    action: 'nandresmon_cleanup_action',
                    nonce: nandresmonAdmin.nonce,
                    cleanup_action: action
                },
                success: function (response) {
                    if (response.success) {
                        $btn.closest('.nandresmon-cleanup-item').find('.nandresmon-cleanup-count').text('0');
                        $btn.remove();
                        alert(response.data.message);
                    } else {
                        alert(response.data.message || nandresmonAdmin.strings.error);
                    }
                },
                error: function () {
                    alert(nandresmonAdmin.strings.error);
                },
                complete: function () {
                    $btn.prop('disabled', false).text('Clean');
                }
            });
        });

        // Delete item (theme/plugin) handler
        $('.nandresmon-delete-btn').on('click', function (e) {
            e.preventDefault();

            if (!confirm(nandresmonAdmin.strings.confirm_delete)) {
                return;
            }

            var $btn = $(this);
            var type = $btn.data('type');
            var slug = $btn.data('slug');

            $btn.prop('disabled', true).text(nandresmonAdmin.strings.processing);

            $.ajax({
                url: nandresmonAdmin.ajax_url,
                type: 'POST',
                data: {
                    action: 'nandresmon_delete_item',
                    nonce: nandresmonAdmin.nonce,
                    item_type: type,
                    item_slug: slug
                },
                success: function (response) {
                    if (response.success) {
                        $btn.closest('.nandresmon-item-row').fadeOut(function () {
                            $(this).remove();
                        });
                    } else {
                        alert(response.data.message || nandresmonAdmin.strings.error);
                        $btn.prop('disabled', false).text('Delete');
                    }
                },
                error: function () {
                    alert(nandresmonAdmin.strings.error);
                    $btn.prop('disabled', false).text('Delete');
                }
            });
        });

        // Test email button
        $('#nandresmon-test-email').on('click', function (e) {
            e.preventDefault();

            var $btn = $(this);
            var $status = $('#nandresmon-test-email-status');

            $btn.prop('disabled', true);
            $status.text(nandresmonAdmin.strings.processing);

            $.ajax({
                url: nandresmonAdmin.ajax_url,
                type: 'POST',
                data: {
                    action: 'nandresmon_send_test_email',
                    nonce: nandresmonAdmin.nonce
                },
                success: function (response) {
                    $status.text(response.data.message)
                        .css('color', response.success ? '#10b981' : '#ef4444');
                },
                error: function () {
                    $status.text(nandresmonAdmin.strings.error).css('color', '#ef4444');
                },
                complete: function () {
                    $btn.prop('disabled', false);
                }
            });
        });

        // Contact form handler
        $('#nandresmon-contact-form').on('submit', function (e) {
            e.preventDefault();

            var $form = $(this);
            var $btn = $form.find('button[type="submit"]');
            var $status = $form.find('.nandresmon-contact-status');

            $btn.prop('disabled', true);
            $status.text(nandresmonAdmin.strings.processing);

            $.ajax({
                url: nandresmonAdmin.ajax_url,
                type: 'POST',
                data: $form.serialize() + '&action=nandresmon_send_contact',
                success: function (response) {
                    $status.text(response.data.message)
                        .css('color', response.success ? '#10b981' : '#ef4444');
                    if (response.success) {
                        $form[0].reset();
                    }
                },
                error: function () {
                    $status.text(nandresmonAdmin.strings.error).css('color', '#ef4444');
                },
                complete: function () {
                    $btn.prop('disabled', false);
                }
            });
        });

        // Delete single cron handler
        $('.nandresmon-delete-cron').on('click', function (e) {
            e.preventDefault();

            if (!confirm(nandresmonAdmin.strings.confirm_delete)) {
                return;
            }

            var $btn = $(this);
            var hook = $btn.data('hook');
            var timestamp = $btn.data('timestamp');

            $btn.prop('disabled', true).text(nandresmonAdmin.strings.processing);

            $.ajax({
                url: nandresmonAdmin.ajax_url,
                type: 'POST',
                data: {
                    action: 'nandresmon_delete_cron',
                    nonce: nandresmonAdmin.nonce,
                    hook: hook,
                    timestamp: timestamp
                },
                success: function (response) {
                    if (response.success) {
                        $btn.closest('tr').fadeOut(function () {
                            $(this).remove();
                        });
                    } else {
                        alert(response.data.message || nandresmonAdmin.strings.error);
                        $btn.prop('disabled', false).text('Remove');
                    }
                },
                error: function () {
                    alert(nandresmonAdmin.strings.error);
                    $btn.prop('disabled', false).text('Remove');
                }
            });
        });

        // Clear all orphaned crons handler
        $('#nandresmon-clear-orphaned-crons').on('click', function (e) {
            e.preventDefault();

            if (!confirm(nandresmonAdmin.strings.confirm_cleanup)) {
                return;
            }

            var $btn = $(this);
            $btn.prop('disabled', true).text(nandresmonAdmin.strings.processing);

            $.ajax({
                url: nandresmonAdmin.ajax_url,
                type: 'POST',
                data: {
                    action: 'nandresmon_clear_orphaned_crons',
                    nonce: nandresmonAdmin.nonce
                },
                success: function (response) {
                    if (response.success) {
                        alert(response.data.message);
                        location.reload();
                    } else {
                        alert(response.data.message || nandresmonAdmin.strings.error);
                    }
                },
                error: function () {
                    alert(nandresmonAdmin.strings.error);
                },
                complete: function () {
                    $btn.prop('disabled', false).text('Remove All Orphaned Crons');
                }
            });
        });

        // Delete table handler
        $('.nandresmon-delete-table').on('click', function (e) {
            e.preventDefault();

            if (!confirm(nandresmonAdmin.strings.confirm_delete)) {
                return;
            }

            var $btn = $(this);
            var tableName = $btn.data('table');

            $btn.prop('disabled', true).text(nandresmonAdmin.strings.processing);

            $.ajax({
                url: nandresmonAdmin.ajax_url,
                type: 'POST',
                data: {
                    action: 'nandresmon_delete_table',
                    nonce: nandresmonAdmin.nonce,
                    table_name: tableName
                },
                success: function (response) {
                    if (response.success) {
                        $btn.closest('tr').fadeOut(function () {
                            $(this).remove();
                        });
                    } else {
                        alert(response.data.message || nandresmonAdmin.strings.error);
                        $btn.prop('disabled', false).text('Delete');
                    }
                },
                error: function () {
                    alert(nandresmonAdmin.strings.error);
                    $btn.prop('disabled', false).text('Delete');
                }
            });
        });
    });

})(jQuery);
