<?php

namespace HugeAddons\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Typography;


if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

class HugeFlipBoxWidget extends Widget_Base {

    public function get_name(): string {
        return 'thha-huge-flip-box';
    }

    public function get_title(): string {
        return esc_html__( 'Huge Flip Box ', 'huge-addons-for-elementor' );
    }

    public function get_icon(): string {
        return 'thha-icon hugeicon-flip-box';
    }

    public function get_categories(): array {
        return [ 'thha-addons-category' ];
    }

    public function get_style_depends() {
        $widget_name = strtolower( str_replace( '_', '-', $this->get_name() ) );
        $css_file_path = THHA_PLUGIN_PATH . "public/css/{$widget_name}.min.css";
        if ( file_exists( $css_file_path ) ) {
            wp_register_style( $widget_name, THHA_URL . "public/css/{$widget_name}.min.css", [], THHA_VERSION );
            return [ $widget_name ];
        }
        return [];
    }

    public function get_script_depends() {
        $widget_name = strtolower( str_replace( '_', '-', $this->get_name() ) );
        $js_file_path = THHA_PLUGIN_PATH . "public/js/{$widget_name}.min.js";

        if ( file_exists( $js_file_path ) ) {
            wp_register_script( $widget_name, THHA_URL . "public/js/{$widget_name}.min.js", ['jquery'], THHA_VERSION, true );
            return [ $widget_name ];
        }
        return [];
    }

    protected function register_controls() {
        // Content Section - Template Selection
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'huge-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'selected_template',
            [
                'label' => __('Select Template', 'huge-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'template1',
                'options' => [
                    'template1' => __('Template 1 - SVG Flip Box', 'huge-addons-for-elementor'),
                    'template2' => __('Template 2 - Hover Zoom Flip Box', 'huge-addons-for-elementor'),
                    'template3' => __('Template 3 - Demo Flip Box Layouts', 'huge-addons-for-elementor'),
                    'template4' => __('Template 4 - Social Media Flip Box', 'huge-addons-for-elementor'),
                    'template5' => __('Template 5 - Explore Card Hover Flip Box', 'huge-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'huge-addons-for-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Flip Box Title', 'huge-addons-for-elementor'),
                'placeholder' => __('Enter your title', 'huge-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label' => __('Subtitle', 'huge-addons-for-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Template 01', 'huge-addons-for-elementor'),
                'placeholder' => __('Enter your subtitle', 'huge-addons-for-elementor'),
            ]
        );

        $this->end_controls_section();

        // Template 1 Controls
        $this->start_controls_section(
            'template1_section',
            [
                'label' => __('Template 1 Items', 'huge-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => ['selected_template' => 'template1'],
            ]
        );

        $repeater1 = new \Elementor\Repeater();
        $repeater1->add_control('front_icon', ['label' => __('Front Icon', 'huge-addons-for-elementor'), 'type' => Controls_Manager::MEDIA, 'default' => ['url' => \Elementor\Utils::get_placeholder_image_src()]]);
        $repeater1->add_control('front_title', ['label' => __('Front Title', 'huge-addons-for-elementor'), 'type' => Controls_Manager::TEXT, 'default' => __('Web Design', 'huge-addons-for-elementor')]);
        $repeater1->add_control('back_content', ['label' => __('Back Content', 'huge-addons-for-elementor'), 'type' => Controls_Manager::TEXTAREA, 'default' => __('We design visually stunning and responsive websites...', 'huge-addons-for-elementor')]);
        $repeater1->add_control('button_text', ['label' => __('Button Text', 'huge-addons-for-elementor'), 'type' => Controls_Manager::TEXT, 'default' => __('Learn More', 'huge-addons-for-elementor')]);
        $this->add_control('template1_items', ['label' => __('Flip Box Items', 'huge-addons-for-elementor'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater1->get_controls(), 'default' => [['front_title' => __('Web Design', 'huge-addons-for-elementor'), 'back_content' => __('We design visually stunning...', 'huge-addons-for-elementor'), 'button_text' => __('Learn More', 'huge-addons-for-elementor')], ['front_title' => __('SEO Services', 'huge-addons-for-elementor'), 'back_content' => __('Boost your online presence...', 'huge-addons-for-elementor'), 'button_text' => __('Learn More', 'huge-addons-for-elementor')]], 'title_field' => '{{{ front_title }}}', 'condition' => ['selected_template' => 'template1']]);

        $this->end_controls_section();

        // Template 2 Controls
        $this->start_controls_section(
            'template2_section',
            [
                'label' => __('Template 2 Items', 'huge-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => ['selected_template' => 'template2'],
            ]
        );

        $repeater2 = new \Elementor\Repeater();
        $repeater2->add_control('front_image', ['label' => __('Front Image', 'huge-addons-for-elementor'), 'type' => Controls_Manager::MEDIA, 'default' => ['url' => \Elementor\Utils::get_placeholder_image_src()]]);
        $repeater2->add_control('name', ['label' => __('Name', 'huge-addons-for-elementor'), 'type' => Controls_Manager::TEXT, 'default' => __('John Doe', 'huge-addons-for-elementor')]);
        $repeater2->add_control('description', ['label' => __('Description', 'huge-addons-for-elementor'), 'type' => Controls_Manager::TEXTAREA, 'default' => __('Lorem Ipsum...', 'huge-addons-for-elementor')]);
        $repeater2->add_control('button_text', ['label' => __('Button Text', 'huge-addons-for-elementor'), 'type' => Controls_Manager::TEXT, 'default' => __('Learn More', 'huge-addons-for-elementor')]);
        $this->add_control('template2_items', ['label' => __('Flip Box Items', 'huge-addons-for-elementor'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater2->get_controls(), 'default' => [['name' => __('John Doe', 'huge-addons-for-elementor'), 'description' => __('Lorem Ipsum...', 'huge-addons-for-elementor'), 'button_text' => __('Learn More', 'huge-addons-for-elementor')]], 'title_field' => '{{{ name }}}', 'condition' => ['selected_template' => 'template2']]);

        $this->end_controls_section();

        // Template 3 Controls
        $this->start_controls_section(
            'template3_section',
            [
                'label' => __('Template 3 Items', 'huge-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => ['selected_template' => 'template3'],
            ]
        );

        // Define features repeater
        $features_repeater = new \Elementor\Repeater();
        $features_repeater->add_control('feature', [
            'label' => __('Feature', 'huge-addons-for-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => __('1 User', 'huge-addons-for-elementor'),
        ]);

        // Define main pricing plan repeater
        $repeater3 = new \Elementor\Repeater();
        $repeater3->add_control('plan_name', [
            'label' => __('Plan Name', 'huge-addons-for-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => __('Basic Plan', 'huge-addons-for-elementor'),
        ]);
        $repeater3->add_control('price', [
            'label' => __('Price', 'huge-addons-for-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => __('$99/month', 'huge-addons-for-elementor'),
        ]);
        $repeater3->add_control('features', [
            'label' => __('Features', 'huge-addons-for-elementor'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $features_repeater->get_controls(),
            'default' => [
                ['feature' => __('1 User', 'huge-addons-for-elementor')],
                ['feature' => __('10 Widgets', 'huge-addons-for-elementor')],
            ],
            'title_field' => '{{{ feature }}}',
        ]);
        $repeater3->add_control('back_content', [
            'label' => __('Back Content', 'huge-addons-for-elementor'),
            'type' => Controls_Manager::TEXTAREA,
            'default' => __('Additional details...', 'huge-addons-for-elementor'),
        ]);
        $repeater3->add_control('button_text', [
            'label' => __('Button Text', 'huge-addons-for-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => __('Learn More', 'huge-addons-for-elementor'),
        ]);

        $this->add_control('template3_items', [
            'label' => __('Pricing Plans', 'huge-addons-for-elementor'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater3->get_controls(),
            'default' => [
                [
                    'plan_name' => __('Basic Plan', 'huge-addons-for-elementor'),
                    'price' => __('$99/month', 'huge-addons-for-elementor'),
                    'features' => [
                        ['feature' => __('1 User', 'huge-addons-for-elementor')],
                        ['feature' => __('10 Widgets', 'huge-addons-for-elementor')],
                    ],
                    'back_content' => __('Additional details...', 'huge-addons-for-elementor'),
                    'button_text' => __('Learn More', 'huge-addons-for-elementor'),
                ]
            ],
            'title_field' => '{{{ plan_name }}}',
            'condition' => ['selected_template' => 'template3'],
        ]);
        $this->add_control('show_pricing_toggle', [
            'label' => __('Show Pricing Toggle', 'huge-addons-for-elementor'),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'yes',
        ]);

        $this->end_controls_section();

        // Template 4 Controls
        $this->start_controls_section(
            'template4_section',
            [
                'label' => __('Template 4 Items', 'huge-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => ['selected_template' => 'template4'],
            ]
        );

        $repeater4 = new \Elementor\Repeater();
        $repeater4->add_control('social_network', ['label' => __('Social Network', 'huge-addons-for-elementor'), 'type' => Controls_Manager::SELECT, 'default' => 'fb', 'options' => ['fb' => __('Facebook', 'huge-addons-for-elementor'), 'tw' => __('Twitter', 'huge-addons-for-elementor'), 'lnd' => __('LinkedIn', 'huge-addons-for-elementor'), 'wh' => __('WhatsApp', 'huge-addons-for-elementor'), 'yt' => __('YouTube', 'huge-addons-for-elementor')]]);
        $repeater4->add_control('icon', ['label' => __('Icon', 'huge-addons-for-elementor'), 'type' => Controls_Manager::ICONS, 'default' => ['value' => 'fab fa-facebook', 'library' => 'fa-brands']]);
        $repeater4->add_control('network_name', ['label' => __('Network Name', 'huge-addons-for-elementor'), 'type' => Controls_Manager::TEXT, 'default' => __('Facebook', 'huge-addons-for-elementor')]);
        $this->add_control('template4_items', ['label' => __('Social Media Cards', 'huge-addons-for-elementor'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater4->get_controls(), 'default' => [['social_network' => 'fb', 'network_name' => __('Facebook', 'huge-addons-for-elementor')], ['social_network' => 'tw', 'network_name' => __('Twitter', 'huge-addons-for-elementor')]], 'title_field' => '{{{ network_name }}}', 'condition' => ['selected_template' => 'template4']]);

        $this->end_controls_section();

        // Template 5 Controls
        $this->start_controls_section(
            'template5_section',
            [
                'label' => __('Template 5 Items', 'huge-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => ['selected_template' => 'template5'],
            ]
        );

        $repeater5 = new \Elementor\Repeater();
        $repeater5->add_control('image', ['label' => __('Image', 'huge-addons-for-elementor'), 'type' => Controls_Manager::MEDIA, 'default' => ['url' => \Elementor\Utils::get_placeholder_image_src()]]);
        $repeater5->add_control('description', ['label' => __('Description', 'huge-addons-for-elementor'), 'type' => Controls_Manager::TEXTAREA, 'default' => __('Explore this beautiful location...', 'huge-addons-for-elementor')]);
        $repeater5->add_control('button_text', ['label' => __('Button Text', 'huge-addons-for-elementor'), 'type' => Controls_Manager::TEXT, 'default' => __('Learn More', 'huge-addons-for-elementor')]);
        $this->add_control('template5_items', ['label' => __('Explore Cards', 'huge-addons-for-elementor'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater5->get_controls(), 'default' => [['description' => __('Explore this beautiful location...', 'huge-addons-for-elementor'), 'button_text' => __('Learn More', 'huge-addons-for-elementor')]], 'title_field' => '{{{ description }}}', 'condition' => ['selected_template' => 'template5']]);

        $this->end_controls_section();

        // Style Tab - Header
        $this->start_controls_section(
            'header_style_section',
            [
                'label' => __('Header', 'huge-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('header_subtitle_color', ['label' => __('Subtitle Color', 'huge-addons-for-elementor'), 'type' => Controls_Manager::COLOR, 'selectors' => ['{{WRAPPER}} .huge-flip-box-widget-container .header span' => 'color: {{VALUE}}']]);
        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), ['name' => 'header_subtitle_typography', 'selector' => '{{WRAPPER}} .huge-flip-box-widget-container .header span']);
        $this->add_control('header_title_color', ['label' => __('Title Color', 'huge-addons-for-elementor'), 'type' => Controls_Manager::COLOR, 'selectors' => ['{{WRAPPER}} .huge-flip-box-widget-container .header h2' => 'color: {{VALUE}}']]);
        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), ['name' => 'header_title_typography', 'selector' => '{{WRAPPER}} .huge-flip-box-widget-container .header h2']);

        $this->end_controls_section();

        // Style Tab - Card Styles
        $this->start_controls_section(
            'card_style_section',
            [
                'label' => __('Card Styles', 'huge-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('card_background_color', ['label' => __('Card Background Color', 'huge-addons-for-elementor'), 'type' => Controls_Manager::COLOR, 'default' => '#fff', 'selectors' => [
            '{{WRAPPER}} .flip-box' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .mainFlipCard' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .pricing-card' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .social-card' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .explore-card' => 'background-color: {{VALUE}}'
        ]]);
        $this->add_control('card_border_radius', ['label' => __('Border Radius', 'huge-addons-for-elementor'), 'type' => Controls_Manager::SLIDER, 'range' => ['px' => [0, 20]], 'default' => ['size' => 10], 'selectors' => [
            '{{WRAPPER}} .flip-box' => 'border-radius: {{SIZE}}px',
            '{{WRAPPER}} .mainFlipCard' => 'border-radius: {{SIZE}}px',
            '{{WRAPPER}} .pricing-card' => 'border-radius: {{SIZE}}px',
            '{{WRAPPER}} .social-card' => 'border-radius: {{SIZE}}px',
            '{{WRAPPER}} .explore-card' => 'border-radius: {{SIZE}}px'
        ]]);
        $this->add_control('card_shadow', ['label' => __('Box Shadow', 'huge-addons-for-elementor'), 'type' => Controls_Manager::SLIDER, 'range' => ['px' => [0, 10]], 'default' => ['size' => 4], 'selectors' => [
            '{{WRAPPER}} .flip-box' => 'box-shadow: 0 {{SIZE}}px {{SIZE * 2}}px rgba(0,0,0,0.1)',
            '{{WRAPPER}} .mainFlipCard' => 'box-shadow: 0 {{SIZE}}px {{SIZE * 2}}px rgba(0,0,0,0.1)',
            '{{WRAPPER}} .pricing-card' => 'box-shadow: 0 {{SIZE}}px {{SIZE * 2}}px rgba(0,0,0,0.1)',
            '{{WRAPPER}} .social-card' => 'box-shadow: 0 {{SIZE}}px {{SIZE * 2}}px rgba(0,0,0,0.1)',
            '{{WRAPPER}} .explore-card' => 'box-shadow: 0 {{SIZE}}px {{SIZE * 2}}px rgba(0,0,0,0.1)'
        ]]);
        $this->add_control('card_height', ['label' => __('Card Height', 'huge-addons-for-elementor'), 'type' => Controls_Manager::SLIDER, 'range' => ['px' => [200, 500]], 'default' => ['size' => 250], 'selectors' => [
            '{{WRAPPER}} .flip-box' => 'height: {{SIZE}}px',
            '{{WRAPPER}} .mainFlipCard' => 'height: {{SIZE}}px',
            '{{WRAPPER}} .social-card' => 'height: {{SIZE}}px',
            '{{WRAPPER}} .pricing-card' => 'height: {{SIZE * 1.6}}px',
            '{{WRAPPER}} .explore-card' => 'height: {{SIZE * 1.6}}px'
        ]]);

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $template = $settings['selected_template'];
        if( empty( $template ) ) {
            $template = 'template1';
        }
        ?>
        
        <section class="huge-flip-box-widget elementor-section elementor-section-boxed">
            <div class="huge-flip-box-widget-container elementor-container">
                <div class="header elementor-column elementor-col-100">
                    <span><?php echo esc_html( $settings['subtitle'] ); ?></span>
                    <h2><?php echo esc_html( $settings['title'] ); ?></h2>
                </div>
            </div>
            
            <?php switch ( $template ):
                case 'template1': // SVG Flip Box
                    ?>
                    <div class="elementor-container elementor-template1-grid" data-flipcard="mh_flipCard_1">
                        <?php foreach ( $settings['template1_items'] as $index => $item ): ?>
                        <div class="elementor-column elementor-col-50 elementor-md-50 elementor-lg-50 elementor-xl-50">
                            <div class="flip-box flp-box-<?php echo esc_attr( $index + 1 ); ?>" role="button" aria-label="Flip card <?php echo esc_attr( $item['front_title'] ); ?>">
                                <div class="flip-box-front">
                                    <div class="inner">
                                        <div class="front_part">
                                            <?php if ( ! empty( $item['front_icon']['url'] ) ): ?>
                                            <img src="<?php echo esc_url( $item['front_icon']['url'] ); ?>" alt="<?php echo esc_attr( $item['front_title'] ); ?>" class="svg_icon">
                                            <?php endif; ?>
                                            <h3><?php echo esc_html( $item['front_title'] ); ?></h3>
                                        </div>
                                    </div>
                                </div>
                                <div class="flip-box-back">
                                    <div class="inner">
                                        <div class="back_part">
                                            <p><?php echo esc_html( $item['back_content'] ); ?></p>
                                            <?php if ( ! empty( $item['button_text'] ) ): ?>
                                            <button><?php echo esc_html( $item['button_text'] ); ?></button>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <?php
                    break;
                
                case 'template2': // Hover Zoom Flip Box
                    ?>
                    <div class="elementor-container elementor-template2-grid" data-flipcard="mh_flipCard_2">
                        <?php foreach ( $settings['template2_items'] as $index => $item ): ?>
                        <div class="elementor-column elementor-col-50 elementor-md-50 elementor-lg-50 elementor-xl-50">
                            <div class="mainFlipCard" role="button" aria-label="Flip card <?php echo esc_attr( $item['name'] ); ?>">
                                <div class="flipCard_Front">
                                    <?php if ( ! empty( $item['front_image']['url'] ) ): ?>
                                    <img src="<?php echo esc_url( $item['front_image']['url'] ); ?>" class="card-image" alt="<?php echo esc_attr( $item['name'] ); ?>">
                                    <?php endif; ?>
                                    <div class="card-content">
                                        <h3><?php echo esc_html( $item['name'] ); ?></h3>
                                    </div>
                                </div>
                                <div class="flipCard_Back">
                                    <p><?php echo esc_html( $item['description'] ); ?></p>
                                    <?php if ( ! empty( $item['button_text'] ) ): ?>
                                    <button><?php echo esc_html( $item['button_text'] ); ?></button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <?php
                    break;
                
                case 'template3': // Demo Flip Box Layouts (Pricing)
                    ?>
                    <div class="elementor-container elementor-template3-grid" data-flipcard="mh_flipCard_3">
                        <?php foreach ( $settings['template3_items'] as $index => $item ): ?>
                        <div class="elementor-column elementor-col-33 elementor-md-33 elementor-lg-33 elementor-xl-33">
                            <div class="pricing-card" role="button" aria-label="Pricing card <?php echo esc_attr( $item['plan_name'] ); ?>">
                                <div class="pricing-front">
                                    <h3><?php echo esc_html( $item['plan_name'] ); ?></h3>
                                    <p class="price"><?php echo esc_html( $item['price'] ); ?></p>
                                    <ul>
                                        <?php if (!empty($item['features']) && is_array($item['features'])): ?>
                                            <?php foreach ($item['features'] as $feature): ?>
                                                <li><?php echo esc_html( $feature['feature'] ); ?></li>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                                <div class="pricing-back">
                                    <p><?php echo esc_html( $item['back_content'] ); ?></p>
                                    <?php if ( ! empty( $item['button_text'] ) ): ?>
                                    <button><?php echo esc_html( $item['button_text'] ); ?></button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <?php
                    break;
                
                case 'template4': // Social Media Flip Box
                    ?>
                    <div class="elementor-container elementor-template4-grid" data-flipcard="mh_flipCard_4">
                        <?php foreach ( $settings['template4_items'] as $item ): ?>
                        <div class="elementor-column elementor-col-50 elementor-md-50 elementor-lg-50 elementor-xl-50">
                            <div class="social-card <?php echo esc_attr( $item['social_network'] ); ?>" role="button" aria-label="Social card <?php echo esc_attr( $item['network_name'] ); ?>">
                                <div class="social-front">
                                    <i class="<?php echo esc_attr( $item['icon']['value'] ); ?>" aria-hidden="true"></i>
                                </div>
                                <div class="social-back">
                                    <span><?php echo esc_html( $item['network_name'] ); ?></span>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <?php
                    break;
                
                case 'template5': // Explore Card Hover Flip Box
                    ?>
                    <div class="elementor-container elementor-template5-grid" data-flipcard="mh_flipCard_5">
                        <?php foreach ( $settings['template5_items'] as $index => $item ): ?>
                        <div class="elementor-column elementor-col-50 elementor-md-50 elementor-lg-50 elementor-xl-50">
                            <div class="explore-card" role="button" aria-label="Explore card <?php echo esc_attr( $index + 1 ); ?>">
                                <div class="explore-front">
                                    <?php if ( ! empty( $item['image']['url'] ) ): ?>
                                    <img src="<?php echo esc_url( $item['image']['url'] ); ?>" class="explore-image" alt="Explore image <?php echo esc_attr( $index + 1 ); ?>">
                                    <?php endif; ?>
                                </div>
                                <div class="explore-back">
                                    <p><?php echo esc_html( $item['description'] ); ?></p>
                                    <?php if ( ! empty( $item['button_text'] ) ): ?>
                                    <button><?php echo esc_html( $item['button_text'] ); ?></button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <?php
                    break;
                
            endswitch; ?>
        </section>
        <?php
    }
}
