<?php
add_action( 'wp_ajax_thha_post_grid_pagination', 'thha_post_grid_pagination' );
add_action( 'wp_ajax_nopriv_thha_post_grid_pagination', 'thha_post_grid_pagination' );
add_action( 'wp_ajax_thha_load_more_posts', 'thha_load_more_posts' );
add_action( 'wp_ajax_nopriv_thha_load_more_posts', 'thha_load_more_posts' );

function thha_post_grid_pagination() {
    if ( ! isset( $_POST['poatgrid_nonce'] ) ) {
        wp_send_json_error( [ 'message' => 'Missing nonce' ] );
    }

    $nonce = sanitize_text_field( wp_unslash( $_POST['poatgrid_nonce'] ) );
    if ( ! wp_verify_nonce( $nonce, 'thha_post_grid_nonce' ) ) {
        wp_send_json_error( [ 'message' => 'Invalid nonce' ] );
    }

    $settings = [];
    if ( isset( $_POST['settings'] ) && is_array( $_POST['settings'] ) ) {
        $unslashed_settings = wp_unslash( $_POST['settings'] );  // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
        foreach ( $unslashed_settings as $key => $value ) {
            if ( is_string( $value ) ) {
                $settings[ sanitize_key( $key ) ] = sanitize_text_field( $value );
            }
        }
    }

    $page = isset( $_POST['page'] ) ? intval( wp_unslash( $_POST['page'] ) ) : 1;
    $unique_id = isset( $_POST['container_id'] ) ? sanitize_text_field( wp_unslash( $_POST['container_id'] ) ) : '';

    require_once THHA_PLUGIN_PATH . 'includes/widgets/renders/render-thha-huge-post-grid-widget.php';
    ob_start();
    \HugeAddons\Widgets\Renders\render_thha_huge_post_grid_widget( $settings, $unique_id, $page );
    $html = ob_get_clean();

    wp_send_json_success( [ 'html' => $html ] );
}

function thha_load_more_posts() {
    if ( ! isset( $_POST['postgrid_nonce'] ) ) {
        wp_send_json_error( [ 'message' => 'Missing nonce' ] );
    }

    $nonce = sanitize_text_field( wp_unslash( $_POST['postgrid_nonce'] ) );
    if ( ! wp_verify_nonce( $nonce, 'thha_post_grid_nonce' ) ) {
        wp_send_json_error( [ 'message' => 'Invalid nonce' ] );
    }

    $settings = [];
    if ( isset( $_POST['settings'] ) && is_array( $_POST['settings'] ) ) {
        $unslashed_settings = wp_unslash( $_POST['settings'] );   // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
        foreach ( $unslashed_settings as $key => $value ) {
            if ( is_string( $value ) ) {
                $settings[ sanitize_key( $key ) ] = sanitize_text_field( $value );
            }
        }
    }

    $page = isset( $_POST['page'] ) ? intval( wp_unslash( $_POST['page'] ) ) : 1;
    $unique_id = isset( $_POST['container'] ) ? sanitize_text_field( wp_unslash( $_POST['container'] ) ) : '';

    require_once THHA_PLUGIN_PATH . 'includes/widgets/renders/render-thha-huge-post-grid-widget.php';
    ob_start();
    \HugeAddons\Widgets\Renders\render_thha_huge_post_grid_widget( $settings, $unique_id, $page, true ); 
    $html = ob_get_clean();

    echo wp_kses_post( $html );
    wp_die();
}

function thha_sanitize_recursive( $data ) {
    if ( is_array( $data ) ) {
        return array_map( 'thha_sanitize_recursive', $data );
    }

    return sanitize_text_field( $data );
}

