<?php

namespace HugeAddons;

if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

class Loader {

    public function init() {
        // add_action( 'init', [$this, 'thha_load_textdomain' ] );
        $this->register_widget_category();

        // Hook for admin-specific functionality
        // if ( is_admin() ) {
        //     $this->init_admin();
        // }
    
        add_action( 'elementor/icons_manager/additional_tabs', [$this, 'thha_load_huge_icon']);
    }

    public function thha_load_huge_icon( $tabs ) {
        $icon_dir = \THHA_URL . 'public/img/';
        $icon_path = \THHA_PLUGIN_PATH . '/public/img/';
        $icons = [];

        // List of icon files and titles
        $icon_files = [
            'accordion.svg'             => 'Accordion',
            'flip_box.svg'              => 'Flip Box',
            'advanced_icon_box.svg'     => 'Advance Icon Box',
            'post_grid.svg'             => 'Post Grid',
        ];

        foreach ( $icon_files as $file => $title ) {
            $svg_content = '';
            $svg_file = $icon_path . $file;
            if ( file_exists( $svg_file ) ) {
                $svg_content = file_get_contents( $svg_file );
            }
            $icons[] = [
                'name'  => 'hugeicon-' . basename( $file, '.svg' ),
                'title' => $title,
                'svg'   => $svg_content,
            ];
        }

        $tabs['huge_icons'] = [
            'name'          => 'huge_icons',
            'label'         => __( 'Huge Icons', 'huge-addons-for-elementor' ),
            'labelIcon'     => 'fa fa-star',
            'prefix'        => 'hugeicon-',
            'displayPrefix' => '',
            'url'           => false,
            'fetchJson'     => false,
            'icons'         => $icons,
            'ver'           => \THHA_VERSION,
        ];
        return $tabs;
    }


    private function register_widget_category() {
        add_action( 'elementor/elements/categories_registered', function ( $elements_manager ) {
            $elements_manager->add_category(
                'thha-addons-category',
                [
                    'title' => __( 'Huge Addons', 'huge-addons-for-elementor' ),
                    'icon'  => 'fa fa-plug',
                ]
            );
        } );
    }

    // private function init_admin() {
    //     require_once \THHA_PLUGIN_PATH . 'admin/Dashboard.php';
    //     $dashboard = new Admin\Dashboard();
    //     $dashboard->init();

    //     require_once \THHA_PLUGIN_PATH . 'classes/Addons_Manager.php';
    //     $addons_manager = new Classes\Addons_Manager();
    //     $addons_manager->init();
    // }

    private function get_class_name_from_file( $file ) {
        $base_name = basename( $file, '.php' );
        return 'HugeAddons\\Widgets\\' . $base_name;
    }
}
