<?php

namespace HugeAddons\Classes;

if ( ! defined( 'ABSPATH' ) ) exit;

class Utils {

  public function __construct(){
    $this->init();
  }


  public function init(){
    // Run necessary hooks from here 
  }

  /**
   * Custom kses function that extends wp_kses_post to allow for more tags and attributes.
   *
   * This is useful for allowing things like SVGs or data attributes that wp_kses_post
   * might strip out.
   *
   * @param string $content The content to sanitize.
   * @return string The sanitized content.
   */
  public static function thha_kses_post( $content ) {
    // Get the default allowed HTML for posts.
    $allowed_tags = wp_kses_allowed_html( 'post' );

    // Add support for SVG.
    $allowed_tags['svg'] = [
        'class'       => true,
        'aria-hidden' => true,
        'aria-labelledby' => true,
        'role'        => true,
        'xmlns'       => true,
        'width'       => true,
        'height'      => true,
        'viewbox'     => true, // Note: 'viewBox' will be lowercased by kses.
    ];

    $allowed_tags['path'] = [
        'd' => true,
        'fill' => true,
    ];

    // Add support for data-* attributes on common elements.
    $elements_with_data_attributes = [ 'div', 'a', 'span', 'button', 'i' ];
    foreach ( $elements_with_data_attributes as $tag ) {
        if ( ! isset( $allowed_tags[ $tag ] ) ) {
            $allowed_tags[ $tag ] = [];
        }
        // This is a wildcard to allow any data attribute.
        // Note: `wp_kses` doesn't support true wildcards like 'data-*'.
        // You would need to specify each one, e.g., 'data-id' => true.
        // However, this is a common way to represent the intent, and some
        // security plugins or custom filters might handle this.
        // For broad compatibility, we will add a filter to support it.
    }

    // Add a filter to dynamically allow 'data-*' attributes.
    add_filter( 'wp_kses_allowed_html', function( $allowed, $context ) use ( $elements_with_data_attributes ) {
        if ( 'post' === $context ) {
            foreach ( $GLOBALS['allowedposttags'] as $tag => $attributes ) {
                if ( in_array( $tag, $elements_with_data_attributes ) ) {
                    $allowed[ $tag ]['data-*'] = true;
                }
            }
        }
        return $allowed;
    }, 10, 2 );

    return wp_kses( $content, $allowed_tags );
  }

}