<?php
namespace HugeAddons\Classes;

if ( ! defined( 'ABSPATH' ) ) exit;
use HugeAddons\Classes\AbstractNoticeManager;

class NotificationManager extends AbstractNoticeManager {
    public function enqueue_scripts() {
        wp_enqueue_style(
            'thha-admin-notice-style',
            plugins_url( 'public/css/thha-admin-notice.min.css', THHA_PLUGIN_FILE ),
            [],
            THHA_VERSION
        );

        // Enqueue Admin Notice JavaScript
        wp_enqueue_script(
            'thha-admin-notice-script', 
            plugins_url( 'public/js/thha-admin-notice.min.js', THHA_PLUGIN_FILE ),
            ['jquery'], 
            THHA_VERSION,
            true 
        );

        wp_localize_script(
            'thha-admin-notice-script', 
            'thhaAdminNotice',
            [
                'ajaxurl' => admin_url('admin-ajax.php'),
                'nonce'   => wp_create_nonce('thha_dismiss_notice'),
            ]
        );
    }
}