<?php

namespace HugeAddons\Classes;
if ( ! defined( 'ABSPATH' ) ) exit;
use HugeAddons\Classes\AbstractNoticeManager;

class AdminNoticeManager extends AbstractNoticeManager {
    public function enqueue_scripts() {
        ?>
        <script>
        jQuery(function($){
            // Dismissible notices
            $(document).on('click', '.thha-notice-dismiss', function(){
                var $notice = $(this).closest('.thha-admin-notice');
                var id = $notice.data('unique-id');
                $notice.fadeOut();
                $.post(ajaxurl, {
                    action: 'thha_dismiss_notice',
                    unique_id: id,
                    _wpnonce: '<?php echo esc_js( wp_create_nonce( 'thha_dismiss_notice' ) ); ?>'
                });
            });
            // Auto-close notices
            $('.thha-admin-notice[data-autoclose="1"]').each(function(){
                var $notice = $(this);
                setTimeout(function(){
                    $notice.fadeOut();
                }, 20000);
            });
        });
        </script>
        <style>
        .thha-admin-notice { margin-top: 15px; }
        </style>
        <?php
    }
}