<?php
namespace HugeAddons\Classes;
if ( ! defined( 'ABSPATH' ) ) exit;


class Admin {
    public function __construct() {
        $this->init();
        add_action('admin_menu', [$this, 'add_admin_pages']);
        add_action('admin_enqueue_scripts', array( $this, 'enqueue_admin_assets' ) );
        
    }

    public function init(){
        $this->define_constants();
    }

    public function define_constants(){
        if( !defined('THHA_PRO_BADGE')){
            define('THHA_PRO_BADGE', '<span className="pro-badge">pro</span>');
        }
        if( !defined('THHA_UPCOMING_BADGE')){
            define('THHA_UPCOMING_BADGE', '<span className="upcoming-badge">UPCOMING</span>');
        }

    }

    public function add_admin_pages() {
        $hugeAddonsLogo = THHA_URL . 'public/img/icon.svg';
        add_menu_page(
            'Huge Addons',                 
            'Huge Addons',                 
            'manage_options',              
            'thha-addons-manager',         
            [$this, 'render_admin_page'], 
            $hugeAddonsLogo,    
            30                           
        );
        // add_submenu_page( 
        //     'thha-addons-manager', 
        //     'Settings', 
        //     'Settings', 
        //     'manage_options', 
        //     'thha-addons-manager-settings', 
        //     [$this, 'render_admin_page'], 
        //     30 
        // );
    }

    public function enqueue_admin_assets(){
        wp_enqueue_style(
            'thha-admin-style',
            THHA_URL . "public/css/thha-admin-style.min.css",
            array(), 
            THHA_VERSION, 
        );

        wp_enqueue_style(
            'izitoast',
            trailingslashit( THHA_URL ) . 'public/css/iziToast.min.css',
            array(),
            THHA_VERSION,
            'all'
        );

        wp_enqueue_script(
            'izitoast',
            trailingslashit( THHA_URL ) . 'public/js/iziToast.min.js',
            array('jquery'),
            THHA_VERSION,
            true
        );

        wp_enqueue_script(
            'thha-admin-script',
            THHA_URL . "public/js/thha-admin-script.min.js",
            array( 'jquery', 'izitoast' ),
            THHA_VERSION, 
            true 
        );

        $screen = get_current_screen();
        if( $screen->id  === 'toplevel_page_thha-addons-manager'){

            wp_enqueue_style(
                'thha-settings-style',
                THHA_URL . "public/css/thha-settings-app.min.css",
                array(), 
                THHA_VERSION, 
            );


            wp_enqueue_script(
                'thha-settings-script',
                THHA_URL . "public/js/thha-settings-app.min.js",
                array( 'izitoast'),
                THHA_VERSION, 
                true 
            );

            wp_set_script_translations('thha-settings-script', 'huge-addons-for-elementor', THHA_PLUGIN_PATH . 'languages');

            $hugeAddonsSettingsParams = [
                'ajaxurl' => admin_url('admin-ajax.php'),
                'nonce'   => wp_create_nonce('thha_settings_nonce'),
                'assets_url'   => THHA_URL . 'public/',
                'saveNonce'     => wp_create_nonce('thha_save_nonce'), 
                'adminPostUrl'  => admin_url('admin-post.php'), 
                'pluginUrl'     => THHA_URL,
                'pricing'       => 'https://hugeaddons.com',
                'version'       => THHA_VERSION
            ];
            wp_localize_script(
                'thha-settings-script', 
                'thhaAdminSettings',
                $hugeAddonsSettingsParams
            );

            wp_enqueue_style(
                'dm-sans-font',
                'https://fonts.googleapis.com/css2?family=DM+Sans:opsz,wght@9..40,100..1000&display=swap',
                array(),
                null,
                'all'
            );
        }
    }


    public function render_admin_page() {
        ?>
        <div class="wrap">
            <h1 class="title" style="display:none;">Huge Addons</h1>
            <div id="huge-addons-settings-app" class="huge-addons-settings-app"></div>
        </div>
        <?php
    }
}
?>